/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private double bytes;

    public final double getBytes() {
        return this.bytes;
    }

    public ConstantDouble(double bytes) {
        super((byte)6);
        this.bytes = bytes;
    }

    public final void setBytes(double bytes) {
        this.bytes = bytes;
    }

    ConstantDouble(DataInputStream file) throws IOException {
        this(file.readDouble());
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeDouble(this.bytes);
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public ConstantDouble(ConstantDouble c) {
        this(c.getBytes());
    }

    public void accept(Visitor v) {
        v.visitConstantDouble(this);
    }

    public Object getConstantValue(ConstantPool cp) {
        return new Double(this.bytes);
    }
}

