/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.jsptl.lang.spel.Evaluator;
import org.apache.taglibs.jsptl.lang.spel.ParsedExpression;

public class ParserTest {
    public static void runTests(DataInput dataInput, PrintStream printStream) throws IOException {
        String string;
        while ((string = dataInput.readLine()) != null) {
            if (string.startsWith("#") || "".equals(string.trim())) {
                printStream.println(string);
                continue;
            }
            printStream.println("Expression: " + string);
            try {
                ParsedExpression parsedExpression = Evaluator.getOrParseExpression(string);
                printStream.println("Parses to: " + parsedExpression.getExpression().getExpressionString());
            }
            catch (JspException jspException) {
                printStream.println("Causes an error: " + (Object)((Object)jspException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTests(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            try {
                fileOutputStream = new FileOutputStream(file2);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                PrintStream printStream = new PrintStream(bufferedOutputStream);
                ParserTest.runTests(dataInputStream, printStream);
                printStream.flush();
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static boolean isDifferentFiles(DataInput dataInput, DataInput dataInput2) throws IOException {
        String string;
        String string2;
        do {
            string2 = dataInput.readLine();
            string = dataInput2.readLine();
            if (string2 == null && string == null) {
                return false;
            }
            if (string2 != null && string != null) continue;
            return true;
        } while (string2.equals(string));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDifferentFiles(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            boolean bl;
            block8: {
                fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                FileInputStream fileInputStream2 = null;
                try {
                    fileInputStream2 = new FileInputStream(file2);
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(fileInputStream2);
                    DataInputStream dataInputStream2 = new DataInputStream(bufferedInputStream2);
                    bl = ParserTest.isDifferentFiles(dataInputStream, dataInputStream2);
                    if (fileInputStream2 == null) break block8;
                }
                catch (Throwable throwable) {
                    if (fileInputStream2 != null) {
                        fileInputStream2.close();
                    }
                    throw throwable;
                }
                fileInputStream2.close();
            }
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2 && stringArray.length != 3) {
            ParserTest.usage();
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        ParserTest.runTests(file, file2);
        if (stringArray.length > 2) {
            File file3 = new File(stringArray[2]);
            if (ParserTest.isDifferentFiles(file2, file3)) {
                System.out.println("Test failure - output file " + file2 + " differs from expected output file " + file3);
            } else {
                System.out.println("tests passed");
            }
        }
    }

    static void usage() {
        System.err.println("usage: java org.apache.taglibs.jsptl.lang.spel.test.ParserTest {input file} {output file} [{compare file}]");
    }
}

