/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.spel.Evaluator;
import org.apache.taglibs.jsptl.lang.spel.test.Bean1;
import org.apache.taglibs.jsptl.lang.spel.test.PageContextImpl;
import org.apache.taglibs.jsptl.lang.spel.test.beans.Factory;

public class EvaluationTest {
    public static void runTests(DataInput dataInput, PrintStream printStream) throws IOException {
        String string;
        PageContext pageContext = EvaluationTest.createTestContext();
        while ((string = dataInput.readLine()) != null) {
            if (string.startsWith("#") || "".equals(string.trim())) {
                printStream.println(string);
                continue;
            }
            String string2 = dataInput.readLine();
            printStream.println("Expression: " + string);
            try {
                Class clazz = EvaluationTest.parseClassName(string2);
                printStream.println("ExpectedType: " + clazz);
                Evaluator evaluator = new Evaluator();
                Object object = evaluator.evaluate(string, pageContext, clazz);
                printStream.println("Parses to: " + object);
                if (object != null) {
                    printStream.println("With type: " + object.getClass().getName());
                }
                printStream.println();
            }
            catch (JspException jspException) {
                printStream.println("Causes an error: " + (Object)((Object)jspException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                printStream.println("Causes an error: " + classNotFoundException);
            }
        }
    }

    static Class parseClassName(String string) throws ClassNotFoundException {
        String string2 = string.trim();
        if ("boolean".equals(string2)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(string2)) {
            return Byte.TYPE;
        }
        if ("char".equals(string2)) {
            return Character.TYPE;
        }
        if ("short".equals(string2)) {
            return Short.TYPE;
        }
        if ("int".equals(string2)) {
            return Integer.TYPE;
        }
        if ("long".equals(string2)) {
            return Long.TYPE;
        }
        if ("float".equals(string2)) {
            return Float.TYPE;
        }
        if ("double".equals(string2)) {
            return Double.TYPE;
        }
        return Class.forName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTests(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            try {
                fileOutputStream = new FileOutputStream(file2);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                PrintStream printStream = new PrintStream(bufferedOutputStream);
                EvaluationTest.runTests(dataInputStream, printStream);
                printStream.flush();
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static boolean isDifferentFiles(DataInput dataInput, DataInput dataInput2) throws IOException {
        String string;
        String string2;
        do {
            string2 = dataInput.readLine();
            string = dataInput2.readLine();
            if (string2 == null && string == null) {
                return false;
            }
            if (string2 != null && string != null) continue;
            return true;
        } while (string2.equals(string));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDifferentFiles(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            boolean bl;
            block8: {
                fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                FileInputStream fileInputStream2 = null;
                try {
                    fileInputStream2 = new FileInputStream(file2);
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(fileInputStream2);
                    DataInputStream dataInputStream2 = new DataInputStream(bufferedInputStream2);
                    bl = EvaluationTest.isDifferentFiles(dataInputStream, dataInputStream2);
                    if (fileInputStream2 == null) break block8;
                }
                catch (Throwable throwable) {
                    if (fileInputStream2 != null) {
                        fileInputStream2.close();
                    }
                    throw throwable;
                }
                fileInputStream2.close();
            }
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    static PageContext createTestContext() {
        PageContextImpl pageContextImpl = new PageContextImpl();
        pageContextImpl.setAttribute("val1a", "page-scoped1", 1);
        pageContextImpl.setAttribute("val1b", "request-scoped1", 2);
        pageContextImpl.setAttribute("val1c", "session-scoped1", 3);
        pageContextImpl.setAttribute("val1d", "app-scoped1", 4);
        Bean1 bean1 = new Bean1();
        bean1.setBoolean1(true);
        bean1.setByte1((byte)12);
        bean1.setShort1((short)-124);
        bean1.setChar1('b');
        bean1.setInt1(4);
        bean1.setLong1(222423L);
        bean1.setFloat1(12.4f);
        bean1.setDouble1(89.224);
        bean1.setString1("hello");
        pageContextImpl.setAttribute("bean1a", bean1);
        Bean1 bean12 = new Bean1();
        bean12.setInt2(new Integer(-224));
        bean12.setString2("bean2's string");
        bean1.setBean1(bean12);
        Bean1 bean13 = new Bean1();
        bean13.setDouble1(1422.332);
        bean13.setString2("bean3's string");
        bean12.setBean2(bean13);
        pageContextImpl.setAttribute("pbean1", Factory.createBean1());
        pageContextImpl.setAttribute("pbean2", Factory.createBean2());
        pageContextImpl.setAttribute("pbean3", Factory.createBean3());
        pageContextImpl.setAttribute("pbean4", Factory.createBean4());
        pageContextImpl.setAttribute("pbean5", Factory.createBean5());
        pageContextImpl.setAttribute("pbean6", Factory.createBean6());
        pageContextImpl.setAttribute("pbean7", Factory.createBean7());
        return pageContextImpl;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2 && stringArray.length != 3) {
            EvaluationTest.usage();
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        EvaluationTest.runTests(file, file2);
        if (stringArray.length > 2) {
            File file3 = new File(stringArray[2]);
            if (EvaluationTest.isDifferentFiles(file2, file3)) {
                System.out.println("Test failure - output file " + file2 + " differs from expected output file " + file3);
            } else {
                System.out.println("tests passed");
            }
        }
    }

    static void usage() {
        System.err.println("usage: java org.apache.taglibs.jsptl.lang.spel.test.EvaluationTest {input file} {output file} [{compare file}]");
    }
}

