/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class Scope {
    static final int UNSCOPED_VALUE = 1;
    static final int PAGE_VALUE = 2;
    static final int REQUEST_VALUE = 3;
    static final int SESSION_VALUE = 4;
    static final int APP_VALUE = 5;
    static final int HEADER_VALUE = 6;
    static final int PARAM_VALUE = 7;
    static final int PARAMVALUES_VALUE = 8;
    public static final Scope UNSCOPED = new Scope(1);
    public static final Scope PAGE = new Scope(2);
    public static final Scope REQUEST = new Scope(3);
    public static final Scope SESSION = new Scope(4);
    public static final Scope APP = new Scope(5);
    public static final Scope HEADER = new Scope(6);
    public static final Scope PARAM = new Scope(7);
    public static final Scope PARAMVALUES = new Scope(8);
    int mScope;

    public int getScope() {
        return this.mScope;
    }

    Scope(int n) {
        this.mScope = n;
    }

    Object getAttributeValue(String string, PageContext pageContext) {
        switch (this.mScope) {
            case 1: {
                return pageContext.findAttribute(string);
            }
            case 2: {
                return pageContext.getAttribute(string, 1);
            }
            case 3: {
                return pageContext.getAttribute(string, 2);
            }
            case 4: {
                return pageContext.getAttribute(string, 3);
            }
            case 5: {
                return pageContext.getAttribute(string, 4);
            }
            case 6: {
                return ((HttpServletRequest)pageContext.getRequest()).getHeader(string);
            }
            case 7: {
                return pageContext.getRequest().getParameter(string);
            }
            case 8: {
                return pageContext.getRequest().getParameterValues(string);
            }
        }
        return null;
    }

    public String getScopeName() {
        switch (this.mScope) {
            case 1: {
                return "page/request/session/app";
            }
            case 2: {
                return "page";
            }
            case 3: {
                return "request";
            }
            case 4: {
                return "session";
            }
            case 5: {
                return "app";
            }
            case 6: {
                return "header";
            }
            case 7: {
                return "param";
            }
            case 8: {
                return "paramvalues";
            }
        }
        return "??";
    }

    public String toString() {
        switch (this.mScope) {
            case 1: {
                return ":";
            }
            case 2: {
                return "page:";
            }
            case 3: {
                return "request:";
            }
            case 4: {
                return "session:";
            }
            case 5: {
                return "app:";
            }
            case 6: {
                return "header:";
            }
            case 7: {
                return "param:";
            }
            case 8: {
                return "paramvalues:";
            }
        }
        return ":";
    }
}

