/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Node;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.ParserConstants;
import org.apache.taglibs.jsptl.lang.jpath.expression.ParserTreeConstants;
import org.apache.taglibs.jsptl.lang.jpath.expression.Token;
import org.apache.taglibs.jsptl.lang.jpath.expression.ValidationException;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    protected String image;
    protected int beginColumn;
    protected int endColumn;
    protected int beginLine;
    protected int endLine;
    protected Token firstToken;
    protected Token lastToken;
    protected Object val;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public String stringDump(String string) {
        String string2 = string + this.toString() + "\n";
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                string2 = string2 + simpleNode.stringDump(string + "     ");
            }
        }
        return string2;
    }

    public String toNormalizedString() {
        String string = "toNormalizedString() not implemented in [" + ParserTreeConstants.jjtNodeName[this.id] + "]";
        return string;
    }

    public String toOriginalString() {
        String string = "";
        Token token = this.firstToken;
        boolean bl = false;
        while (!bl) {
            string = string + this.getSpecialTokenString(token);
            if (token.image != null) {
                while (string.length() < token.beginColumn - 1) {
                    string = string + " ";
                }
                string = string + token.image;
            }
            if (token == this.lastToken) {
                bl = true;
                continue;
            }
            token = token.next;
        }
        return string;
    }

    public String rootOriginalString() {
        SimpleNode simpleNode = this;
        while (simpleNode.parent != null) {
            simpleNode = (SimpleNode)simpleNode.parent;
        }
        return simpleNode.toOriginalString();
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext) throws EvaluationException {
        throw new EvaluationException(this, "evaluate not supported in  [" + ParserTreeConstants.jjtNodeName[this.id] + "]");
    }

    public String getTokenImage(int n) {
        String string = ParserConstants.tokenImage[n];
        return string.substring(1, string.length() - 1);
    }

    private String getSpecialTokenString(Token token) {
        String string = token.specialToken == null ? "" : this.getSpecialTokenString(token) + token.image;
        return string;
    }

    public void validate() throws ValidationException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.validate();
            }
        }
    }

    public Node simplify() {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode = (SimpleNode)simpleNode.simplify();
            }
        }
        return this;
    }
}

