/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.jsptl.lang.jpath.adapter.Convert;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.SimpleNode;

public class FormatNumberFunction
extends SimpleNode {
    public FormatNumberFunction(int n) {
        super(n);
    }

    public FormatNumberFunction(Parser parser, int n) {
        super(parser, n);
    }

    public String toNormalizedString() {
        String string = "";
        string = "format-number(" + this.jjtGetChild(0).toNormalizedString() + this.jjtGetChild(1).toNormalizedString() + "," + ")";
        return string;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext) throws EvaluationException {
        String string;
        try {
            NumberFormat numberFormat;
            Double d = Convert.toDouble(this.jjtGetChild(0).evaluate(pageContext, iterationContext));
            String string2 = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, iterationContext));
            if (this.jjtGetNumChildren() > 2) {
                String string3 = Convert.toString(this.jjtGetChild(2).evaluate(pageContext, iterationContext));
                Locale locale = this.getLocale(string3);
                numberFormat = NumberFormat.getInstance(locale);
            } else {
                numberFormat = NumberFormat.getInstance();
            }
            try {
                ((DecimalFormat)numberFormat).applyPattern(string2);
                string = numberFormat.format(d);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = new String("NaN");
            }
        }
        catch (ConversionException conversionException) {
            throw new EvaluationException(this, conversionException.getMessage());
        }
        return string;
    }

    private Locale getLocale(String string) {
        Locale locale;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    locale = new Locale(string2, string3, string4);
                } else {
                    locale = new Locale(string2, string3);
                }
            } else {
                locale = new Locale(string2, "");
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

