/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.jsptl.lang.jpath.adapter.Convert;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.SimpleNode;

public class FormatDateFunction
extends SimpleNode {
    public FormatDateFunction(int n) {
        super(n);
    }

    public FormatDateFunction(Parser parser, int n) {
        super(parser, n);
    }

    public String toNormalizedString() {
        String string = "";
        string = "format-date(" + this.jjtGetChild(0).toNormalizedString() + this.jjtGetChild(1).toNormalizedString() + "," + ")";
        return string;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext) throws EvaluationException {
        String string;
        try {
            DateFormat dateFormat;
            JSPDate jSPDate = Convert.toJSPDate(this.jjtGetChild(0).evaluate(pageContext, iterationContext));
            String string2 = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, iterationContext));
            if (this.jjtGetNumChildren() > 2) {
                String string3 = Convert.toString(this.jjtGetChild(2).evaluate(pageContext, iterationContext));
                Locale locale = this.getLocale(string3);
                dateFormat = DateFormat.getDateInstance(2, locale);
            } else {
                dateFormat = DateFormat.getInstance();
            }
            try {
                ((SimpleDateFormat)dateFormat).applyPattern(string2);
                string = dateFormat.format(new Date(jSPDate.getTime().longValue()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = new String("");
            }
        }
        catch (ConversionException conversionException) {
            throw new EvaluationException(this, conversionException.getMessage());
        }
        return string;
    }

    private Locale getLocale(String string) {
        Locale locale;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    locale = new Locale(string2, string3, string4);
                } else {
                    locale = new Locale(string2, string3);
                }
            } else {
                locale = new Locale(string2, "");
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

