/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsptl;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsptl.IteratorTag;
import javax.servlet.jsptl.IteratorTagStatus;

public abstract class IteratorTagSupport
extends TagSupport
implements IteratorTag,
BodyTag {
    protected int begin;
    protected int end;
    protected int step;
    protected boolean beginSpecified;
    protected boolean endSpecified;
    protected boolean stepSpecified;
    protected String itemId;
    protected String statusId;
    BodyContent bodyContent;
    private IteratorTagStatus status;
    private Object item;
    private int index;
    private int count;
    private boolean last;

    public IteratorTagSupport() {
        this.init();
    }

    protected abstract Object next() throws JspTagException;

    protected abstract boolean hasNext() throws JspTagException;

    public void release() {
        super.release();
        this.init();
    }

    public int doStartTag() throws JspException {
        if (this.end != -1 && this.begin > this.end) {
            return 0;
        }
        this.index = 0;
        this.count = 1;
        this.last = false;
        this.discardIgnoreSubset(this.begin);
        if (!this.hasNext()) {
            return 0;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 2;
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void doInitBody() {
    }

    public int doEndTag() throws JspException {
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
        }
        catch (IOException iOException) {
            throw new JspException("Error: " + iOException.getMessage());
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        this.index += this.step - 1;
        ++this.count;
        if (this.hasNext() && !this.atEnd()) {
            ++this.index;
        } else {
            return 0;
        }
        this.item = this.next();
        this.discard(this.step - 1);
        this.exposeVariables();
        this.calibrateLast();
        return 2;
    }

    public void doFinally() {
        this.unExposeVariables();
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public Object getCurrent() {
        return this.item;
    }

    public IteratorTagStatus getIteratorStatus() {
        if (this.status == null) {
            class Status
            implements IteratorTagStatus {
                Status() {
                }

                public Object getCurrent() {
                    return IteratorTagSupport.this.getCurrent();
                }

                public int getIndex() {
                    return IteratorTagSupport.this.index + IteratorTagSupport.this.begin;
                }

                public int getCount() {
                    return IteratorTagSupport.this.count;
                }

                public boolean isFirst() {
                    return IteratorTagSupport.this.index == 0;
                }

                public boolean isLast() {
                    return IteratorTagSupport.this.last;
                }

                public boolean isBeginSpecified() {
                    return IteratorTagSupport.this.beginSpecified;
                }

                public boolean isEndSpecified() {
                    return IteratorTagSupport.this.endSpecified;
                }

                public boolean isStepSpecified() {
                    return IteratorTagSupport.this.stepSpecified;
                }

                public int getBegin() {
                    return IteratorTagSupport.this.begin;
                }

                public int getEnd() {
                    return IteratorTagSupport.this.end;
                }

                public int getStep() {
                    return IteratorTagSupport.this.step;
                }
            }
            this.status = new Status();
        }
        return this.status;
    }

    public void setVar(String string) {
        this.itemId = string;
    }

    public void setStatus(String string) {
        this.statusId = string;
    }

    protected void validateBegin() throws JspTagException {
        if (this.begin < 0) {
            throw new JspTagException("'begin' in iteration tag cannot be negative");
        }
    }

    protected void validateEnd() throws JspTagException {
        if (this.begin < 0) {
            throw new JspTagException("'end' in iteration tag cannot be negative");
        }
    }

    protected void validateStep() throws JspTagException {
        if (this.step < 1) {
            throw new JspTagException("'step' in iteration tag cannot be negative or zero");
        }
    }

    private void init() {
        this.index = 0;
        this.count = 1;
        this.status = null;
        this.item = null;
        this.last = false;
        this.beginSpecified = false;
        this.endSpecified = false;
        this.stepSpecified = false;
        this.begin = 0;
        this.end = -1;
        this.step = 1;
        this.itemId = null;
        this.statusId = null;
    }

    private void calibrateLast() throws JspTagException {
        this.last = !this.hasNext() || this.atEnd() || this.end != -1 && this.begin + this.index + this.step > this.end;
    }

    private void exposeVariables() throws JspTagException {
        if (this.itemId != null) {
            if (this.getCurrent() == null) {
                this.pageContext.removeAttribute(this.itemId);
            } else {
                this.pageContext.setAttribute(this.itemId, this.getCurrent());
            }
        }
        if (this.statusId != null) {
            if (this.getIteratorStatus() == null) {
                this.pageContext.removeAttribute(this.statusId);
            } else {
                this.pageContext.setAttribute(this.statusId, (Object)this.getIteratorStatus());
            }
        }
    }

    private void unExposeVariables() {
        if (this.itemId != null) {
            this.pageContext.removeAttribute(this.itemId, 1);
        }
        if (this.statusId != null) {
            this.pageContext.removeAttribute(this.statusId, 1);
        }
    }

    private void discard(int n) throws JspTagException {
        int n2 = this.index;
        while (n-- > 0 && !this.atEnd() && this.hasNext()) {
            ++this.index;
            this.next();
        }
        this.index = n2;
    }

    private void discardIgnoreSubset(int n) throws JspTagException {
        while (n-- > 0 && this.hasNext()) {
            this.next();
        }
    }

    private boolean atEnd() {
        return this.end != -1 && this.begin + this.index >= this.end;
    }
}

