/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.util;

import com.sun.portal.common.util.TimeBoundRunnable;
import com.sun.portal.common.util.TimeBoundRunnableException;
import com.sun.portal.common.util.TimeoutException;

public class TimeBoundExecutor {
    private boolean _destroyed = false;

    public void run(TimeBoundRunnable runnable, int timeout) throws TimeoutException, TimeBoundRunnableException {
        if (this._destroyed) {
            throw new IllegalStateException("TimeBoundExecutor.run - Executor destroyed");
        }
        if (timeout == -1) {
            runnable.run();
        } else {
            TBRunnable tbRunnable = new TBRunnable(runnable);
            Thread thread = new Thread(tbRunnable);
            thread.start();
            try {
                thread.join(timeout);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!tbRunnable.isDone()) {
                throw new TimeoutException();
            }
            TimeBoundRunnableException ex = tbRunnable.getException();
            if (ex != null) {
                throw ex;
            }
        }
    }

    public void destroy() {
        this._destroyed = true;
    }

    private static class TBRunnable
    implements Runnable {
        private TimeBoundRunnable _runnable;
        private boolean _finished;
        private TimeBoundRunnableException _exception;

        private TBRunnable(TimeBoundRunnable runnable) {
            this._runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._runnable.run();
            }
            catch (TimeBoundRunnableException ex) {
                this._exception = ex;
            }
            finally {
                this._finished = true;
            }
        }

        public boolean isDone() {
            return this._finished;
        }

        public TimeBoundRunnableException getException() {
            return this._exception;
        }
    }
}

