/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.text;

import java.util.ArrayList;

public class QuickMessageFormat {
    private int estimatedLength;
    private String[] chunk;
    private int[] variable;

    public QuickMessageFormat(String template) {
        int i;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> chunkL = new ArrayList<String>();
        ArrayList<Integer> variableL = new ArrayList<Integer>();
        int state = 0;
        block17: for (i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '{': {
                            state = 1;
                            chunkL.add(sb.toString());
                            sb.delete(0, sb.length());
                            continue block17;
                        }
                        case '\'': {
                            state = 2;
                            continue block17;
                        }
                        case '\\': {
                            state = 3;
                            continue block17;
                        }
                    }
                    sb.append(c);
                    continue block17;
                }
                case 1: {
                    switch (c) {
                        case '}': {
                            state = 0;
                            Integer v = new Integer(sb.toString());
                            variableL.add(v);
                            sb.delete(0, sb.length());
                            continue block17;
                        }
                    }
                    sb.append(c);
                    continue block17;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            continue block17;
                        }
                    }
                    sb.append(c);
                    continue block17;
                }
                case 3: {
                    sb.append(c);
                    state = 0;
                }
            }
        }
        chunkL.add(sb.toString());
        this.chunk = new String[chunkL.size()];
        chunkL.toArray(this.chunk);
        this.variable = new int[variableL.size()];
        for (i = 0; i < this.variable.length; ++i) {
            this.variable[i] = (Integer)variableL.get(i);
        }
        this.estimatedLength = template.length() + this.variable.length * 15;
    }

    public String format(String[] values) {
        StringBuffer sb = new StringBuffer(this.estimatedLength);
        sb.append(this.chunk[0]);
        for (int i = 0; i < this.variable.length; ++i) {
            sb.append(values[this.variable[i]]);
            sb.append(this.chunk[i + 1]);
        }
        return sb.toString();
    }

    public String format(String value) {
        StringBuffer sb = new StringBuffer(this.estimatedLength);
        sb.append(this.chunk[0]);
        for (int i = 0; i < this.variable.length; ++i) {
            if (this.variable[i] == 0) {
                sb.append(value);
            }
            sb.append(this.chunk[i + 1]);
        }
        return sb.toString();
    }

    public static String format(String pattern, String value) {
        QuickMessageFormat qmf = new QuickMessageFormat(pattern);
        return qmf.format(value);
    }

    public static String format(String pattern, String[] values) {
        QuickMessageFormat qmf = new QuickMessageFormat(pattern);
        return qmf.format(values);
    }
}

