/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.pool;

import com.sun.portal.common.concurrent.LockWithMemory;
import com.sun.portal.common.pool.PartitionObject;
import com.sun.portal.common.pool.ThreadPool;

public class ReusableThread
implements Runnable,
PartitionObject {
    private ThreadPool _ownerPool;
    private Thread _thread;
    private boolean _running = true;
    private LockWithMemory _begin = new LockWithMemory();
    private LockWithMemory _end = new LockWithMemory();
    private Runnable _runnable = null;
    private boolean _executing = false;
    private int _partition;
    private boolean _reuse = true;

    public ReusableThread() {
        this(null);
    }

    ReusableThread(ThreadPool ownerPool) {
        this._ownerPool = ownerPool;
        this._thread = new Thread(this);
        this._thread.setDaemon(true);
        this._thread.start();
    }

    void setReuseThread(boolean b) {
        this._reuse = b;
    }

    public void setPartition(int partition) {
        this._partition = partition;
    }

    public int getPartition() {
        return this._partition;
    }

    void setRunnable(Runnable runnable) {
        this._runnable = runnable;
        this._executing = false;
    }

    public void start() {
        this._begin.signal();
        this._executing = true;
    }

    public void join() {
        this.join(0L, 0);
    }

    public void join(long timeout) {
        this.join(timeout, 0);
    }

    public void join(long timeout, int nanos) {
        if (this._runnable != null) {
            this._end.waitFor(timeout, nanos);
        }
    }

    public boolean isAlive() {
        return this._executing;
    }

    void finish() {
        this._running = false;
        this._begin.signal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this._running) {
                try {
                    this._begin.waitFor();
                    if (!this._running) continue;
                    try {
                        if (this._runnable != null) {
                            this._runnable.run();
                        }
                    }
                    catch (Throwable ex1) {
                        System.out.println("ReusableThread.run(), ex1: " + ex1);
                    }
                    this._running = this._reuse;
                    this._end.signal();
                    this._executing = false;
                    if (this._ownerPool == null) continue;
                    this._ownerPool.releaseThread(this);
                }
                catch (Exception ex2) {
                    System.out.println("ReusableThread.run(), ex2: " + ex2);
                }
            }
            return;
        }
        catch (Exception ex3) {
            System.out.println("ReusableThread.run(), ex3: " + ex3);
        }
    }
}

