/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.logging.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class LogOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    long written = 0L;
    int size;
    protected static final String lineSeparator = System.getProperty("line.separator", "\n");
    File outfile;
    long rollover;
    final int NUMFILES = 9;
    private FileOutputStream out;
    private int flushtime = 0;
    private Date lastflush = new Date();
    private Timer _timer;

    public LogOutputStream(File outfile, long rollover, int size, int flushtime) throws IOException {
        File logDir;
        this.buf = new byte[size];
        this.rollover = rollover;
        this.outfile = outfile;
        this.flushtime = flushtime;
        if (outfile.getParent() != null && !(logDir = new File(outfile.getParent())).exists()) {
            logDir.mkdirs();
            if (!logDir.exists()) {
                throw new FileNotFoundException(MessageFormat.format("Cannot create log directory {0}. Make sure that the parent directory has the correct permissions", logDir));
            }
        }
        if (outfile.exists()) {
            if (!outfile.canWrite()) {
                throw new FileNotFoundException(MessageFormat.format("Cannot write to log file {0}. Make sure that the  file has the correct permissions", outfile));
            }
            if (outfile.isDirectory()) {
                throw new FileNotFoundException(MessageFormat.format("Cannot write to log file {0} because it is a directory, not a file", outfile));
            }
        }
        if (rollover != 0L && outfile.length() >= rollover) {
            this.rolloverFile();
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(outfile, "rw");
        }
        catch (IOException exc) {
            throw new FileNotFoundException(MessageFormat.format("Cannot write to log file {0}. Make sure that the file has the correct permissions", outfile));
        }
        raf.seek(raf.length());
        this.out = new FileOutputStream(raf.getFD());
        if (flushtime > 0) {
            MyTimerTask task = new MyTimerTask();
            this._timer = new Timer(true);
            this._timer.schedule((TimerTask)task, 1L, (long)flushtime * 1000L);
        }
    }

    public LogOutputStream(File outfile) throws IOException {
        this(outfile, 100000L, 512, 0);
    }

    public LogOutputStream(File outfile, long rollover, int buffer) throws IOException {
        this(outfile, rollover, buffer, 0);
    }

    public synchronized void write(int b) throws IOException {
        ++this.written;
        if (this.buf.length > 0) {
            if (this.count == this.buf.length) {
                this.flush();
            }
            this.buf[this.count++] = (byte)b;
        } else {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int avail = this.buf.length - this.count;
        this.written += (long)len;
        if (len <= avail) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        } else {
            this.flush();
            this.out.write(b, off, len);
        }
        if (this.rollover != 0L && this.written >= this.rollover) {
            this.flush();
            this.rolloverFile();
        }
    }

    public synchronized void flush() throws IOException {
        if (this.flushtime != 0) {
            this.lastflush = new Date();
        }
        this.out.write(this.buf, 0, this.count);
        this.out.flush();
        this.count = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
        this._timer.cancel();
    }

    void rolloverFile() throws IOException {
        File newfile;
        File testfile;
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if ((testfile = new File(this.outfile.getAbsolutePath() + "." + 9)).exists()) {
            testfile.delete();
        }
        for (int i = 8; i > 0; --i) {
            testfile = new File(this.outfile.getAbsolutePath() + "." + i);
            if (!testfile.exists()) continue;
            newfile = new File(this.outfile.getAbsolutePath() + "." + (i + 1));
            testfile.renameTo(newfile);
        }
        newfile = new File(this.outfile.getAbsolutePath() + ".1");
        this.outfile.renameTo(newfile);
        this.out = new FileOutputStream(this.outfile);
        this.written = 0L;
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        public void run() {
            if (LogOutputStream.this.flushtime == 0) {
                return;
            }
            if (this.scheduledExecutionTime() >= LogOutputStream.this.lastflush.getTime() + (long)(LogOutputStream.this.flushtime * 1000)) {
                try {
                    LogOutputStream.this.flush();
                }
                catch (IOException ioe) {
                    System.err.println("Autoflush: error writing to log file " + LogOutputStream.this.outfile);
                    ioe.printStackTrace(System.err);
                }
            }
        }
    }
}

