/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.concurrent;

import com.sun.portal.common.concurrent.ConsumerProducer;

public class Semaphore {
    private int _maxConcurrentUsers;
    private int _currentUsers;
    private ConsumerProducer _queue;

    public Semaphore(int maxConcurrentUsers) {
        if (maxConcurrentUsers < 0) {
            throw new IllegalArgumentException("Semaphore <init> - maxConcurrentUsers has to be 0 or greater");
        }
        this._maxConcurrentUsers = maxConcurrentUsers;
        this._currentUsers = 0;
    }

    public int getMaxConcurrentUsers() {
        return this._maxConcurrentUsers;
    }

    public int getCurrentUsers() {
        return this._currentUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sWait() throws InterruptedException {
        if (this._maxConcurrentUsers > 0) {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                ++this._currentUsers;
                if (this._currentUsers > this._maxConcurrentUsers) {
                    this.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sSignal() {
        if (this._maxConcurrentUsers > 0) {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                if (this._currentUsers > 0) {
                    --this._currentUsers;
                }
                this.notify();
            }
        }
    }
}

