/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.concurrent;

import java.util.ArrayList;
import java.util.List;

public class ConsumerProducer {
    private List _queue;
    private int _stopLimit = 0;
    private int _resumeLimit = 0;
    private Threshold _threshold = null;
    private boolean _reachedLimit = false;

    public ConsumerProducer() {
        this(0, 0, null);
    }

    public ConsumerProducer(int stopLimit, int resumeLimit, Threshold threshold) {
        this._stopLimit = stopLimit;
        this._resumeLimit = resumeLimit;
        this._threshold = threshold;
        this._queue = new ArrayList(100);
    }

    public synchronized void put(Object o) {
        this._queue.add(o);
        int size = this._queue.size();
        if (size == 1) {
            this.notify();
        }
        if (this._threshold != null && this._stopLimit > 0 && size > this._stopLimit) {
            this._threshold.reachedStopLimit();
            this._reachedLimit = true;
        }
    }

    public synchronized Object get() {
        int size = this._queue.size();
        if (size == 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._reachedLimit && size < this._resumeLimit) {
            this._threshold.reachedResumeLimit();
            this._reachedLimit = false;
        }
        Object o = this._queue.get(0);
        this._queue.remove(0);
        return o;
    }

    public boolean isEmpty() {
        return this._queue.size() == 0;
    }

    public synchronized void empty() {
        this._queue.clear();
        this._reachedLimit = false;
    }

    public static interface Threshold {
        public void reachedStopLimit();

        public void reachedResumeLimit();
    }
}

