/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TimeBoundHashMap
extends HashMap {
    private long _timeOut;
    private long _lastCheck;
    private Map _lastAccess;

    public TimeBoundHashMap(int timeOut) {
        this.init(timeOut);
    }

    public TimeBoundHashMap(int initialCapacity, int timeOut) {
        super(initialCapacity);
        this.init(timeOut);
    }

    public TimeBoundHashMap(int initialCapacity, float loadFactor, int timeOut) {
        super(initialCapacity, loadFactor);
        this.init(timeOut);
    }

    public Object put(Object key, Object value) {
        long currentTime = System.currentTimeMillis();
        this._lastAccess.put(key, new Long(currentTime));
        this.purge();
        return super.put(key, value);
    }

    public Object get(Object key) {
        Object obj = super.get(key);
        if (obj != null) {
            long currentTime = System.currentTimeMillis();
            this._lastAccess.put(key, new Long(currentTime));
        }
        this.purge();
        return obj;
    }

    public Object remove(Object key) {
        this._lastAccess.remove(key);
        return super.remove(key);
    }

    public Set entrySet() {
        Set set = super.entrySet();
        Iterator i = this._lastAccess.keySet().iterator();
        Long currentTime = new Long(System.currentTimeMillis());
        while (i.hasNext()) {
            this._lastAccess.put(i.next(), currentTime);
        }
        return set;
    }

    private void init(int timeOut) {
        this._timeOut = timeOut * 1000;
        this._lastCheck = System.currentTimeMillis();
        this._lastAccess = new HashMap();
    }

    private void purge() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastCheck > this._timeOut / 8L) {
            Iterator i = this._lastAccess.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                long lastTime = (Long)this._lastAccess.get(key);
                if (currentTime - lastTime <= this._timeOut) continue;
                i.remove();
                super.remove(key);
            }
            this._lastCheck = currentTime;
        }
    }
}

