/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.schema;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.schema.AnnotationComponent;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.EnumerationFacet;
import com.sun.xml.rpc.processor.schema.InternalSchema;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ModelGroupDefinitionComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Symbol;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.UnimplementedFeatureException;
import com.sun.xml.rpc.processor.schema.WildcardComponent;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.schema.SchemaEntity;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class InternalSchemaBuilderBase {
    private AbstractDocument _document;
    private InternalSchema _schema;
    private Map _wellKnownTypes;
    private Map _wellKnownAttributes;
    private Map _wellKnownAttributeGroups;
    private Map _wellKnownElements;
    private ComplexTypeDefinitionComponent _urType;
    private SimpleTypeDefinitionComponent _simpleUrType;
    private Map _namedTypeComponentsBeingDefined;
    private static final Set _primitiveTypeNames;
    private static final Set _soapTypeNames;
    protected static final Set _setEmpty;
    private static final Set _setExtRes;
    private static final Set _setExtResSub;
    protected static final Set _setExtResListUnion;
    private static final Set _setLaxSkipStrict;

    static {
        _setEmpty = new HashSet();
        _setExtRes = new HashSet();
        _setExtRes.add(Symbol.EXTENSION);
        _setExtRes.add(Symbol.RESTRICTION);
        _setExtResSub = new HashSet();
        _setExtResSub.add(Symbol.EXTENSION);
        _setExtResSub.add(Symbol.RESTRICTION);
        _setExtResSub.add(Symbol.SUBSTITUTION);
        _setExtResListUnion = new HashSet();
        _setExtResListUnion.add(Symbol.EXTENSION);
        _setExtResListUnion.add(Symbol.RESTRICTION);
        _setExtResListUnion.add(Symbol.LIST);
        _setExtResListUnion.add(Symbol.UNION);
        _setLaxSkipStrict = new HashSet();
        _setLaxSkipStrict.add(Symbol.LAX);
        _setLaxSkipStrict.add(Symbol.SKIP);
        _setLaxSkipStrict.add(Symbol.STRICT);
        _primitiveTypeNames = new HashSet();
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_STRING);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NORMALIZED_STRING);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_TOKEN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BYTE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_BYTE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BASE64_BINARY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_HEX_BINARY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_POSITIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NEGATIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NON_NEGATIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NON_POSITIVE_INTEGER);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_INT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_INT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_LONG);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_LONG);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_SHORT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_UNSIGNED_SHORT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DECIMAL);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_FLOAT);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DOUBLE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_BOOLEAN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_TIME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DATE_TIME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DURATION);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_DATE);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_MONTH);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_YEAR);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_YEAR_MONTH);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_DAY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_G_MONTH_DAY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_QNAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NCNAME);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ANY_URI);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ID);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_IDREF);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_IDREFS);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ENTITY);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_ENTITIES);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NOTATION);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NMTOKEN);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_NMTOKENS);
        _primitiveTypeNames.add(SchemaConstants.QNAME_TYPE_LANGUAGE);
        _soapTypeNames = new HashSet();
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_STRING);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NORMALIZED_STRING);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_TOKEN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BYTE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_BYTE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BASE64_BINARY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_HEX_BINARY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_POSITIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NEGATIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NON_NEGATIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NON_POSITIVE_INTEGER);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_INT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_INT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_LONG);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_LONG);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_SHORT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_UNSIGNED_SHORT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DECIMAL);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_FLOAT);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DOUBLE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BOOLEAN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_TIME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DATE_TIME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DURATION);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_DATE);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_MONTH);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_YEAR);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_YEAR_MONTH);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_DAY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_G_MONTH_DAY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_QNAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NCNAME);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ANY_URI);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ID);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_IDREF);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_IDREFS);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ENTITY);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_ENTITIES);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NOTATION);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NMTOKEN);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_NMTOKENS);
        _soapTypeNames.add(SOAPConstants.QNAME_TYPE_BASE64);
    }

    protected void createWellKnownAttributeGroups() {
        this._wellKnownAttributeGroups = new HashMap();
        AttributeGroupDefinitionComponent commonAttributesAttrGroup = new AttributeGroupDefinitionComponent();
        commonAttributesAttrGroup.setName(SOAPConstants.QNAME_ATTR_GROUP_COMMON_ATTRIBUTES);
        AttributeDeclarationComponent idAttr = new AttributeDeclarationComponent();
        idAttr.setName(SOAPConstants.QNAME_ATTR_ID);
        idAttr.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_ID));
        AttributeUseComponent idAttrUse = new AttributeUseComponent();
        idAttrUse.setAttributeDeclaration(idAttr);
        commonAttributesAttrGroup.addAttributeUse(idAttrUse);
        AttributeDeclarationComponent hrefAttr = new AttributeDeclarationComponent();
        hrefAttr.setName(SOAPConstants.QNAME_ATTR_HREF);
        hrefAttr.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_ANY_URI));
        AttributeUseComponent hrefAttrUse = new AttributeUseComponent();
        hrefAttrUse.setAttributeDeclaration(hrefAttr);
        commonAttributesAttrGroup.addAttributeUse(hrefAttrUse);
        this._wellKnownAttributeGroups.put(commonAttributesAttrGroup.getName(), commonAttributesAttrGroup);
    }

    protected void createWellKnownAttributes() {
        this._wellKnownAttributes = new HashMap();
        AttributeDeclarationComponent arrayTypeAttr = new AttributeDeclarationComponent();
        arrayTypeAttr.setName(SOAPConstants.QNAME_ATTR_ARRAY_TYPE);
        arrayTypeAttr.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(arrayTypeAttr.getName(), arrayTypeAttr);
        AttributeDeclarationComponent offsetAttr = new AttributeDeclarationComponent();
        offsetAttr.setName(SOAPConstants.QNAME_ATTR_OFFSET);
        offsetAttr.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(offsetAttr.getName(), offsetAttr);
        AttributeDeclarationComponent xmlLangAttr = new AttributeDeclarationComponent();
        xmlLangAttr.setName(new QName("http://www.w3.org/XML/1998/namespace", "lang"));
        xmlLangAttr.setTypeDefinition((SimpleTypeDefinitionComponent)this._wellKnownTypes.get(SchemaConstants.QNAME_TYPE_STRING));
        this._wellKnownAttributes.put(xmlLangAttr.getName(), xmlLangAttr);
    }

    protected void createWellKnownElements() {
        this._wellKnownElements = new HashMap();
    }

    protected void createWellKnownTypes() {
        this._wellKnownTypes = new HashMap();
        this._urType = new ComplexTypeDefinitionComponent();
        this._urType.setName(SchemaConstants.QNAME_TYPE_URTYPE);
        this._urType.setBaseTypeDefinition(this._urType);
        this._urType.setFinal(_setEmpty);
        this._urType.setProhibitedSubstitutions(_setEmpty);
        this._urType.setDerivationMethod(Symbol.RESTRICTION);
        this._urType.setContentTag(3);
        ParticleComponent utp = new ParticleComponent();
        utp.setMinOccurs(1);
        utp.setMaxOccurs(1);
        ModelGroupComponent utpmg = new ModelGroupComponent();
        utpmg.setCompositor(Symbol.SEQUENCE);
        ParticleComponent utpmgp = new ParticleComponent();
        utpmgp.setMinOccurs(0);
        utpmgp.setMaxOccursUnbounded();
        WildcardComponent utpmgpw = new WildcardComponent();
        utpmgpw.setNamespaceConstraintTag(1);
        utpmgp.setTermTag(2);
        utpmgp.setWildcardTerm(utpmgpw);
        utpmg.addParticle(utpmgp);
        utp.setTermTag(1);
        utp.setModelGroupTerm(utpmg);
        this._urType.setParticleContent(utp);
        this._wellKnownTypes.put(this._urType.getName(), this._urType);
        this._simpleUrType = new SimpleTypeDefinitionComponent();
        this._simpleUrType.setName(SchemaConstants.QNAME_TYPE_SIMPLE_URTYPE);
        this._simpleUrType.setBaseTypeDefinition(this._simpleUrType);
        this._simpleUrType.setFinal(_setEmpty);
        this._wellKnownTypes.put(this._simpleUrType.getName(), this._simpleUrType);
        Iterator iter = _primitiveTypeNames.iterator();
        while (iter.hasNext()) {
            QName name = (QName)iter.next();
            SimpleTypeDefinitionComponent type = new SimpleTypeDefinitionComponent();
            type.setName(name);
            type.setVarietyTag(1);
            type.setFinal(_setEmpty);
            type.setBaseTypeDefinition(this._simpleUrType);
            type.setPrimitiveTypeDefinition(type);
            this._wellKnownTypes.put(type.getName(), type);
        }
        Iterator iter2 = _soapTypeNames.iterator();
        while (iter2.hasNext()) {
            QName name = (QName)iter2.next();
            ComplexTypeDefinitionComponent type = new ComplexTypeDefinitionComponent();
            type.setName(name);
            type.setBaseTypeDefinition(this._urType);
            type.setContentTag(2);
            QName xName = new QName("http://www.w3.org/2001/XMLSchema", name.getLocalPart());
            SimpleTypeDefinitionComponent xComponent = (SimpleTypeDefinitionComponent)this._wellKnownTypes.get(xName);
            if (xComponent == null) continue;
            type.setSimpleTypeContent(xComponent);
            this._wellKnownTypes.put(type.getName(), type);
        }
        SimpleTypeDefinitionComponent base64Type = new SimpleTypeDefinitionComponent();
        base64Type.setName(SOAPConstants.QNAME_TYPE_BASE64);
        base64Type.setVarietyTag(1);
        base64Type.setFinal(_setEmpty);
        base64Type.setBaseTypeDefinition(this._simpleUrType);
        base64Type.setPrimitiveTypeDefinition(base64Type);
        this._wellKnownTypes.put(base64Type.getName(), base64Type);
        ComplexTypeDefinitionComponent arrayType = new ComplexTypeDefinitionComponent();
        arrayType.setName(SOAPConstants.QNAME_TYPE_ARRAY);
        arrayType.setBaseTypeDefinition(this._urType);
        arrayType.setDerivationMethod(Symbol.RESTRICTION);
        arrayType.setContentTag(4);
        ParticleComponent atp = new ParticleComponent();
        atp.setMinOccurs(1);
        atp.setMaxOccurs(1);
        ModelGroupComponent atpmg = new ModelGroupComponent();
        atpmg.setCompositor(Symbol.SEQUENCE);
        ParticleComponent atpmgp = new ParticleComponent();
        atpmgp.setMinOccurs(0);
        atpmgp.setMaxOccursUnbounded();
        WildcardComponent atpmgpw = new WildcardComponent();
        atpmgpw.setNamespaceConstraintTag(1);
        atpmgp.setTermTag(2);
        atpmgp.setWildcardTerm(atpmgpw);
        atpmg.addParticle(atpmgp);
        atp.setTermTag(1);
        atp.setModelGroupTerm(atpmg);
        arrayType.setParticleContent(atp);
        this._wellKnownTypes.put(arrayType.getName(), arrayType);
    }

    public ComplexTypeDefinitionComponent getUrType() {
        return this._urType;
    }

    public InternalSchema getSchema() {
        return this._schema;
    }

    public SimpleTypeDefinitionComponent getSimpleUrType() {
        return this._simpleUrType;
    }

    private void fail(String key) {
        throw new ModelException(key);
    }

    protected void failUnimplemented(String arg) {
        throw new UnimplementedFeatureException(arg);
    }

    private void failValidation(String key) {
        throw new ValidationException(key);
    }

    protected AnnotationComponent buildNonSchemaAttributesAnnotation(SchemaElement element) {
        AnnotationComponent annotation = null;
        Iterator iter = element.attributes();
        while (iter.hasNext()) {
            SchemaAttribute attribute = (SchemaAttribute)iter.next();
            if (attribute.getNamespaceURI() == null || attribute.getNamespaceURI().equals("") || attribute.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) continue;
            if (annotation == null) {
                annotation = new AnnotationComponent();
            }
            annotation.addAttribute(attribute);
        }
        return annotation;
    }

    public AttributeDeclarationComponent buildAttributeDeclaration(QName name) {
        try {
            AttributeDeclarationComponent component = (AttributeDeclarationComponent)this._wellKnownAttributes.get(name);
            if (component != null) {
                return component;
            }
            SchemaEntity entity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ATTRIBUTE, name);
            SchemaElement element = entity.getElement();
            component = this.buildTopLevelAttributeDeclaration(element, this._schema);
            this._schema.add(component);
            return component;
        }
        catch (ValidationException e) {
            throw new ModelException(e);
        }
    }

    public AttributeGroupDefinitionComponent buildAttributeGroupDefinition(QName name) {
        try {
            AttributeGroupDefinitionComponent component = (AttributeGroupDefinitionComponent)this._wellKnownAttributeGroups.get(name);
            if (component != null) {
                return component;
            }
            SchemaEntity entity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ATTRIBUTE_GROUP, name);
            SchemaElement element = entity.getElement();
            component = this.buildTopLevelAttributeGroupDefinition(element, this._schema);
            this._schema.add(component);
            return component;
        }
        catch (ValidationException e) {
            throw new ModelException(e);
        }
    }

    public ElementDeclarationComponent buildElementDeclaration(QName name) {
        try {
            ElementDeclarationComponent component = (ElementDeclarationComponent)this._wellKnownElements.get(name);
            if (component != null) {
                return component;
            }
            SchemaEntity entity = (SchemaEntity)this._document.find(SchemaKinds.XSD_ELEMENT, name);
            SchemaElement element = entity.getElement();
            component = this.buildTopLevelElementDeclaration(element, this._schema);
            this._schema.add(component);
            return component;
        }
        catch (ValidationException e) {
            throw new ModelException(e);
        }
    }

    public ModelGroupDefinitionComponent buildModelGroupDefinition(QName name) {
        this.failUnimplemented("F002");
        return null;
    }

    public TypeDefinitionComponent buildTypeDefinition(QName name) {
        TypeDefinitionComponent component;
        boolean createdTypeComponentMap;
        block8: {
            createdTypeComponentMap = false;
            if (this._namedTypeComponentsBeingDefined == null) {
                this._namedTypeComponentsBeingDefined = new HashMap();
                createdTypeComponentMap = true;
            }
            component = (TypeDefinitionComponent)this._wellKnownTypes.get(name);
            if (component == null) break block8;
            TypeDefinitionComponent typeDefinitionComponent = component;
            Object var8_7 = null;
            if (createdTypeComponentMap) {
                this._namedTypeComponentsBeingDefined = null;
            }
            return typeDefinitionComponent;
        }
        try {
            SchemaEntity entity = (SchemaEntity)this._document.find(SchemaKinds.XSD_TYPE, name);
            SchemaElement element = entity.getElement();
            component = this.buildTopLevelTypeDefinition(element, this._schema);
            this._schema.add(component);
            TypeDefinitionComponent typeDefinitionComponent = component;
            Object var8_8 = null;
            if (createdTypeComponentMap) {
                this._namedTypeComponentsBeingDefined = null;
            }
            return typeDefinitionComponent;
        }
        catch (ValidationException e) {
            try {
                throw new ModelException(e);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var8_9 = null;
                    if (!createdTypeComponentMap) break block9;
                    this._namedTypeComponentsBeingDefined = null;
                }
                throw throwable;
            }
        }
    }

    public TypeDefinitionComponent getTypeDefinitionComponentBeingDefined(QName name) {
        if (this._namedTypeComponentsBeingDefined != null) {
            return (TypeDefinitionComponent)this._namedTypeComponentsBeingDefined.get(name);
        }
        return null;
    }

    private void addPrefixesToEnumerationFacet(EnumerationFacet enumeration, SchemaElement element) {
        Iterator iter = element.prefixes();
        while (iter.hasNext()) {
            String ns;
            String pfix = (String)iter.next();
            if (pfix == null || (ns = element.getURIForPrefix(pfix)) == null) continue;
            enumeration.addPrefix(pfix, ns);
        }
        SchemaElement p = element.getParent();
        if (p != null) {
            this.addPrefixesToEnumerationFacet(enumeration, p);
        }
    }

    private void assertNoAttribute(SchemaElement element, String name) {
        String value = element.getValueOfAttributeOrNull(name);
        if (value != null) {
            this.failValidation("validation.invalidAttribute", name, element.getValueOfAttributeOrNull("name"));
        }
    }

    private void fail(String key, String arg) {
        throw new ModelException(key, arg);
    }

    protected void failValidation(String key, String arg) {
        throw new ValidationException(key, arg);
    }

    private String toString(QName name) {
        return name.getLocalPart() + " (" + name.getNamespaceURI() + ")";
    }

    public InternalSchemaBuilderBase(AbstractDocument document, Properties options) {
        this._document = document;
        this._schema = new InternalSchema(this);
        this.createWellKnownTypes();
        this.createWellKnownAttributes();
        this.createWellKnownAttributeGroups();
        this.createWellKnownElements();
    }

    private void fail(String key, QName name) {
        this.fail(key, this.toString(name));
    }

    protected AttributeDeclarationComponent buildTopLevelAttributeDeclaration(SchemaElement element, InternalSchema schema) {
        AttributeDeclarationComponent component = new AttributeDeclarationComponent();
        String nameAttr = element.getValueOfMandatoryAttribute("name");
        component.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
        component.setScope(null);
        boolean foundType = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                if (foundType) {
                    this.failValidation("validation.invalidElement", element.getLocalName());
                }
                component.setTypeDefinition(this.buildSimpleTypeDefinition(child, schema));
                foundType = true;
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failValidation("validation.invalidElement", child.getLocalName());
        }
        if (foundType) {
            this.assertNoAttribute(element, "type");
        } else {
            String typeAttr = element.getValueOfAttributeOrNull("type");
            if (typeAttr == null) {
                component.setTypeDefinition(this.getSimpleUrType());
            } else {
                TypeDefinitionComponent typeComponent = schema.findTypeDefinition(element.asQName(typeAttr));
                if (typeComponent instanceof SimpleTypeDefinitionComponent) {
                    component.setTypeDefinition((SimpleTypeDefinitionComponent)typeComponent);
                } else {
                    this.failValidation("validation.notSimpleType", component.getName().getLocalPart());
                }
            }
        }
        component.setAnnotation(this.buildNonSchemaAttributesAnnotation(element));
        String defaultAttr = element.getValueOfAttributeOrNull("default");
        String fixedAttr = element.getValueOfAttributeOrNull("fixed");
        if (defaultAttr != null && fixedAttr != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (defaultAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.DEFAULT);
        }
        if (fixedAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.FIXED);
        }
        return component;
    }

    protected AttributeGroupDefinitionComponent buildTopLevelAttributeGroupDefinition(SchemaElement element, InternalSchema schema) {
        AttributeGroupDefinitionComponent component = new AttributeGroupDefinitionComponent();
        String nameAttr = element.getValueOfMandatoryAttribute("name");
        component.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                component.addAttributeUse(this.buildAttributeUse(child, null, schema));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String refAttr = child.getValueOfMandatoryAttribute("ref");
                component.addAttributeGroup(schema.findAttributeGroupDefinition(child.asQName(refAttr)));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F003");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failValidation("validation.invalidElement", child.getLocalName());
        }
        return component;
    }

    protected ComplexTypeDefinitionComponent buildComplexTypeDefinition(SchemaElement element, InternalSchema schema) {
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_SIMPLE_CONTENT)) {
                return this.buildSimpleContentComplexTypeDefinition(element, schema);
            }
            if (!child.getQName().equals(SchemaConstants.QNAME_COMPLEX_CONTENT)) continue;
            boolean mixedContent = element.getValueOfBooleanAttributeOrDefault("mixed", false);
            return this.buildExplicitComplexContentComplexTypeDefinition(element, mixedContent, schema);
        }
        boolean mixedContent = element.getValueOfBooleanAttributeOrDefault("mixed", false);
        return this.buildImplicitComplexContentComplexTypeDefinition(element, mixedContent, schema);
    }

    protected ComplexTypeDefinitionComponent buildSimpleContentComplexTypeDefinition(SchemaElement element, InternalSchema schema) {
        String baseAttr;
        ComplexTypeDefinitionComponent component = this.commonBuildComplexTypeDefinition(element, schema);
        SchemaElement simpleContentElement = this.getOnlyChildIgnoring(element, SchemaConstants.QNAME_ANNOTATION);
        if (!simpleContentElement.getQName().equals(SchemaConstants.QNAME_SIMPLE_CONTENT)) {
            this.failValidation("validation.invalidElement", simpleContentElement.getLocalName());
        }
        component.setContentTag(2);
        SchemaElement derivationElement = this.getOnlyChildIgnoring(simpleContentElement, SchemaConstants.QNAME_ANNOTATION);
        boolean isRestriction = true;
        if (!derivationElement.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
            if (derivationElement.getQName().equals(SchemaConstants.QNAME_EXTENSION)) {
                isRestriction = false;
            } else {
                this.failValidation("validation.invalidElement", derivationElement.getLocalName());
            }
        }
        if ((baseAttr = derivationElement.getValueOfAttributeOrNull("base")) == null) {
            component.setBaseTypeDefinition(this.getUrType());
        } else {
            component.setBaseTypeDefinition(schema.findTypeDefinition(element.asQName(baseAttr)));
        }
        component.setDerivationMethod(isRestriction ? Symbol.RESTRICTION : Symbol.EXTENSION);
        if (isRestriction) {
            this.processRestrictionSimpleTypeDefinition(derivationElement, component, schema);
        } else {
            this.processExtensionSimpleTypeDefinition(derivationElement, component, schema);
        }
        return component;
    }

    protected ComplexTypeDefinitionComponent commonBuildComplexTypeDefinition(SchemaElement element, InternalSchema schema) {
        ComplexTypeDefinitionComponent component = new ComplexTypeDefinitionComponent();
        String nameAttr = element.getValueOfAttributeOrNull("name");
        if (nameAttr != null && element.getParent().getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
            this.failValidation("validation.invalidComplexTypeInElement", nameAttr, element.getParent().getValueOfAttributeOrNull("name"));
        }
        if (nameAttr != null) {
            component.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
            this._namedTypeComponentsBeingDefined.put(component.getName(), component);
        }
        component.setAbstract(element.getValueOfBooleanAttributeOrDefault("abstract", false));
        String blockAttr = element.getValueOfAttributeOrNull("block");
        if (blockAttr == null && (blockAttr = element.getRoot().getValueOfAttributeOrNull("blockDefault")) == null) {
            blockAttr = "";
        }
        if (blockAttr.equals("")) {
            component.setProhibitedSubstitutions(_setEmpty);
        } else if (blockAttr.equals("#all")) {
            component.setProhibitedSubstitutions(_setExtRes);
        } else {
            component.setProhibitedSubstitutions(this.parseSymbolSet(blockAttr, _setExtRes));
            this.failUnimplemented("F015");
        }
        String finalAttr = element.getValueOfAttributeOrNull("final");
        if (finalAttr == null && (finalAttr = element.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            finalAttr = "";
        }
        if (finalAttr.equals("")) {
            component.setFinal(_setEmpty);
        } else if (finalAttr.equals("#all")) {
            component.setFinal(_setExtRes);
        } else {
            component.setFinal(this.parseSymbolSet(finalAttr, _setExtRes));
            this.failUnimplemented("F016");
        }
        return component;
    }

    protected ComplexTypeDefinitionComponent buildExplicitComplexContentComplexTypeDefinition(SchemaElement element, boolean mixedContent, InternalSchema schema) {
        ComplexTypeDefinitionComponent component = this.commonBuildComplexTypeDefinition(element, schema);
        SchemaElement complexContentElement = this.getOnlyChildIgnoring(element, SchemaConstants.QNAME_ANNOTATION);
        if (!complexContentElement.getQName().equals(SchemaConstants.QNAME_COMPLEX_CONTENT)) {
            this.failValidation("validation.invalidElement", complexContentElement.getLocalName());
        }
        boolean mixed = complexContentElement.getValueOfBooleanAttributeOrDefault("mixed", mixedContent);
        SchemaElement derivationElement = this.getOnlyChildIgnoring(complexContentElement, SchemaConstants.QNAME_ANNOTATION);
        boolean isRestriction = true;
        if (!derivationElement.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
            if (derivationElement.getQName().equals(SchemaConstants.QNAME_EXTENSION)) {
                isRestriction = false;
            } else {
                this.failValidation("validation.invalidElement", derivationElement.getLocalName());
            }
        }
        if (isRestriction) {
            String baseAttr = derivationElement.getValueOfMandatoryAttribute("base");
            TypeDefinitionComponent baseType = schema.findTypeDefinition(derivationElement.asQName(baseAttr));
            component.setBaseTypeDefinition(baseType);
            if (mixed) {
                component.setContentTag(3);
            } else {
                component.setContentTag(4);
            }
            this.processRestrictionComplexTypeDefinition(derivationElement, component, schema);
        } else {
            String baseAttr = derivationElement.getValueOfMandatoryAttribute("base");
            TypeDefinitionComponent baseType = schema.findTypeDefinition(derivationElement.asQName(baseAttr));
            component.setBaseTypeDefinition(baseType);
            if (mixed) {
                component.setContentTag(3);
            } else {
                component.setContentTag(4);
            }
            this.processExtensionComplexTypeDefinition(derivationElement, component, schema);
        }
        component.setDerivationMethod(isRestriction ? Symbol.RESTRICTION : Symbol.EXTENSION);
        return component;
    }

    protected ComplexTypeDefinitionComponent buildImplicitComplexContentComplexTypeDefinition(SchemaElement element, boolean mixedContent, InternalSchema schema) {
        ComplexTypeDefinitionComponent component = this.commonBuildComplexTypeDefinition(element, schema);
        component.setBaseTypeDefinition(this.getUrType());
        if (mixedContent) {
            component.setContentTag(3);
        } else {
            component.setContentTag(4);
        }
        this.processRestrictionComplexTypeDefinition(element, component, schema);
        return component;
    }

    protected ElementDeclarationComponent buildTopLevelElementDeclaration(SchemaElement element, InternalSchema schema) {
        ElementDeclarationComponent component = this.internalBuildElementDeclaration(element, schema);
        String nameAttr = element.getValueOfMandatoryAttribute("name");
        component.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
        if (element.getValueOfAttributeOrNull("minOccurs") != null) {
            this.failValidation("validation.invalidAttribute", "minOccurs", element.getLocalName());
        }
        if (element.getValueOfAttributeOrNull("maxOccurs") != null) {
            this.failValidation("validation.invalidAttribute", "maxOccurs", element.getLocalName());
        }
        return component;
    }

    protected ElementDeclarationComponent internalBuildElementDeclaration(SchemaElement element, InternalSchema schema) {
        String blockAttr;
        ElementDeclarationComponent component = new ElementDeclarationComponent();
        boolean foundType = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                if (foundType) {
                    this.failValidation("validation.invalidElement", element.getLocalName());
                }
                component.setTypeDefinition(this.buildSimpleTypeDefinition(child, schema));
                foundType = true;
                continue;
            }
            if (!child.getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) continue;
            if (foundType) {
                this.failValidation("validation.invalidElement", element.getLocalName());
            }
            component.setTypeDefinition(this.buildComplexTypeDefinition(child, schema));
            foundType = true;
        }
        if (foundType) {
            this.assertNoAttribute(element, "type");
            this.assertNoAttribute(element, "substitutionGroup");
        } else {
            String typeAttr = element.getValueOfAttributeOrNull("type");
            String substitutionGroupAttr = element.getValueOfAttributeOrNull("substitutionGroup");
            if (typeAttr == null && substitutionGroupAttr == null) {
                component.setTypeDefinition(this.getUrType());
            } else if (typeAttr != null && substitutionGroupAttr != null) {
                this.failValidation("validation.exclusiveAttributes", "type", "substitutionGroup");
            } else if (typeAttr != null) {
                component.setTypeDefinition(schema.findTypeDefinition(element.asQName(typeAttr)));
            } else {
                this.failUnimplemented("F005");
            }
        }
        component.setNillable(element.getValueOfBooleanAttributeOrDefault("nillable", false));
        String defaultAttr = element.getValueOfAttributeOrNull("default");
        String fixedAttr = element.getValueOfAttributeOrNull("fixed");
        if (defaultAttr != null && fixedAttr != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (defaultAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.DEFAULT);
            if (component.getTypeDefinition() instanceof ComplexTypeDefinitionComponent) {
                this.failValidation("validation.notSimpleType", component.getName().getLocalPart());
            }
        }
        if (fixedAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.FIXED);
            if (component.getTypeDefinition() instanceof ComplexTypeDefinitionComponent) {
                this.failValidation("validation.notSimpleType", component.getName().getLocalPart());
            }
        }
        Iterator iter2 = element.children();
        while (iter2.hasNext()) {
            SchemaElement child = (SchemaElement)iter2.next();
            if (!child.getQName().equals(SchemaConstants.QNAME_KEY) && !child.getQName().equals(SchemaConstants.QNAME_KEYREF) && !child.getQName().equals(SchemaConstants.QNAME_UNIQUE)) continue;
            this.failUnimplemented("F006");
        }
        QName substitutionGroupAttr = element.getValueOfQNameAttributeOrNull("substitutionGroup");
        if (substitutionGroupAttr != null) {
            this.failUnimplemented("F007");
        }
        if ((blockAttr = element.getValueOfAttributeOrNull("block")) == null && (blockAttr = element.getRoot().getValueOfAttributeOrNull("blockDefault")) == null) {
            blockAttr = "";
        }
        if (blockAttr.equals("")) {
            component.setDisallowedSubstitutions(_setEmpty);
        } else if (blockAttr.equals("#all")) {
            component.setDisallowedSubstitutions(_setExtResSub);
        } else {
            component.setDisallowedSubstitutions(this.parseSymbolSet(blockAttr, _setExtResSub));
            this.failUnimplemented("F008");
        }
        String finalAttr = element.getValueOfAttributeOrNull("final");
        if (finalAttr == null && (finalAttr = element.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            finalAttr = "";
        }
        if (finalAttr.equals("")) {
            component.setSubstitutionsGroupExclusions(_setEmpty);
        } else if (finalAttr.equals("#all")) {
            component.setSubstitutionsGroupExclusions(_setExtRes);
        } else {
            component.setSubstitutionsGroupExclusions(this.parseSymbolSet(finalAttr, _setExtRes));
            this.failUnimplemented("F009");
        }
        component.setAbstract(element.getValueOfBooleanAttributeOrDefault("abstract", false));
        return component;
    }

    protected void processExtensionComplexTypeDefinition(SchemaElement element, ComplexTypeDefinitionComponent component, InternalSchema schema) {
        boolean gotContent = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                AttributeUseComponent attribute = this.buildAttributeUse(child, component, schema);
                if (attribute == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                component.addAttributeUse(attribute);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String refAttr = child.getValueOfMandatoryAttribute("ref");
                component.addAttributeGroup(schema.findAttributeGroupDefinition(child.asQName(refAttr)));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            if (gotContent) {
                this.failValidation("validation.invalidElement", child.getLocalName());
            }
            gotContent = true;
            if (child.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                this.failUnimplemented("F021");
                continue;
            }
            component.setParticleContent(this.buildParticle(child, component, schema));
        }
        if (!gotContent) {
            component.setContentTag(1);
        }
    }

    protected void processExtensionSimpleTypeDefinition(SchemaElement element, ComplexTypeDefinitionComponent component, InternalSchema schema) {
        boolean gotContent = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                AttributeUseComponent attribute = this.buildAttributeUse(child, component, schema);
                if (attribute == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                component.addAttributeUse(attribute);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String refAttr = child.getValueOfMandatoryAttribute("ref");
                component.addAttributeGroup(schema.findAttributeGroupDefinition(child.asQName(refAttr)));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failUnimplemented("F023");
        }
    }

    protected void processRestrictionComplexTypeDefinition(SchemaElement element, ComplexTypeDefinitionComponent component, InternalSchema schema) {
        boolean gotContent = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                AttributeUseComponent attribute = this.buildAttributeUse(child, component, schema);
                if (attribute == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                component.addAttributeUse(attribute);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String refAttr = child.getValueOfMandatoryAttribute("ref");
                component.addAttributeGroup(schema.findAttributeGroupDefinition(child.asQName(refAttr)));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            if (gotContent) {
                this.failValidation("validation.invalidElement", child.getLocalName());
            }
            gotContent = true;
            if (child.getQName().equals(SchemaConstants.QNAME_GROUP)) {
                this.failUnimplemented("F021");
                continue;
            }
            component.setParticleContent(this.buildParticle(child, component, schema));
        }
        if (!gotContent) {
            component.setContentTag(1);
        }
    }

    protected void processRestrictionSimpleTypeDefinition(SchemaElement element, ComplexTypeDefinitionComponent component, InternalSchema schema) {
        boolean gotContent = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE)) {
                AttributeUseComponent attribute = this.buildAttributeUse(child, component, schema);
                if (attribute == null) {
                    this.failUnimplemented("F019");
                    continue;
                }
                component.addAttributeUse(attribute);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ATTRIBUTE_GROUP)) {
                String refAttr = child.getValueOfMandatoryAttribute("ref");
                component.addAttributeGroup(schema.findAttributeGroupDefinition(child.asQName(refAttr)));
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANY_ATTRIBUTE)) {
                this.failUnimplemented("F020");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failUnimplemented("F023");
        }
    }

    protected void buildListSimpleTypeDefinition(SimpleTypeDefinitionComponent component, SchemaElement element, InternalSchema schema) {
        component.setBaseTypeDefinition(this.getSimpleUrType());
        String itemTypeAttr = element.getValueOfAttributeOrNull("itemType");
        if (itemTypeAttr != null) {
            TypeDefinitionComponent itemType = schema.findTypeDefinition(element.asQName(itemTypeAttr));
            if (itemType.isSimple()) {
                component.setItemTypeDefinition((SimpleTypeDefinitionComponent)itemType);
            } else {
                this.failValidation("validation.notSimpleType", itemType.getName().getLocalPart());
            }
        } else {
            SchemaElement simpleTypeElement = this.getOnlyChildIgnoring(element, SchemaConstants.QNAME_ANNOTATION);
            if (!simpleTypeElement.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                this.failValidation("validation.invalidElement", simpleTypeElement.getLocalName());
            }
            SimpleTypeDefinitionComponent itemType = this.buildSimpleTypeDefinition(simpleTypeElement, schema);
            component.setItemTypeDefinition(itemType);
        }
        component.setVarietyTag(2);
        String finalAttr = element.getValueOfAttributeOrNull("final");
        if (finalAttr == null && (finalAttr = element.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            finalAttr = "";
        }
        if (finalAttr.equals("")) {
            component.setFinal(_setEmpty);
        } else if (finalAttr.equals("#all")) {
            component.setFinal(_setExtResListUnion);
        } else {
            component.setFinal(this.parseSymbolSet(finalAttr, _setExtResListUnion));
            this.failUnimplemented("F013");
        }
    }

    protected void buildRestrictionSimpleTypeDefinition(SimpleTypeDefinitionComponent component, SchemaElement element, InternalSchema schema) {
        String baseAttr = element.getValueOfAttributeOrNull("base");
        if (baseAttr != null) {
            TypeDefinitionComponent base = schema.findTypeDefinition(element.asQName(baseAttr));
            if (base.isSimple()) {
                component.setBaseTypeDefinition((SimpleTypeDefinitionComponent)base);
            } else {
                this.failValidation("validation.notSimpleType", base.getName().getLocalPart());
            }
        } else {
            this.failUnimplemented("F012");
        }
        component.setVarietyTag(component.getBaseTypeDefinition().getVarietyTag());
        component.setPrimitiveTypeDefinition(component.getBaseTypeDefinition().getPrimitiveTypeDefinition());
        String finalAttr = element.getValueOfAttributeOrNull("final");
        if (finalAttr == null && (finalAttr = element.getRoot().getValueOfAttributeOrNull("finalDefault")) == null) {
            finalAttr = "";
        }
        if (finalAttr.equals("")) {
            component.setFinal(_setEmpty);
        } else if (finalAttr.equals("#all")) {
            component.setFinal(_setExtResListUnion);
        } else {
            component.setFinal(this.parseSymbolSet(finalAttr, _setExtResListUnion));
            this.failUnimplemented("F013");
        }
        boolean gotOne = false;
        EnumerationFacet enumeration = new EnumerationFacet();
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            gotOne = true;
            if (child.getQName().equals(SchemaConstants.QNAME_ENUMERATION)) {
                String valueAttr;
                if (baseAttr.equals("xsd:QName")) {
                    this.addPrefixesToEnumerationFacet(enumeration, element);
                }
                if ((valueAttr = child.getValueOfAttributeOrNull("value")) == null) {
                    this.failValidation("validation.missingRequiredAttribute", "value", child.getQName().getLocalPart());
                }
                enumeration.addValue(valueAttr);
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_LENGTH) || child.getQName().equals(SchemaConstants.QNAME_MAX_INCLUSIVE) || child.getQName().equals(SchemaConstants.QNAME_MIN_INCLUSIVE) || child.getQName().equals(SchemaConstants.QNAME_MIN_EXCLUSIVE) || child.getQName().equals(SchemaConstants.QNAME_MAX_EXCLUSIVE) || child.getQName().equals(SchemaConstants.QNAME_MAX_LENGTH) || child.getQName().equals(SchemaConstants.QNAME_MIN_LENGTH) || child.getQName().equals(SchemaConstants.QNAME_PATTERN) || child.getQName().equals(SchemaConstants.QNAME_TOTAL_DIGITS) || child.getQName().equals(SchemaConstants.QNAME_FRACTION_DIGITS) || child.getQName().equals(SchemaConstants.QNAME_WHITE_SPACE)) continue;
            this.failUnimplemented("F014");
        }
        if (enumeration.values().hasNext()) {
            component.addFacet(enumeration);
        }
    }

    protected SimpleTypeDefinitionComponent buildSimpleTypeDefinition(SchemaElement element, InternalSchema schema) {
        SimpleTypeDefinitionComponent component = new SimpleTypeDefinitionComponent();
        String nameAttr = element.getValueOfAttributeOrNull("name");
        if (nameAttr != null && element.getParent().getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
            this.failValidation("validation.invalidSimpleTypeInElement", nameAttr, element.getParent().getValueOfAttributeOrNull("name"));
        }
        if (nameAttr != null) {
            component.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
            this._namedTypeComponentsBeingDefined.put(component.getName(), component);
        }
        boolean gotOne = false;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (gotOne) {
                this.failValidation("validation.invalidElement", child.getLocalName());
            }
            if (child.getQName().equals(SchemaConstants.QNAME_RESTRICTION)) {
                this.buildRestrictionSimpleTypeDefinition(component, child, schema);
                gotOne = true;
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_LIST)) {
                this.buildListSimpleTypeDefinition(component, child, schema);
                gotOne = true;
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_UNION)) {
                this.failUnimplemented("F011");
                continue;
            }
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            this.failValidation("validation.invalidElement", child.getLocalName());
        }
        return component;
    }

    private Symbol parseSymbolInSet(String s, Set values) {
        Symbol sym = Symbol.named(s);
        if (sym != null && values.contains(sym)) {
            return sym;
        }
        return null;
    }

    protected TypeDefinitionComponent buildTopLevelTypeDefinition(SchemaElement element, InternalSchema schema) {
        TypeDefinitionComponent component = null;
        if (element.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
            component = this.buildSimpleTypeDefinition(element, schema);
        } else if (element.getQName().equals(SchemaConstants.QNAME_COMPLEX_TYPE)) {
            component = this.buildComplexTypeDefinition(element, schema);
        } else {
            this.failValidation("validation.invalidElement", element.getLocalName());
        }
        return component;
    }

    private SchemaElement getOnlyChildIgnoring(SchemaElement element, QName name) {
        SchemaElement result = null;
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(name)) continue;
            if (result != null) {
                this.failValidation("validation.invalidElement", child.getLocalName());
            }
            result = child;
        }
        if (result == null) {
            this.failValidation("validation.invalidElement", element.getLocalName());
        }
        return result;
    }

    private void fail(String key, String arg1, String arg2) {
        throw new ModelException(key, new Object[]{arg1, arg2});
    }

    protected void failValidation(String key, String arg1, String arg2) {
        throw new ValidationException(key, new Object[]{arg1, arg2});
    }

    protected Set parseSymbolSet(String s, Set values) {
        if (s.equals("#all")) {
            return values;
        }
        HashSet<Symbol> result = new HashSet<Symbol>();
        List tokens = XmlUtil.parseTokenList(s);
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String v = (String)iter.next();
            Symbol sym = Symbol.named(v);
            if (sym == null || !values.contains(sym)) continue;
            result.add(sym);
        }
        return result;
    }

    protected AttributeUseComponent buildAttributeUse(SchemaElement element, ComplexTypeDefinitionComponent scope, InternalSchema schema) {
        String refAttr;
        AttributeUseComponent component = new AttributeUseComponent();
        String useAttr = element.getValueOfAttributeOrNull("use");
        if (useAttr != null) {
            if (useAttr.equals("required")) {
                component.setRequired(true);
            } else if (useAttr.equals("prohibited")) {
                return null;
            }
        }
        if ((refAttr = element.getValueOfAttributeOrNull("ref")) != null) {
            this.assertNoAttribute(element, "name");
            this.assertNoAttribute(element, "type");
            component.setAttributeDeclaration(schema.findAttributeDeclaration(element.asQName(refAttr)));
            component.setAnnotation(this.buildNonSchemaAttributesAnnotation(element));
            AttributeDeclarationComponent attComp = component.getAttributeDeclaration();
            component.setValue(attComp.getValue());
            component.setValueKind(attComp.getValueKind());
        } else {
            AttributeDeclarationComponent declaration = new AttributeDeclarationComponent();
            String nameAttr = element.getValueOfMandatoryAttribute("name");
            String formAttr = element.getValueOfAttributeOrNull("form");
            if (formAttr == null && (formAttr = element.getRoot().getValueOfAttributeOrNull("attributeFormDefault")) == null) {
                formAttr = "";
            }
            if (formAttr.equals("qualified")) {
                declaration.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
            } else {
                declaration.setName(new QName(nameAttr));
            }
            declaration.setScope(scope);
            boolean foundType = false;
            Iterator iter = element.children();
            while (iter.hasNext()) {
                SchemaElement child = (SchemaElement)iter.next();
                if (child.getQName().equals(SchemaConstants.QNAME_SIMPLE_TYPE)) {
                    if (foundType) {
                        this.failValidation("validation.invalidElement", element.getLocalName());
                    }
                    declaration.setTypeDefinition(this.buildSimpleTypeDefinition(child, schema));
                    foundType = true;
                    continue;
                }
                if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
                this.failValidation("validation.invalidElement", child.getLocalName());
            }
            if (foundType) {
                this.assertNoAttribute(element, "type");
            } else {
                String typeAttr = element.getValueOfAttributeOrNull("type");
                if (typeAttr == null) {
                    declaration.setTypeDefinition(this.getSimpleUrType());
                } else {
                    TypeDefinitionComponent typeComponent = schema.findTypeDefinition(element.asQName(typeAttr));
                    if (typeComponent instanceof SimpleTypeDefinitionComponent) {
                        declaration.setTypeDefinition((SimpleTypeDefinitionComponent)typeComponent);
                    } else {
                        this.failValidation("validation.notSimpleType", declaration.getName().getLocalPart());
                    }
                }
            }
            declaration.setAnnotation(this.buildNonSchemaAttributesAnnotation(element));
            component.setAttributeDeclaration(declaration);
        }
        String defaultAttr = element.getValueOfAttributeOrNull("default");
        String fixedAttr = element.getValueOfAttributeOrNull("fixed");
        if (defaultAttr != null && fixedAttr != null) {
            this.fail("validation.exclusiveAttributes", "default", "fixed");
        }
        if (defaultAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.DEFAULT);
        }
        if (fixedAttr != null) {
            component.setValue(defaultAttr);
            component.setValueKind(Symbol.FIXED);
        }
        return component;
    }

    protected void processElementParticle(SchemaElement element, ParticleComponent component, ComplexTypeDefinitionComponent scope, InternalSchema schema) {
        component.setTermTag(3);
        ElementDeclarationComponent term = this.internalBuildElementDeclaration(element, schema);
        String refAttr = element.getValueOfAttributeOrNull("ref");
        if (refAttr != null) {
            term = schema.findElementDeclaration(element.asQName(refAttr));
        } else {
            String nameAttr = element.getValueOfMandatoryAttribute("name");
            String formAttr = element.getValueOfAttributeOrNull("form");
            if (formAttr == null && (formAttr = element.getRoot().getValueOfAttributeOrNull("elementFormDefault")) == null) {
                formAttr = "";
            }
            if (formAttr.equals("qualified")) {
                term.setName(new QName(element.getSchema().getTargetNamespaceURI(), nameAttr));
            } else {
                term.setName(new QName(nameAttr));
            }
        }
        term.setScope(scope);
        component.setTermTag(3);
        component.setElementTerm(term);
    }

    protected ModelGroupComponent buildModelGroup(SchemaElement element, ComplexTypeDefinitionComponent scope, InternalSchema schema) {
        ModelGroupComponent component = new ModelGroupComponent();
        if (element.getQName().equals(SchemaConstants.QNAME_ALL)) {
            component.setCompositor(Symbol.ALL);
        } else if (element.getQName().equals(SchemaConstants.QNAME_CHOICE)) {
            component.setCompositor(Symbol.CHOICE);
        } else if (element.getQName().equals(SchemaConstants.QNAME_SEQUENCE)) {
            component.setCompositor(Symbol.SEQUENCE);
        } else {
            this.failValidation("validation.invalidElement", element.getLocalName());
        }
        Iterator iter = element.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            if (child.getQName().equals(SchemaConstants.QNAME_ANNOTATION)) continue;
            ParticleComponent particle = this.buildParticle(child, scope, schema);
            component.addParticle(particle);
        }
        return component;
    }

    protected ParticleComponent buildParticle(SchemaElement element, ComplexTypeDefinitionComponent scope, InternalSchema schema) {
        ParticleComponent component = new ParticleComponent();
        int minOccurs = element.getValueOfIntegerAttributeOrDefault("minOccurs", 1);
        component.setMinOccurs(minOccurs);
        String maxOccursAttr = element.getValueOfAttributeOrNull("maxOccurs");
        if (maxOccursAttr == null) {
            component.setMaxOccurs(1);
        } else if (maxOccursAttr.equals("unbounded")) {
            component.setMaxOccursUnbounded();
        } else {
            try {
                int i = Integer.parseInt(maxOccursAttr);
                if (i < 0 || i < minOccurs) {
                    this.failValidation("validation.invalidAttributeValue", "maxOccurs", maxOccursAttr);
                }
                component.setMaxOccurs(i);
            }
            catch (NumberFormatException e) {
                this.failValidation("validation.invalidAttributeValue", "maxOccurs", maxOccursAttr);
            }
        }
        if (element.getQName().equals(SchemaConstants.QNAME_ELEMENT)) {
            this.processElementParticle(element, component, scope, schema);
        } else if (element.getQName().equals(SchemaConstants.QNAME_ALL) || element.getQName().equals(SchemaConstants.QNAME_CHOICE) || element.getQName().equals(SchemaConstants.QNAME_SEQUENCE)) {
            component.setTermTag(1);
            component.setModelGroupTerm(this.buildModelGroup(element, scope, schema));
        } else if (element.getQName().equals(SchemaConstants.QNAME_ANY)) {
            component.setTermTag(2);
            component.setWildcardTerm(this.buildAnyWildcard(element, scope, schema));
        } else {
            this.failValidation("validation.invalidElement", element.getLocalName());
        }
        return component;
    }

    protected WildcardComponent buildAnyWildcard(SchemaElement element, ComplexTypeDefinitionComponent scope, InternalSchema schema) {
        WildcardComponent component = new WildcardComponent();
        String processContentsAttr = element.getValueOfAttributeOrNull("processContents");
        if (processContentsAttr != null) {
            Symbol processContents = this.parseSymbolInSet(processContentsAttr, _setLaxSkipStrict);
            if (processContents == null) {
                this.failValidation("validation.invalidAttribute", "processContents", element.getLocalName());
            }
            component.setProcessContents(processContents);
        } else {
            component.setProcessContents(Symbol.STRICT);
        }
        String namespaceAttr = element.getValueOfAttributeOrNull("namespace");
        if (namespaceAttr != null) {
            if (namespaceAttr.equals("##any")) {
                component.setNamespaceConstraintTag(1);
            } else if (namespaceAttr.equals("##other")) {
                String targetNamespaceURI = element.getSchema().getTargetNamespaceURI();
                if (targetNamespaceURI == null || targetNamespaceURI.equals("")) {
                    component.setNamespaceConstraintTag(3);
                } else {
                    component.setNamespaceConstraintTag(2);
                    component.setNamespaceName(targetNamespaceURI);
                }
            } else {
                this.failUnimplemented("F022");
            }
        } else {
            component.setNamespaceConstraintTag(1);
        }
        return component;
    }
}

