/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public abstract class SerializerBase
implements CombinedSerializer,
SerializerConstants {
    protected QName type;
    protected boolean encodeType;
    protected boolean isNullable;
    protected String encodingStyle;

    public boolean getEncodeType() {
        return this.encodeType;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    protected boolean typeIsEmpty() {
        return this.type.getNamespaceURI().equals("") && this.type.getLocalPart().equals("");
    }

    public CombinedSerializer getInnermostSerializer() {
        return this;
    }

    protected void skipEmptyContent(XMLReader reader) throws Exception {
        reader.skipElement();
    }

    protected void verifyType(XMLReader reader) throws Exception {
        if (this.typeIsEmpty()) {
            return;
        }
        QName actualType = SerializerBase.getType(reader);
        if (actualType != null && !actualType.equals(this.type) && !this.isAcceptableType(actualType)) {
            throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), actualType.toString()});
        }
    }

    public static boolean getNullStatus(XMLReader reader) throws Exception {
        boolean isNull = false;
        Attributes attrs = reader.getAttributes();
        String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
        return isNull;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }

    public static boolean decodeBoolean(String str) throws Exception {
        return str.equals("true") || str.equals("1");
    }

    public QName getXmlType() {
        return this.type;
    }

    protected boolean isAcceptableType(QName actualType) {
        return false;
    }

    protected String getID(XMLReader reader) throws Exception {
        Attributes attrs = reader.getAttributes();
        return attrs.getValue("", "id");
    }

    protected SerializerBase(QName xmlType, boolean encodeType, boolean isNullable, String encodingStyle) {
        if (xmlType == null) {
            throw new IllegalArgumentException("xmlType parameter is not allowed to be null");
        }
        this.type = xmlType;
        this.encodeType = encodeType;
        this.isNullable = isNullable;
        this.encodingStyle = encodingStyle;
    }

    protected QName getName(XMLReader reader) throws Exception {
        return reader.getName();
    }

    public static QName getType(XMLReader reader) throws Exception {
        QName type = null;
        Attributes attrs = reader.getAttributes();
        String typeVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeVal != null) {
            type = XMLReaderUtil.decodeQName(reader, typeVal);
        }
        return type;
    }

    protected void verifyName(XMLReader reader, QName expectedName) throws Exception {
        QName actualName = this.getName(reader);
        if (!actualName.equals(expectedName)) {
            throw new DeserializationException("soap.unexpectedElementName", new Object[]{expectedName.toString(), actualName.toString()});
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext context) {
        throw new UnsupportedOperationException();
    }
}

