/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.local;

import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.soap.message.Handler;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.OutputStream;

public class LocalClientTransport
implements ClientTransport {
    private Handler _handler;
    private OutputStream _logStream;

    public LocalClientTransport(Handler handler) {
        this._handler = handler;
    }

    public void invoke(String endpoint, SOAPMessageContext context) {
        try {
            String s;
            if (this._logStream != null) {
                s = "\n******************\nRequest\n";
                this._logStream.write(s.getBytes());
                context.getMessage().writeTo(this._logStream);
            }
            this._handler.handle(context);
            context.setFailure(false);
            if (this._logStream != null) {
                s = "\nResponse\n";
                this._logStream.write(s.getBytes());
                context.getMessage().writeTo(this._logStream);
                s = "\n******************\n\n";
                this._logStream.write(s.getBytes());
            }
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    public void invokeOneWay(String endpoint, SOAPMessageContext context) {
        try {
            if (this._logStream != null) {
                String s = "\n******************\nRequest\n";
                this._logStream.write(s.getBytes());
                context.getMessage().writeTo(this._logStream);
            }
            this._handler.handle(context);
            context.setFailure(false);
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                throw new ClientTransportException("local.client.failed", (Localizable)((Object)e));
            }
            throw new ClientTransportException("local.client.failed", new LocalizableExceptionAdapter(e));
        }
    }

    public LocalClientTransport(Handler handler, OutputStream logStream) {
        this._handler = handler;
        this._logStream = logStream;
    }
}

