/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import com.sun.ssoadapter.impl.JavaMailSSOAdapter;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Store;

public class ExchangeMailSSOAdapter
extends JavaMailSSOAdapter {
    protected Store mailStore = null;
    protected Session mailSession = null;

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String hostString;
        String protocolString = this.adapterProperties.getProperty("protocol");
        if (protocolString == null || !protocolString.equals("imap") && !protocolString.equals("pop3")) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("invalidProtocol");
            throw ve;
        }
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String uidString = this.adapterProperties.getProperty("uid");
        if (uidString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingUid");
            throw ve;
        }
        String passwordString = this.adapterProperties.getProperty("password");
        if (passwordString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingPassword");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        Store obj = null;
        try {
            obj = this.getStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public Store getStore() throws Exception {
        if (this.isAvailable()) {
            return this.mailStore;
        }
        Session mailSession = this.getSession();
        String protocolString = this.adapterProperties.getProperty("protocol");
        this.mailStore = mailSession.getStore(protocolString);
        String portString = this.adapterProperties.getProperty("port", protocolString.equals("pop3") ? "110" : "143");
        this.mailStore.connect(this.adapterProperties.getProperty("host"), Integer.parseInt(portString), this.adapterProperties.getProperty("uid"), this.adapterProperties.getProperty("password"));
        return this.mailStore;
    }

    public Session getSession() throws Exception {
        if (this.mailSession != null) {
            return this.mailSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String smtpPort = this.adapterProperties.getProperty("smtpPort");
        props.put("mail.store.pkgs", "com.sun.mail");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.imap.fetchsize", "16384");
        props.put("mail.smtp.host", this.adapterProperties.getProperty("smtpServer", host));
        if (smtpPort != null) {
            props.put("mail.smtp.port", smtpPort);
        }
        this.mailSession = Session.getInstance((Properties)props, null);
        return this.mailSession;
    }

    public boolean isAvailable() {
        return this.mailStore != null && this.mailStore.isConnected();
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.mailStore.close();
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.mailStore != null) {
                this.mailStore.close();
            }
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

