/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.calendar.pim;

import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimUserInfo;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import com.sun.ssoadapter.calendar.pim.APimCalendar;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Properties;
import java.util.TimeZone;

public class APimCalStore
extends CalendarStore {
    PimContainer pimContainer = null;
    PimUserInfo pimUserInfo;
    boolean connected = false;
    String calid = null;

    public APimCalStore(CalendarSession session) {
        super(session);
        TimeZone tz = session.getTimeZone();
        if (tz == null) {
            session.setTimeZone(TimeZone.getDefault());
        }
    }

    protected void connectURL(URLName url) throws CalendarStoreException {
        try {
            CalendarSession session = this.getSession();
            String pimService = session.getProperty("cal.pim.service", "exchange");
            String username = url.getUsername();
            String password = url.getPassword();
            String host = url.getHost();
            int port = url.getPort();
            if (pimService.equalsIgnoreCase("exchange")) {
                this.pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.EXCHANGE);
                String NTDomain = session.getProperty("cal.exchange.domain");
                String ocxhost = session.getProperty("cal.exchange.ocxhost", host);
                this.pimUserInfo = this.pimContainer.addUserInfo();
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_OCXHOST_LOCATION, ocxhost);
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_NT_DOMAIN, NTDomain);
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_USERNAME, username);
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_PASSWORD, password);
                this.pimUserInfo.set(PimUserInfoParameter.EXCHANGE_SERVER, host);
            } else if (pimService.equalsIgnoreCase("notes")) {
                this.pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.LOTUS);
                this.pimUserInfo = this.pimContainer.addUserInfo();
                if (port > 0) {
                    host = host + ":" + port;
                }
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_USERNAME, username);
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_PASSWORD, password);
                this.pimUserInfo.set(PimUserInfoParameter.LOTUS_SERVER, host);
            } else {
                throw new CalendarStoreException("Unknown service specified");
            }
            this.pimContainer.logon();
            this.connected = true;
            this.calid = this.pimContainer.getCurrentUser().getName();
            this.pimUserInfo.set(PimUserInfoParameter.DEBUG, "true");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarStoreException(e.getMessage());
        }
    }

    public void disconnect() throws CalendarStoreException {
        try {
            this.pimContainer.logoff();
            this.connected = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CalendarStoreException(e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void importCalendar(String cid, DateTime start, DateTime end, String contentFormat, InputStream inputStream) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method importCalendar() not supported");
    }

    public void importCalendar(String cid, String contentFormat, InputStream inputStream) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method importCalendar() not supported");
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method exportCalendar() not supported");
    }

    public BufferedReader exportCalendar(String cid, DateTime start, DateTime end, String contentFormat, String host, int port) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method exportCalendar() not supported");
    }

    public void deleteCalendar(String cid) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method deleteCalendar() not supported");
    }

    public ICalendar createCalendar(String cid, Properties props) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method createCalendar() not supported");
    }

    public ICalendar createCalendar(String cid) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method createCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchFilter) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method searchCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method searchCalendar() not supported");
    }

    public ICalendar[] searchCalendars(String searchFilter, Properties requestProperties) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("This method searchCalendars(..) is not supported");
    }

    public ICalendar[] searchCalendars(String searchString, int searchOpt, int maxResults, Properties requestProperties) throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("This method searchCalendars(..) is not supported");
    }

    public ICalendar[] getCalendars() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getCalendars() not supported");
    }

    public String[] getSubscribedCalenders() throws CalendarStoreException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Method getSubscribedCalendars() not supported");
    }

    public String verifyCalendarId(String cid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Method verifyCalendarId(String) not supported");
    }

    protected String getDefaultCalendarId() {
        return this.calid;
    }

    protected ICalendar loadCalendar(String calId) throws CalendarStoreException {
        try {
            return new APimCalendar(this, calId);
        }
        catch (CalendarException cex) {
            cex.printStackTrace();
            throw new CalendarStoreException(cex.getMessage());
        }
    }

    protected void unloadCalendar(ICalendar cal) throws CalendarStoreException {
    }

    public PimContainer getPimContainer() {
        return this.pimContainer;
    }
}

