/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.window.util;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.WindowState;
import com.sun.portal.desktop.util.Integers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderRules {
    private static final Map _windowStateMap = ProviderRules.getWindowStateMap();
    private static final Map _windowStateReverseMap = ProviderRules.getWindowStateReverseMap();
    private static List channelModeVE = new ArrayList();
    private static List channelModeH = new ArrayList();
    private static List channelModeV = new ArrayList();
    private static List windowStateMN = new ArrayList();
    private static List windowStateALL = new ArrayList();

    private static Map getWindowStateMap() {
        HashMap<Integer, WindowState> _windowStateMap = new HashMap<Integer, WindowState>();
        _windowStateMap.put(Integers.get((int)1), WindowState.MINIMIZED);
        _windowStateMap.put(Integers.get((int)3), WindowState.MAXIMIZED);
        _windowStateMap.put(Integers.get((int)2), WindowState.NORMAL);
        return _windowStateMap;
    }

    private static Map getWindowStateReverseMap() {
        HashMap<WindowState, Integer> _windowStateReverseMap = new HashMap<WindowState, Integer>();
        _windowStateReverseMap.put(WindowState.MINIMIZED, Integers.get((int)1));
        _windowStateReverseMap.put(WindowState.MAXIMIZED, Integers.get((int)3));
        _windowStateReverseMap.put(WindowState.NORMAL, Integers.get((int)2));
        return _windowStateReverseMap;
    }

    public static List getAllowableChannelModes(ChannelMode mode, boolean authless) {
        if (mode == null) {
            throw new IllegalArgumentException("mode passed is null in getAllowableChannelModes.");
        }
        if (mode.equals((Object)ChannelMode.VIEW)) {
            if (authless) {
                return channelModeV;
            }
            return channelModeVE;
        }
        if (mode.equals((Object)ChannelMode.EDIT)) {
            if (authless) {
                throw new AssertionError((Object)"Authless should not be in edit mode ever.");
            }
            return channelModeVE;
        }
        if (mode.equals((Object)ChannelMode.HELP)) {
            return channelModeH;
        }
        return null;
    }

    public static List getDefaultAllowableWindowStates(ChannelMode mode) {
        if (mode == null) {
            throw new RuntimeException("mode passed is null in getAllowableWindowStates.");
        }
        if (mode.equals((Object)ChannelMode.VIEW)) {
            return windowStateALL;
        }
        if (mode.equals((Object)ChannelMode.EDIT)) {
            return windowStateMN;
        }
        if (mode.equals((Object)ChannelMode.HELP)) {
            return windowStateMN;
        }
        return null;
    }

    public static boolean validateWindowStateChange(ChannelMode channelMode, WindowState windowState) {
        boolean validState = true;
        if (channelMode == null || windowState == null) {
            return true;
        }
        if ((channelMode.equals((Object)ChannelMode.EDIT) || channelMode.equals((Object)ChannelMode.HELP)) && windowState.equals((Object)WindowState.MINIMIZED)) {
            validState = false;
        }
        return validState;
    }

    public static List mapToStandards(int[] portalWindowStates) {
        ArrayList<WindowState> newList = new ArrayList<WindowState>();
        for (int i = 0; portalWindowStates != null && i < portalWindowStates.length; ++i) {
            WindowState winState = (WindowState)_windowStateMap.get(Integers.get((int)portalWindowStates[i]));
            if (winState == null) continue;
            newList.add(winState);
        }
        return newList;
    }

    public static WindowState mapToStandards(int portalWindowState) {
        WindowState winState = (WindowState)_windowStateMap.get(Integers.get((int)portalWindowState));
        return winState;
    }

    public static int mapToProvider(WindowState windowState) {
        int winState = (Integer)_windowStateReverseMap.get(windowState);
        return winState;
    }

    public static WindowState getDefaultWindowState(ChannelMode channelMode) {
        if (ChannelMode.VIEW.equals((Object)channelMode)) {
            return WindowState.NORMAL;
        }
        if (ChannelMode.HELP.equals((Object)channelMode)) {
            return WindowState.MAXIMIZED;
        }
        if (ChannelMode.EDIT.equals((Object)channelMode)) {
            return WindowState.MAXIMIZED;
        }
        return WindowState.NORMAL;
    }

    static {
        channelModeVE.add(ChannelMode.VIEW);
        channelModeVE.add(ChannelMode.EDIT);
        channelModeV.add(ChannelMode.VIEW);
        channelModeH.add(ChannelMode.HELP);
        windowStateMN.add(WindowState.MAXIMIZED);
        windowStateMN.add(WindowState.NORMAL);
        windowStateALL.add(WindowState.NORMAL);
        windowStateALL.add(WindowState.MAXIMIZED);
        windowStateALL.add(WindowState.MINIMIZED);
    }
}

