/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.util;

import com.sun.portal.desktop.util.Integers;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ProviderWidths;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.util.IntegerStringComparator;
import com.sun.portal.providers.util.PropertyUtil;
import com.sun.portal.providers.util.ProviderProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class ProviderOrder
implements ProviderProperties,
ProviderWidths {
    static IntegerStringComparator intStrComp = new IntegerStringComparator();

    public static List order(List providers, String parent, ContainerProviderContext pc, HttpServletRequest req) throws ProviderException {
        Integer width;
        String ONE = "1";
        String THREE = "3";
        HashMap<Integer, Map<String, OrderElement>> widths = new HashMap<Integer, Map<String, OrderElement>>();
        Map channelsColumn = null;
        Map channelsRow = null;
        Map channelsIsMovable = null;
        boolean dIsMovable = true;
        String defaultChannelRow = ONE;
        String defaultChannelColumn = ONE;
        int layout = 0;
        try {
            layout = pc.getIntegerProperty(parent, "layout");
            channelsColumn = pc.getCollectionProperty(parent, "channelsColumn");
            channelsRow = pc.getCollectionProperty(parent, "channelsRow");
            channelsIsMovable = pc.getCollectionProperty(parent, "channelsIsMovable");
            defaultChannelRow = pc.getStringProperty(parent, "defaultChannelRow");
            defaultChannelColumn = pc.getStringProperty(parent, "defaultChannelColumn");
            dIsMovable = pc.getBooleanProperty(parent, "defaultChannelIsMovable");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderOrder.order(): ", pce);
        }
        for (int i = 0; i < providers.size(); ++i) {
            String providerName = (String)providers.get(i);
            width = null;
            Provider p = null;
            try {
                p = pc.getProvider(req, parent, providerName);
                if (p == null) continue;
                width = Integers.get((int)p.getWidth());
            }
            catch (ProviderException e) {
                pc.debugError("ProviderOrder.order(): got ProviderException for providerName=" + providerName);
                width = Integers.get((int)0);
            }
            String col = PropertyUtil.getStringValueFromMap(channelsColumn, providerName, defaultChannelColumn);
            String row = PropertyUtil.getStringValueFromMap(channelsRow, providerName, defaultChannelRow);
            boolean movable = PropertyUtil.getBooleanValueFromMap(channelsIsMovable, providerName, dIsMovable);
            if (pc.isDebugMessageEnabled()) {
                pc.debugMessage("ProviderOrder.order(): providerName=" + providerName);
                pc.debugMessage("ProviderOrder.order(): width=" + width);
                pc.debugMessage("ProviderOrder.order(): col=" + col);
                pc.debugMessage("ProviderOrder.order(): row=" + row);
                pc.debugMessage("ProviderOrder.order(): movable=" + movable);
            }
            switch (width) {
                case 2: 
                case 3: {
                    col = ONE;
                    break;
                }
                case 1: {
                    switch (layout) {
                        case 1: 
                        case 2: {
                            col = ONE;
                            break;
                        }
                        case 3: {
                            if (!col.equals(THREE)) break;
                            col = ONE;
                        }
                    }
                    break;
                }
                case 0: {
                    col = ONE;
                }
            }
            Map<String, OrderElement> cols = null;
            if (!widths.containsKey(width)) {
                cols = new TreeMap(intStrComp);
                widths.put(width, cols);
            } else {
                cols = (Map)widths.get(width);
            }
            OrderElement oe = null;
            if (!cols.containsKey(col)) {
                oe = new OrderElement();
                cols.put(col, oe);
            } else {
                oe = (OrderElement)cols.get(col);
            }
            if (pc.isDebugMessageEnabled()) {
                pc.debugMessage("ProviderOrder.order(): oe=" + oe);
            }
            Map rows = null;
            if (movable) {
                if (oe.order == null) {
                    oe.order = new TreeMap(intStrComp);
                }
                rows = oe.order;
            } else {
                if (oe.lockedOrder == null) {
                    oe.lockedOrder = new TreeMap(intStrComp);
                }
                rows = oe.lockedOrder;
            }
            if (!rows.containsKey(row)) {
                ArrayList<String> newRowList = new ArrayList<String>();
                newRowList.add(providerName);
                rows.put(row, newRowList);
                continue;
            }
            ((List)rows.get(row)).add(providerName);
        }
        ArrayList ordered = new ArrayList();
        Iterator l = widths.keySet().iterator();
        while (l.hasNext()) {
            width = (Integer)l.next();
            Map cols = (Map)widths.get(width);
            ArrayList widthOrdered = new ArrayList();
            Iterator i = cols.keySet().iterator();
            while (i.hasNext()) {
                String index;
                Iterator j;
                String col = (String)i.next();
                OrderElement oe = (OrderElement)cols.get(col);
                ArrayList colOrdered = new ArrayList();
                if (oe.order != null) {
                    j = oe.order.keySet().iterator();
                    while (j.hasNext()) {
                        index = (String)j.next();
                        colOrdered.addAll((List)oe.order.get(index));
                    }
                }
                if (oe.lockedOrder != null) {
                    j = oe.lockedOrder.keySet().iterator();
                    while (j.hasNext()) {
                        index = (String)j.next();
                        int k = Math.max(Math.min(Integer.parseInt(index) - 1, colOrdered.size()), 0);
                        colOrdered.addAll(k, (List)oe.lockedOrder.get(index));
                    }
                }
                widthOrdered.addAll(colOrdered);
            }
            ordered.addAll(widthOrdered);
        }
        return ordered;
    }

    private static class OrderElement {
        public Map order = null;
        public Map lockedOrder = null;

        private OrderElement() {
        }
    }
}

