/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.compiler;

import com.sun.portal.providers.jsp.jasper3.jasper.Constants;
import com.sun.portal.providers.jsp.jasper3.jasper.JasperException;
import com.sun.portal.providers.jsp.jasper3.jasper.compiler.TagCache;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class TagLibraries {
    private Hashtable tagLibInfos = new Hashtable();
    private Hashtable tagCaches = new Hashtable();
    private ClassLoader cl;

    public TagLibraries(ClassLoader cl) {
        this.cl = cl;
    }

    public void addTagLibrary(String prefix, TagLibraryInfo tli) {
        this.tagLibInfos.put(prefix, tli);
    }

    public boolean isUserDefinedTag(String prefix, String shortTagName) throws JasperException {
        TagLibraryInfo tli = (TagLibraryInfo)this.tagLibInfos.get(prefix);
        if (tli == null) {
            return false;
        }
        if (tli.getTag(shortTagName) != null) {
            return true;
        }
        throw new JasperException(Constants.getString("jsp.error.bad_tag", new Object[]{shortTagName, prefix}));
    }

    public TagLibraryInfo getTagLibInfo(String prefix) {
        return (TagLibraryInfo)this.tagLibInfos.get(prefix);
    }

    public TagCache getTagCache(String prefix, String shortTagName) {
        return (TagCache)this.tagCaches.get(new TagID(prefix, shortTagName));
    }

    public void putTagCache(String prefix, String shortTagName, TagCache tc) {
        this.tagCaches.put(new TagID(prefix, shortTagName), tc);
    }

    private static class TagID {
        private String prefix;
        private String shortTagName;

        public TagID(String prefix, String shortTagName) {
            this.prefix = prefix;
            this.shortTagName = shortTagName;
        }

        public boolean equals(Object obj) {
            return this.prefix.equals(((TagID)obj).prefix) && this.shortTagName.equals(((TagID)obj).shortTagName);
        }

        public int hashCode() {
            return this.prefix.hashCode() + this.shortTagName.hashCode();
        }
    }
}

