/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.DesktopRequest;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.DesktopResponse;
import com.sun.portal.desktop.DesktopThreadLocalManager;
import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextFactory;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.PSDesktopContextFactoryManager;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderEditTypes;
import com.sun.portal.providers.error.ErrorProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DesktopServlet
extends HttpServlet
implements ProviderEditTypes {
    private static Provider errorProvider = new ErrorProvider();
    private static DesktopAppContext appContext = null;
    private static DesktopContextFactory dcFactory = null;
    private static final String LIBERTY_SSO_FAILED_QUERY_PARAM = "libertySSOFailed";

    private static void printSystemProperties() {
        Properties envProps = System.getProperties();
        DesktopAppContextThreadLocalizer.get().debugError((Object)"__________________________ BEGIN JAVA SETTINGS _______________________________");
        Enumeration<?> e = envProps.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            DesktopAppContextThreadLocalizer.get().debugError((Object)(prop + " : " + envProps.getProperty(prop)));
        }
        DesktopAppContextThreadLocalizer.get().debugError((Object)"_____________________________END JAVA SETTINGS _______________________________");
    }

    protected static DesktopContextFactory getDesktopContextFactory(ServletConfig sc) {
        if (dcFactory == null) {
            dcFactory = PSDesktopContextFactoryManager.getFactory((ServletContext)sc.getServletContext());
        }
        return dcFactory;
    }

    private void printConfigAttributes() {
        DesktopServlet.printConfigAttributes(this.getServletConfig().getServletContext());
    }

    public static void printConfigAttributes(ServletContext sc) {
        appContext.debugError((Object)"__________________________ BEGIN CONTEXT ATTRS __________________________");
        Enumeration e = sc.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object val = sc.getAttribute(name);
            appContext.debugError((Object)(name + "=" + val));
        }
        appContext.debugError((Object)"__________________________ END CONTEXT ATTRs ________________________");
    }

    private void printInitParameters() {
        appContext.debugError((Object)"__________________________ BEGIN INIT PARAMS  _______________________________");
        Enumeration e = this.getServletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String val = this.getServletConfig().getInitParameter(name);
            appContext.debugError((Object)(name + "=" + val));
        }
        appContext.debugError((Object)"__________________________ END INIT PARAMS  _________________________________");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DesktopServlet.getDesktopContextFactory(config);
        appContext = dcFactory.getDesktopAppContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block30: {
            int i;
            Writer out;
            String contentType;
            String charset;
            block29: {
                block28: {
                    charset = "UTF-8";
                    contentType = null;
                    out = null;
                    i = -1;
                    long start = 0L;
                    long end = 0L;
                    if (appContext == null) {
                        throw new DesktopException("DesktopServlet.service(): app context was null");
                    }
                    if (appContext.isPasContextActivated()) {
                        start = System.currentTimeMillis();
                    }
                    String clientType = appContext.getClientType(req);
                    contentType = appContext.getContentType(clientType);
                    DesktopRequest dreq = new DesktopRequest(req, appContext, false);
                    DesktopResponse dres = new DesktopResponse(res);
                    DesktopThreadLocalManager.init((DesktopAppContext)appContext, (HttpServletRequest)dreq, (HttpServletResponse)dres, (HttpServletRequest)req, (HttpServletResponse)res, (ServletConfig)this.getServletConfig(), (ServletContext)this.getServletConfig().getServletContext(), null);
                    i = PerfThreadLocalizer.mark();
                    int j = PerfThreadLocalizer.mark();
                    boolean isValidSession = appContext.validateSession((HttpServletRequest)dreq);
                    boolean authlessEnabled = appContext.isAuthlessEnabled();
                    boolean federationEnabled = appContext.isFederationEnabled();
                    PerfThreadLocalizer.add((int)j, (String)"DesktopServlet.service():validateSession");
                    if (isValidSession) {
                        this.doGetPost(req, res);
                        if (appContext.isPasContextActivated()) {
                            end = System.currentTimeMillis();
                            appContext.logProcessTime("servlet", "doGetPost", "desktop", end - start);
                        }
                        break block28;
                    }
                    if (!federationEnabled && authlessEnabled) {
                        if (appContext.validateAuthlessSession((HttpServletRequest)dreq)) {
                            this.doGetPost(req, res);
                            if (appContext.isPasContextActivated()) {
                                end = System.currentTimeMillis();
                                appContext.logProcessTime("servlet", "doGetPost", "desktop", end - start);
                            }
                        } else {
                            this.showLocalAuth(req, res, dreq, out, clientType, contentType, charset);
                        }
                        break block28;
                    }
                    if (federationEnabled) {
                        String libSSOFailedParam = dreq.getParameter(LIBERTY_SSO_FAILED_QUERY_PARAM);
                        if ("true".equalsIgnoreCase(libSSOFailedParam)) {
                            if (authlessEnabled && appContext.validateAuthlessSession((HttpServletRequest)dreq)) {
                                this.doGetPost(req, res);
                                if (appContext.isPasContextActivated()) {
                                    end = System.currentTimeMillis();
                                    appContext.logProcessTime("servlet", "doGetPost", "desktop", end - start);
                                }
                            } else {
                                this.showLocalAuth(req, res, dreq, out, clientType, contentType, charset);
                            }
                        } else {
                            this.invokePreLogin(req, res, dreq, out, clientType, contentType, charset);
                        }
                        break block28;
                    }
                    this.showLocalAuth(req, res, dreq, out, clientType, contentType, charset);
                }
                Object var20_19 = null;
                if (out == null) break block29;
                try {
                    out.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            PerfThreadLocalizer.add((int)i, (String)"DesktopServlet.service()");
            appContext.perfError((Object)("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results()));
            DesktopThreadLocalManager.release();
            {
                break block30;
                catch (IOException ioe) {
                    Object var20_20 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    PerfThreadLocalizer.add((int)i, (String)"DesktopServlet.service()");
                    appContext.perfError((Object)("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results()));
                    DesktopThreadLocalManager.release();
                    break block30;
                }
                catch (Throwable t) {
                    if (out == null) {
                        out = DesktopServlet.getWriter(res, contentType, charset);
                    }
                    this.handleException(req, res, out, t);
                    Object var20_21 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    PerfThreadLocalizer.add((int)i, (String)"DesktopServlet.service()");
                    appContext.perfError((Object)("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results()));
                    DesktopThreadLocalManager.release();
                }
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                PerfThreadLocalizer.add((int)i, (String)"DesktopServlet.service()");
                appContext.perfError((Object)("DesktopServlet.service(): perfStats=\n" + PerfThreadLocalizer.results()));
                DesktopThreadLocalManager.release();
                throw throwable;
            }
        }
    }

    private void invokePreLogin(HttpServletRequest req, HttpServletResponse res, DesktopRequest dreq, Writer out, String clientType, String contentType, String charset) throws IOException, DesktopException {
        String preLoginURL;
        StringBuffer returnURL = new StringBuffer(DesktopServlet.getAbsURL((HttpServletRequest)dreq, appContext, dreq.getRequestURI()));
        boolean queryExists = false;
        if (dreq.getParameterMap().size() > 0) {
            String query = dreq.getQueryString();
            returnURL.append("?").append(query);
            queryExists = true;
        }
        if ((preLoginURL = appContext.getPreLoginURL(returnURL.toString(), LIBERTY_SSO_FAILED_QUERY_PARAM)) == null) {
            appContext.debugError((Object)"DesktopServlet.invokePreLogin(): Liberty misconfiguration.");
            if (queryExists) {
                returnURL.append("&");
            } else {
                returnURL.append("?");
            }
            returnURL.append(LIBERTY_SSO_FAILED_QUERY_PARAM).append("=true");
            preLoginURL = returnURL.toString();
        }
        if (appContext.isDebugMessageEnabled()) {
            appContext.debugMessage((Object)("DesktopServlet.invokePreLogin(): preLogin url is " + preLoginURL));
        }
        out = DesktopServlet.getWriter(res, contentType, charset);
        DesktopServlet.sendRedirect(req, res, out, preLoginURL);
    }

    private void showLocalAuth(HttpServletRequest req, HttpServletResponse res, DesktopRequest dreq, Writer out, String clientType, String contentType, String charset) throws IOException, DesktopException {
        String noSessionURL = appContext.getNoSessionURL();
        if (noSessionURL == null) {
            if (appContext.isDebugWarningEnabled()) {
                appContext.debugWarning((Object)"DesktopServlet.service(): Failed to get no session URL. Using default URL /");
            }
            noSessionURL = "/";
        }
        StringBuffer redirectURL = new StringBuffer(noSessionURL);
        String returnParam = appContext.getSessionReturnURLParamName();
        if (returnParam != null && returnParam.length() > 0) {
            StringBuffer returnURL = new StringBuffer(DesktopServlet.getAbsURL((HttpServletRequest)dreq, appContext, dreq.getRequestURI()));
            if (dreq.getParameterMap().size() > 0) {
                String query = dreq.getQueryString();
                returnURL.append("?").append(query);
            }
            redirectURL.append(noSessionURL.indexOf(63) < 0 ? "?" : "&");
            redirectURL.append(returnParam).append("=").append(URLEncoder.encode(returnURL.toString()));
        }
        if (appContext.isDebugMessageEnabled()) {
            appContext.debugMessage((Object)("DesktopServlet.showLocalAuth: Invalid session - redirecting to : " + redirectURL));
        }
        out = DesktopServlet.getWriter(res, contentType, charset);
        DesktopServlet.sendRedirect(req, res, out, redirectURL.toString());
    }

    private static Writer getWriter(HttpServletResponse res, String contentType, String charset) throws IOException {
        if (contentType != null) {
            if (charset != null) {
                res.setContentType(contentType + "; charset=" + charset);
            } else {
                res.setContentType(contentType);
            }
        }
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter((OutputStream)res.getOutputStream(), charset);
        return writer;
    }

    protected DesktopContext getDesktopContext(HttpServletRequest req) throws DesktopException {
        return dcFactory.getDesktopContext(req);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGetPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block54: {
            block53: {
                block51: {
                    block49: {
                        i = PerfThreadLocalizer.mark();
                        out = null;
                        charset = "UTF-8";
                        contentType = null;
                        context = null;
                        name = null;
                        try {
                            try {
                                DesktopServlet.setCacheHeaders(res);
                                context = this.getDesktopContext(req);
                                context.refresh();
                                charset = DesktopServlet.getCharset(req);
                                if (context == null) {
                                    out = DesktopServlet.getWriter(res, contentType, charset);
                                    this.handleException(req, res, out, new Exception());
                                    var21_9 = null;
                                    if (out == null) return;
                                    break block49;
                                }
                                dreq = (DesktopRequest)DesktopRequestThreadLocalizer.getRequest();
                                reqEncoding = req.getCharacterEncoding();
                                if (reqEncoding != null) {
                                    dreq.decodeParams(reqEncoding);
                                } else {
                                    dreq.decodeParams(charset);
                                }
                                clientType = DesktopServlet.appContext.getClientType(req);
                                contentType = DesktopServlet.appContext.getContentType(clientType);
                                dres = (DesktopResponse)DesktopRequestThreadLocalizer.getResponse();
                                action = dreq.getParameter("action");
                                if (action == null || action.length() == 0) {
                                    action = "content";
                                }
                                outBuffer = null;
                                res.setContentType(context.getContentType() + "; charset=" + charset);
                                if (!context.isExecutable()) {
                                    throw new DesktopException("DesktopServlet.doGetPost(): no privilege to execute desktop", "noPrivilege");
                                }
                                if (context.isDebugMessageEnabled()) {
                                    context.debugMessage((Object)("DesktopServlet.doGetPost(): action=" + action));
                                    context.debugMessage((Object)("DesktopServlet.doGetPost(): name=" + name));
                                }
                                if ((name = this.getChannelName((HttpServletRequest)dreq, true)) == null) {
                                    throw new DesktopException("DesktopServlet.doGetPost(): no privilege to execute desktop", "noPrivilege");
                                }
                                context.setTopChannelName((HttpServletRequest)dreq, name);
                                next = null;
                                if (action.equalsIgnoreCase("content")) {
                                    p = context.getProvider((HttpServletRequest)dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name, "unknownChannel");
                                    }
                                    if (p.isPresentable((HttpServletRequest)dreq)) {
                                        last = dreq.getParameter("last");
                                        if (last == null || last.equalsIgnoreCase("true")) {
                                            context.setDefaultChannelName(name);
                                        }
                                        j = PerfThreadLocalizer.mark();
                                        outBuffer = context.getContent((HttpServletRequest)dreq, (HttpServletResponse)dres, name);
                                        PerfThreadLocalizer.add((int)j, (String)"DesktopServlet.doGetPost():getContent");
                                    } else {
                                        res.sendError(406);
                                    }
                                } else if (action.equalsIgnoreCase("edit")) {
                                    name = this.getChannelName((HttpServletRequest)dreq, false);
                                    p = context.getProvider((HttpServletRequest)dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name, "unknownChannel");
                                    }
                                    if (!p.isEditable()) {
                                        throw new DesktopException("attempt to edit non-editable channel=" + name, "nonEditableChannel");
                                    }
                                    if (p.getEditType() == 3) {
                                        containerName = context.getEditProviderContainerName();
                                        editProvider = context.getProvider((HttpServletRequest)dreq, containerName);
                                        dreq.getParameterMap().put("targetprovider", p.getName());
                                        outBuffer = editProvider.getEdit((HttpServletRequest)dreq, (HttpServletResponse)dres);
                                    } else {
                                        outBuffer = p.getEdit((HttpServletRequest)dreq, (HttpServletResponse)dres);
                                    }
                                } else {
                                    if (!action.equalsIgnoreCase("process")) {
                                        if (action.equalsIgnoreCase("logout") == false) throw new DesktopException("DestopServlet.doGetPost(): unknown action=" + action + ", channel name=" + name);
                                        context.store();
                                        out = DesktopServlet.getWriter(res, contentType, charset);
                                        DesktopServlet.sendRedirect(req, res, out, context.getLogoutURL());
                                        break block51;
                                    }
                                    name = this.getChannelName((HttpServletRequest)dreq, false);
                                    p = context.getProvider((HttpServletRequest)dreq, name);
                                    if (p == null) {
                                        throw new DesktopException("attempt to reference unknown channel=" + name, "unknownChannel");
                                    }
                                    if (!p.isEditable()) {
                                        throw new DesktopException("attempt to process non-editable channel=" + name, "nonEditableChannel");
                                    }
                                    try {
                                        next = p.processEdit((HttpServletRequest)dreq, (HttpServletResponse)dres);
                                    }
                                    catch (InvalidEditFormDataException e) {
                                        if (context.isDebugWarningEnabled()) {
                                            context.debugWarning((Object)"DesktopServlet.doGetPost()", (Throwable)e);
                                        }
                                        error = I18n.IURLEncode((String)e.getMessage());
                                        args = new StringBuffer(64);
                                        args.append("?action=edit&provider=").append(name).append("&error=").append(error);
                                        next = new URL(context.getDesktopURL((HttpServletRequest)dreq) + args.toString());
                                    }
                                }
                                out = DesktopServlet.getWriter(res, contentType, charset);
                                if (action.equalsIgnoreCase("process")) {
                                    if (next == null) {
                                        nextString = new StringBuffer(context.getDesktopURL((HttpServletRequest)dreq));
                                        nextString.append("?action=content&provider=").append(context.getDefaultChannelName());
                                        DesktopServlet.sendRedirect(req, res, out, nextString.toString());
                                    } else {
                                        if (context.isDebugMessageEnabled()) {
                                            context.debugMessage((Object)("DesktopServlet.doPost(): next=" + next.toString()));
                                        }
                                        DesktopServlet.sendRedirect(req, res, out, next.toString());
                                    }
                                } else {
                                    if (outBuffer == null) throw new DesktopException("Channel content is empty for " + name);
                                    out.write(outBuffer.toString());
                                }
                                context.store();
                                break block53;
                            }
                            catch (IOException ioe) {
                                var21_12 = null;
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException ioe) {}
                                }
                                break block54;
                            }
                            catch (Throwable e) {
                                if (res.isCommitted()) {
                                    DesktopServlet.appContext.debugError((Object)"DesktopServlet.doGetPost()", e);
                                } else {
                                    res.reset();
                                    try {
                                        DesktopServlet.setCacheHeaders(res);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    out = DesktopServlet.getWriter(res, contentType, charset);
                                    this.handleException(req, res, out, e);
                                }
                                var21_13 = null;
                                if (out != null) {
                                    try {}
                                    catch (IOException ioe) {}
                                    out.close();
                                }
                                break block54;
                            }
                        }
                        catch (Throwable var20_39) {
                            var21_14 = null;
                            if (out == null) throw var20_39;
                            ** try [egrp 4[TRYBLOCK] [14 : 1268->1276)] { 
lbl149:
                            // 1 sources

                            out.close();
                            throw var20_39;
lbl151:
                            // 1 sources

                            catch (IOException ioe) {
                                // empty catch block
                            }
                            throw var20_39;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [14 : 1268->1276)] { 
lbl156:
                    // 1 sources

                    out.close();
                    return;
lbl158:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                var21_10 = null;
                if (out == null) return;
                ** try [egrp 4[TRYBLOCK] [14 : 1268->1276)] { 
lbl165:
                // 1 sources

                out.close();
                return;
lbl167:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var21_11 = null;
            if (out != null) {
                try {}
                catch (IOException ioe) {}
                out.close();
            }
        }
        PerfThreadLocalizer.add((int)i, (String)"DesktopServlet.doGetPost()");
    }

    private static void sendRedirect(HttpServletRequest req, HttpServletResponse res, Writer out, String u) throws IOException, DesktopException {
        DesktopContext dc;
        block9: {
            dc = null;
            try {
                dc = DesktopContextThreadLocalizer.get();
            }
            catch (ContextError c) {
                if (!appContext.isDebugMessageEnabled()) break block9;
                appContext.debugMessage((Object)"DesktopServlet.sendRedirect(): could not getDesktopContext");
            }
        }
        u = DesktopServlet.getAbsURL(req, appContext, u);
        if (!req.getMethod().equalsIgnoreCase("head")) {
            String clientType = appContext.getClientType(req);
            String clientPath = appContext.getClientPath(clientType);
            StringBuffer redirect = null;
            if (clientType != null) {
                String contentType = appContext.getContentType(clientType);
                String charset = DesktopServlet.getCharset(req);
                String type = appContext.getDefaultDesktopType();
                if (dc != null) {
                    u = dc.encodeURL(u);
                    type = dc.getDesktopType();
                }
                Hashtable<String, String> tags = new Hashtable<String, String>();
                tags.put("url", u);
                redirect = appContext.getTemplate(type, Locale.getDefault().toString(), null, null, clientPath, "redirect.template", tags, appContext.getTemplateBaseDir());
                if (appContext.isDebugMessageEnabled()) {
                    appContext.debugMessage((Object)("DesktopServlet.sendRedirect(): redirect (302) body=" + redirect));
                }
                if (redirect != null) {
                    out.write(redirect.toString());
                } else if (appContext.isDebugWarningEnabled()) {
                    appContext.debugWarning((Object)"DesktopServlet.sendRedirect(): could not get redirect template");
                }
            }
        }
        res.setStatus(302);
        res.setHeader("Location", u);
    }

    private static String getAbsURL(HttpServletRequest req, DesktopAppContext appContext, String u) throws IOException {
        if (!u.regionMatches(true, 0, "http://", 0, 7) && !u.regionMatches(true, 0, "https://", 0, 7)) {
            StringBuffer ru = appContext.getRequestServer(req);
            URL requestURL = new URL(ru.toString());
            String scheme = requestURL.getProtocol();
            StringBuffer absURL = new StringBuffer().append(scheme).append("://").append(requestURL.getHost()).append(":");
            int port = requestURL.getPort();
            if (scheme.equals("http") && port <= 0) {
                port = 80;
            } else if (scheme.equals("https") && port <= 0) {
                port = 443;
            }
            absURL.append(port).append(u);
            return absURL.toString();
        }
        return u;
    }

    private void handleException(HttpServletRequest req, HttpServletResponse res, Writer out, Throwable e) {
        DesktopContext dc = null;
        String lastChannelName = null;
        try {
            StringBuffer content;
            if (out == null) {
                throw new DesktopException("DesktopServlet.handleException()", e);
            }
            lastChannelName = this.getChannelName(req, true);
            if (DesktopContextThreadLocalizer.exists()) {
                dc = DesktopContextThreadLocalizer.get();
            }
            if (dc != null) {
                req.setAttribute(errorProvider.getName() + ".desktopContext", (Object)dc);
            }
            if (appContext != null) {
                req.setAttribute(errorProvider.getName() + ".desktopAppContext", (Object)appContext);
            }
            if (lastChannelName != null) {
                req.setAttribute(errorProvider.getName() + ".lastChannelName", (Object)lastChannelName);
            }
            if (e != null) {
                req.setAttribute(errorProvider.getName() + ".exception", (Object)e);
            }
            if (e instanceof DesktopException) {
                String propertiesFile = this.getServletConfig().getServletContext().getInitParameter("desktop.propertiesFile");
                req.setAttribute(errorProvider.getName() + ".propertiesFile", (Object)propertiesFile);
                req.setAttribute(errorProvider.getName() + ".response", (Object)RequestThreadLocalizer.getResponse());
            }
            if ((content = errorProvider.getContent(req, res)) != null) {
                out.write(content.toString());
            }
            appContext.debugError((Object)"DesktopServlet.handleException()", e);
        }
        catch (Throwable e2) {
            this.log("DesktopServlet.handleException(): primary=", e2);
            this.log("DesktopServlet.handleException(): root=", e);
            try {
                res.sendError(500);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    protected static void setCacheHeaders(HttpServletResponse res) {
        int cacheTime = appContext.getBrowserCacheInterval();
        if (cacheTime > 0) {
            res.setDateHeader("Expires", System.currentTimeMillis() + (long)(1000 * cacheTime));
            res.setHeader("Cache-Control", "max-age=" + cacheTime);
        } else {
            res.setHeader("Pragma", "no-cache");
            res.setDateHeader("Expires", 0L);
            res.setHeader("Cache-Control", "no-cache, must-revalidate, max-age=0");
        }
    }

    protected static String getCharset(HttpServletRequest req) {
        DesktopContext context = null;
        String charset = null;
        if (DesktopContextThreadLocalizer.exists()) {
            context = DesktopContextThreadLocalizer.get();
            charset = context.getCharset();
        } else {
            Locale locale = Locale.getDefault();
            charset = appContext.getCharset(appContext.getClientType(req), locale);
        }
        return charset;
    }

    private String getChannelName(HttpServletRequest req, boolean useDefaults) throws DesktopException {
        String name = req.getParameter("provider");
        if (name == null && useDefaults && DesktopContextThreadLocalizer.exists()) {
            DesktopContext dc = DesktopContextThreadLocalizer.get();
            name = dc.getDefaultChannelName();
        }
        return name;
    }
}

