/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.PSDefaultFolder;
import com.sun.mail.imap.PSIMAPMessage;
import com.sun.mail.imap.PSIMAPStore;
import com.sun.mail.imap.PSUtility;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.PSIMAPProtocol;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class PSIMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected PSIMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private boolean connectionPoolDebug;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected PSIMAPFolder(String fullName, char separator, PSIMAPStore store) {
        super((Store)store);
        if (fullName == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = fullName;
        this.separator = separator;
        this.messageCacheLock = new Object();
        this.debug = store.getSession().getDebug();
        this.connectionPoolDebug = store.getConnectionPoolDebug();
    }

    protected PSIMAPFolder(ListInfo li, PSIMAPStore store) {
        this(li.name, li.separator, store);
        if (li.hasInferiors) {
            this.type |= 2;
        }
        if (li.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException((Folder)this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException((Folder)this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (msgno <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c = this.getSeparator0();
        int index = this.fullName.lastIndexOf(c);
        if (index != -1) {
            return new PSIMAPFolder(this.fullName.substring(0, index), c, (PSIMAPStore)this.store);
        }
        return new PSDefaultFolder((PSIMAPStore)this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws MessagingException {
        ListInfo[] li = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                li = p.list("", this.fullName);
            }
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        if (li != null) {
            this.fullName = li[0].name;
            this.separator = li[0].separator;
            if (li[0].hasInferiors) {
                this.type |= 2;
            }
            if (li[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String pattern) throws MessagingException {
        return this.doList(pattern, false);
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.doList(pattern, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder[] doList(String pattern, boolean subscribed) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        ListInfo[] li = null;
        PSIMAPProtocol p = null;
        char c = this.getSeparator0();
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                li = subscribed ? p.lsub("", this.fullName + c + pattern) : p.list("", this.fullName + c + pattern);
            }
        }
        catch (CommandFailedException cfx) {
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        if (li == null) {
            return new Folder[0];
        }
        int start = 0;
        if (li[0].name.equals(this.fullName + c)) {
            start = 1;
        }
        Folder[] folders = new PSIMAPFolder[li.length - start];
        for (int i = start; i < li.length; ++i) {
            folders[i - start] = new PSIMAPFolder(li[i], (PSIMAPStore)this.store);
        }
        return folders;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] li = null;
            PSIMAPProtocol p = null;
            try {
                p = this.getStoreProtocol();
                Object object = this.lockFor(p);
                synchronized (object) {
                    li = p.isREV1() ? p.list(this.fullName, "") : p.list("", this.fullName);
                }
            }
            catch (ConnectionException cex) {
                this.throwClosedException(p, (Exception)((Object)cex));
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
            finally {
                this.releaseStoreProtocol(p);
            }
            this.separator = li != null ? li[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() {
        ListInfo[] li = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                li = p.lsub("", this.fullName);
            }
        }
        catch (ProtocolException protocolException) {
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return li != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribed(boolean subscribe) throws MessagingException {
        this.checkExists();
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                if (subscribe) {
                    p.subscribe(this.fullName);
                } else {
                    p.unsubscribe(this.fullName);
                }
            }
        }
        catch (CommandFailedException cfx) {
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean create(int type) throws MessagingException {
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                if ((type & 1) == 0) {
                    p.create(this.fullName + this.getSeparator0());
                } else {
                    ListInfo[] li;
                    p.create(this.fullName);
                    if ((type & 2) != 0 && (li = p.list("", this.fullName)) != null && !li[0].hasInferiors) {
                        p.delete(this.fullName);
                        throw new MessagingException("Unsupported type");
                    }
                }
            }
        }
        catch (CommandFailedException cfx) {
            boolean bl = false;
            return bl;
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        this.exists = true;
        this.type = type;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Folder getFolder(String name) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator0();
        return new PSIMAPFolder(this.fullName + c + name, c, (PSIMAPStore)this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean delete(boolean recurse) throws MessagingException {
        this.checkClosed();
        if (recurse) {
            Folder[] f = this.list();
            for (int i = 0; i < f.length; ++i) {
                f[i].delete(recurse);
            }
        }
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object i = this.lockFor(p);
            synchronized (i) {
                p.delete(this.fullName);
            }
        }
        catch (CommandFailedException cfx) {
            boolean bl = false;
            return bl;
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this.store, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (f.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                p.rename(this.fullName, f.getFullName());
            }
        }
        catch (CommandFailedException cfx) {
            boolean bl = false;
            return bl;
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException(this.store, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(int mode) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mi = null;
        this.protocol = ((PSIMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.protocol.addResponseHandler(this);
            try {
                mi = mode == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (ProtocolException pex) {
                this.protocol.removeResponseHandler(this);
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException pex2) {
                    // empty catch block
                }
                this.protocol = null;
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
            if (!(mi.mode == mode || mode == 2 && mi.mode == 1 && ((PSIMAPStore)this.store).allowReadOnlySelect())) {
                this.protocol.removeResponseHandler(this);
                try {
                    this.protocol.logout();
                }
                catch (ProtocolException pex) {
                    // empty catch block
                }
                this.protocol = null;
                throw new ReadOnlyFolderException((Folder)this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mi.mode;
            this.availableFlags = mi.availableFlags;
            this.permanentFlags = mi.permanentFlags;
            this.total = this.realTotal = mi.total;
            this.recent = mi.recent;
            this.uidvalidity = mi.uidvalidity;
            this.messageCache = new Vector(this.total);
            for (int i = 0; i < this.total; ++i) {
                this.messageCache.addElement(new PSIMAPMessage(this, i + 1, i + 1));
            }
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        this.checkOpened();
        PSIMAPMessage.fetch(this, msgs, fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flag);
        if (msgs.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.protocol.storeFlags(PSUtility.toMessageSet(msgs, null), flag, value);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean expunge) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            block19: {
                if (!this.opened && this.reallyClosed) {
                    throw new IllegalStateException("This operation is not allowed on a closed folder");
                }
                this.reallyClosed = true;
                if (!this.opened) {
                    return;
                }
                try {
                    block20: {
                        if (((PSIMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug) {
                                System.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                            }
                            if (expunge) {
                                this.protocol.close();
                            }
                            if (this.protocol != null) {
                                this.protocol.logout();
                            }
                            break block19;
                        }
                        if (!expunge && this.mode == 2) {
                            try {
                                MailboxInfo mi = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException pex2) {
                                if (this.protocol == null) break block20;
                                this.protocol.disconnect();
                            }
                        }
                    }
                    if (this.protocol != null) {
                        this.protocol.close();
                    }
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
                }
                finally {
                    if (this.opened) {
                        this.cleanup(true);
                    }
                }
            }
        }
    }

    private void cleanup(boolean returnToPool) {
        this.releaseProtocol(returnToPool);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException bex) {
                PSIMAPProtocol p = null;
                try {
                    p = this.getStoreProtocol();
                    Object object = this.lockFor(p);
                    synchronized (object) {
                        try {
                            MailboxInfo minfo = p.examine(this.fullName);
                            p.close();
                            int n = minfo.total;
                            return n;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (ProtocolException pex) {
                                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
                            }
                        }
                    }
                }
                finally {
                    this.releaseStoreProtocol(p);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException bex) {
                PSIMAPProtocol p = null;
                try {
                    p = this.getStoreProtocol();
                    Object object = this.lockFor(p);
                    synchronized (object) {
                        try {
                            MailboxInfo minfo = p.examine(this.fullName);
                            p.close();
                            int n = minfo.recent;
                            return n;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (ProtocolException pex) {
                                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
                            }
                        }
                    }
                }
                finally {
                    this.releaseStoreProtocol(p);
                }
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException bex) {
                return -1;
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this.store, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        Flags f = new Flags();
        f.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search((SearchTerm)new FlagTerm(f, false));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags f = new Flags();
        f.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search((SearchTerm)new FlagTerm(f, true));
                return matches.length;
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int statusCacheTimeout = ((PSIMAPStore)this.store).getStatusCacheTimeout();
        if (statusCacheTimeout > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)statusCacheTimeout) {
            return this.cachedStatus;
        }
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                Status s = p.status(this.fullName, null);
                if (statusCacheTimeout > 0) {
                    this.cachedStatus = s;
                    this.cachedStatusTime = System.currentTimeMillis();
                }
                Status status = s;
                return status;
            }
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        this.checkOpened();
        this.checkRange(msgnum);
        return (Message)this.messageCache.elementAt(msgnum - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessages(Message[] msgs) throws MessagingException {
        this.checkExists();
        int maxsize = ((PSIMAPStore)this.store).getAppendBufferSize();
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            for (int i = 0; i < msgs.length; ++i) {
                MessageLiteral mos;
                Message m = msgs[i];
                try {
                    mos = new MessageLiteral(m, m.getSize() > maxsize ? 0 : maxsize);
                }
                catch (IOException ex) {
                    throw new MessagingException("IOException while appending messages", (Exception)ex);
                }
                catch (MessageRemovedException mrex) {
                    continue;
                }
                Object object = this.messageCacheLock;
                synchronized (object) {
                    Object object2 = this.lockFor(p);
                    synchronized (object2) {
                        Date d = m.getReceivedDate();
                        if (d == null) {
                            d = m.getSentDate();
                        }
                        p.append(this.fullName, m.getFlags(), d, mos);
                    }
                }
            }
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.protocol.copy(PSUtility.toMessageSet(msgs, null), folder.getFullName());
                }
                catch (CommandFailedException cfx) {
                    if (cfx.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(cfx.getMessage(), (Exception)((Object)cfx));
                }
                catch (ConnectionException cex) {
                    throw new FolderClosedException((Folder)this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
                }
            }
        }
        super.copyMessages(msgs, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<PSIMAPMessage> v = new Vector<PSIMAPMessage>();
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.doExpungeNotification = false;
            try {
                this.protocol.expunge();
            }
            catch (CommandFailedException cfx) {
                if (this.mode != 2) {
                    throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                }
                throw new MessagingException(cfx.getMessage(), (Exception)((Object)cfx));
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
            finally {
                this.doExpungeNotification = true;
            }
            int i = 0;
            while (i < this.messageCache.size()) {
                PSIMAPMessage m = (PSIMAPMessage)((Object)this.messageCache.elementAt(i));
                if (m.isExpunged()) {
                    long uid;
                    v.addElement(m);
                    this.messageCache.removeElementAt(i);
                    if (this.uidTable == null || (uid = m.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(uid));
                    continue;
                }
                m.setMessageNumber(m.getSequenceNumber());
                ++i;
            }
        }
        this.total = this.messageCache.size();
        Object[] msgs = new Message[v.size()];
        v.copyInto(msgs);
        if (msgs.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])msgs);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        this.checkOpened();
        try {
            PSIMAPMessage[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(term);
                if (matches != null) {
                    matchMsgs = new PSIMAPMessage[matches.length];
                    for (int i = 0; i < matches.length; ++i) {
                        matchMsgs[i] = this.getMessageBySeqNumber(matches[i]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term);
        }
        catch (SearchException sex) {
            return super.search(term);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        this.checkOpened();
        if (msgs.length == 0) {
            return msgs;
        }
        try {
            PSIMAPMessage[] matchMsgs = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] matches = this.protocol.search(PSUtility.toMessageSet(msgs, null), term);
                if (matches != null) {
                    matchMsgs = new PSIMAPMessage[matches.length];
                    for (int i = 0; i < matches.length; ++i) {
                        matchMsgs[i] = this.getMessageBySeqNumber(matches[i]);
                    }
                }
            }
            return matchMsgs;
        }
        catch (CommandFailedException cfx) {
            return super.search(term, msgs);
        }
        catch (SearchException sex) {
            return super.search(term, msgs);
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        PSIMAPProtocol p = null;
        Status status = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                String[] item = new String[]{"UIDVALIDITY"};
                status = p.status(this.fullName, item);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("Cannot obtain UIDValidity", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return status.uidvalidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        this.checkOpened();
        Long l = new Long(uid);
        PSIMAPMessage m = null;
        if (this.uidTable != null) {
            m = (PSIMAPMessage)((Object)this.uidTable.get(l));
            if (m != null) {
                return m;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID u = this.protocol.fetchSequenceNumber(uid);
                if (u != null) {
                    m = (PSIMAPMessage)((Object)this.messageCache.elementAt(u.msgno - 1));
                    m.setUID(u.uid);
                    this.uidTable.put(l, m);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        Message[] msgs;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] ua = this.protocol.fetchSequenceNumbers(start, end);
                msgs = new Message[ua.length];
                for (int i = 0; i < ua.length; ++i) {
                    PSIMAPMessage m = (PSIMAPMessage)((Object)this.messageCache.elementAt(ua[i].msgno - 1));
                    m.setUID(ua[i].uid);
                    msgs[i] = m;
                    this.uidTable.put(new Long(ua[i].uid), m);
                }
            }
        }
        catch (ConnectionException cex) {
            throw new FolderClosedException((Folder)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        int i;
        Object v;
        this.checkOpened();
        long[] unavailUids = uids;
        if (this.uidTable != null) {
            v = new Vector();
            for (int i2 = 0; i2 < uids.length; ++i2) {
                Long l = new Long(uids[i2]);
                if (this.uidTable.containsKey(l)) continue;
                ((Vector)v).addElement(l);
            }
            int vsize = ((Vector)v).size();
            unavailUids = new long[vsize];
            for (i = 0; i < vsize; ++i) {
                unavailUids[i] = (Long)((Vector)v).elementAt(i);
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (unavailUids.length > 0) {
            try {
                v = this.messageCacheLock;
                synchronized (v) {
                    UID[] ua = this.protocol.fetchSequenceNumbers(unavailUids);
                    for (i = 0; i < ua.length; ++i) {
                        PSIMAPMessage m = (PSIMAPMessage)((Object)this.messageCache.elementAt(ua[i].msgno - 1));
                        m.setUID(ua[i].uid);
                        this.uidTable.put(new Long(ua[i].uid), m);
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        Message[] msgs = new Message[uids.length];
        for (int i3 = 0; i3 < uids.length; ++i3) {
            msgs[i3] = (Message)this.uidTable.get(new Long(uids[i3]));
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        PSIMAPMessage m = (PSIMAPMessage)message;
        long uid = m.getUID();
        if (uid != -1L) {
            return uid;
        }
        UID u = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            m.checkExpunged();
            try {
                u = this.protocol.fetchUID(m.getSequenceNumber());
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
        if (u != null) {
            uid = u.uid;
            m.setUID(uid);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(uid), m);
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quota[] getQuota() throws MessagingException {
        Quota[] qa = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                qa = p.getQuotaRoot(this.fullName);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return qa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(Quota quota) throws MessagingException {
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                p.setQuota(quota);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACL[] getACL() throws MessagingException {
        ACL[] aa = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                aa = p.getACL(this.fullName);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("ACL not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return aa;
    }

    public void addACL(ACL acl) throws MessagingException {
        this.setACL(acl, '\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeACL(String name) throws MessagingException {
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                p.deleteACL(this.fullName, name);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("ACL not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    public void addRights(ACL acl) throws MessagingException {
        this.setACL(acl, '+');
    }

    public void removeRights(ACL acl) throws MessagingException {
        this.setACL(acl, '-');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rights[] listRights(String name) throws MessagingException {
        Rights[] ra = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                ra = p.listRights(this.fullName, name);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("ACL not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rights myRights() throws MessagingException {
        Rights rights = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                rights = p.myRights(this.fullName);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("ACL not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return rights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setACL(ACL acl, char mod) throws MessagingException {
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            Object object = this.lockFor(p);
            synchronized (object) {
                p.setACL(this.fullName, mod, acl);
            }
        }
        catch (BadCommandException bex) {
            throw new MessagingException("ACL not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            this.throwClosedException(p, (Exception)((Object)cex));
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            ((PSIMAPStore)this.store).handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (r.isOK()) {
            return;
        }
        if (!r.isUnTagged()) {
            return;
        }
        if (!(r instanceof IMAPResponse)) {
            System.out.println("UNEXPECTED RESPONSE : " + r.toString());
            System.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse ir = (IMAPResponse)r;
        if (ir.keyEquals("EXISTS")) {
            int exists = ir.getNumber();
            if (exists <= this.realTotal) {
                return;
            }
            int count = exists - this.realTotal;
            Message[] msgs = new Message[count];
            for (int i = 0; i < count; ++i) {
                PSIMAPMessage msg = new PSIMAPMessage(this, ++this.total, ++this.realTotal);
                msgs[i] = msg;
                this.messageCache.addElement(msg);
            }
            this.notifyMessageAddedListeners(msgs);
        } else if (ir.keyEquals("EXPUNGE")) {
            PSIMAPMessage msg = this.getMessageBySeqNumber(ir.getNumber());
            msg.setExpunged(true);
            for (int i = msg.getMessageNumber(); i < this.total; ++i) {
                PSIMAPMessage m = (PSIMAPMessage)((Object)this.messageCache.elementAt(i));
                if (m.isExpunged()) continue;
                m.setSequenceNumber(m.getSequenceNumber() - 1);
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                Message[] msgs = new Message[]{msg};
                this.notifyMessageRemovedListeners(false, msgs);
            }
        } else if (ir.keyEquals("FETCH")) {
            FetchResponse f = (FetchResponse)ir;
            Flags flags = (Flags)f.getItem(class$javax$mail$Flags == null ? (class$javax$mail$Flags = PSIMAPFolder.class$("javax.mail.Flags")) : class$javax$mail$Flags);
            if (flags != null) {
                PSIMAPMessage msg = this.getMessageBySeqNumber(f.getNumber());
                msg._setFlags(flags);
                this.notifyMessageChangedListeners(1, (Message)msg);
            }
        } else if (ir.keyEquals("RECENT")) {
            this.recent = ir.getNumber();
        }
    }

    void handleResponses(Response[] r) {
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null) continue;
            this.handleResponse(r[i]);
        }
    }

    protected synchronized PSIMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.opened && !((PSIMAPStore)this.store).hasSeparateStoreConnection()) {
            if (this.connectionPoolDebug) {
                System.out.println("DEBUG: getStoreProtocol() - using our own connection");
            }
            return this.protocol;
        }
        if (this.connectionPoolDebug) {
            System.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((PSIMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(PSIMAPProtocol p, Exception ex) throws FolderClosedException, StoreClosedException {
        if (p == this.protocol) {
            throw new FolderClosedException((Folder)this, ex.getMessage());
        }
        throw new StoreClosedException(this.store, ex.getMessage());
    }

    public PSIMAPProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doCommand(ProtocolCommand cmd) throws MessagingException {
        if (!this.opened) {
            PSIMAPProtocol p = null;
            try {
                p = this.getStoreProtocol();
                Object object = this.lockFor(p);
                synchronized (object) {
                    try {
                        Object object2 = cmd.doCommand(p);
                        return object2;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (ConnectionException cex) {
                            throw new StoreClosedException(this.store, cex.getMessage());
                        }
                        catch (ProtocolException pex) {
                            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
                        }
                    }
                }
            }
            finally {
                this.releaseStoreProtocol(p);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                return cmd.doCommand(this.getProtocol());
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException((Folder)this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }

    protected synchronized Object lockFor(PSIMAPProtocol p) {
        if (p == this.protocol) {
            return this.messageCacheLock;
        }
        return new Object();
    }

    protected synchronized void releaseStoreProtocol(PSIMAPProtocol p) {
        if (p != this.protocol) {
            ((PSIMAPStore)this.store).releaseStoreProtocol(p);
        }
    }

    private synchronized void releaseProtocol(boolean returnToPool) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (returnToPool) {
                ((PSIMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((PSIMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean keepStoreAlive) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (keepStoreAlive && ((PSIMAPStore)this.store).hasSeparateStoreConnection()) {
            PSIMAPProtocol p = null;
            try {
                p = ((PSIMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - p.getTimestamp() > 1000L) {
                    p.noop();
                }
            }
            finally {
                ((PSIMAPStore)this.store).releaseStoreProtocol(p);
            }
        }
    }

    PSIMAPMessage getMessageBySeqNumber(int seqnum) {
        for (int i = seqnum - 1; i < this.total; ++i) {
            PSIMAPMessage msg = (PSIMAPMessage)((Object)this.messageCache.elementAt(i));
            if (msg.getSequenceNumber() != seqnum) continue;
            return msg;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ProtocolCommand {
        public Object doCommand(PSIMAPProtocol var1) throws ProtocolException;
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String name) {
            super(name);
        }
    }
}

