/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.soif;

import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFException;
import com.sun.portal.search.soif.SOIFInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SOIF
extends HashMap {
    private String schemaName;
    private String URL;
    String encoding = defaultEncoding;
    public static String defaultEncoding = "UTF-8";
    static final int ENC_UTF8 = 0;
    static final int ENC_UTF16 = 1;
    static final int ENC_8BIT = 2;
    static final int ENC_DEFAULT = 0;
    public static String INVALIDSOIF = "invalid soif";

    public SOIF() {
        this.schemaName = "-";
        this.URL = "-";
    }

    public SOIF(String string, String string2) {
        this();
        if (string != null) {
            this.schemaName = string;
        }
        if (string2 != null) {
            this.URL = string2;
        }
    }

    public SOIF(byte[] byArray, String string, Set set) throws IOException {
        try {
            SOIFInputStream sOIFInputStream = new SOIFInputStream(byArray, string);
            sOIFInputStream.setAllowed(set);
            SOIF sOIF = sOIFInputStream.readSOIF();
            if (sOIF == null) {
                throw new SOIFException("failed to parse");
            }
            this.schemaName = sOIF.schemaName;
            this.URL = sOIF.URL;
            this.putAll(sOIF);
        }
        catch (IOException iOException) {
            throw new SOIFException("failed to parse");
        }
    }

    public SOIF(byte[] byArray, String string) throws IOException {
        this(byArray, string, null);
    }

    public SOIF(byte[] byArray, Set set) throws IOException {
        this(byArray, defaultEncoding, set);
    }

    public SOIF(byte[] byArray) throws IOException {
        this(byArray, defaultEncoding);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getValue(String string) {
        return this.getValue(string, 0);
    }

    public byte[] getBytes(String string) {
        return this.getBytes(string, 0);
    }

    public String getValue(String string, int n) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair != null) {
            return aVPair.getValue(n);
        }
        return null;
    }

    public byte[] getBytes(String string, int n) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair != null) {
            return aVPair.getBytes(n);
        }
        return null;
    }

    public AVPair getAVPair(String string) {
        return (AVPair)this.get(string);
    }

    public boolean contains(String string) {
        return this.get(string) != null;
    }

    public boolean insert(String string, String string2) {
        return this.insert(string, string2, 0);
    }

    public boolean insert(String string, byte[] byArray) {
        return this.insert(string, byArray, 0);
    }

    public boolean insert(String string, String string2, int n) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair != null) {
            return aVPair.insert(string2, n);
        }
        this.put(string, new AVPair(string, string2, n));
        return true;
    }

    public boolean insert(String string, byte[] byArray, int n) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair != null) {
            return aVPair.insert(byArray, n);
        }
        this.put(string, new AVPair(string, byArray, n, this.encoding));
        return true;
    }

    public boolean insert(AVPair aVPair) {
        AVPair aVPair2 = (AVPair)this.get(aVPair.getAttribute());
        if (aVPair2 != null) {
            return false;
        }
        this.put(aVPair.getAttribute(), aVPair);
        return true;
    }

    public void replace(String string, String string2) {
        this.remove(string);
        this.insert(string, string2);
    }

    public void replace(String string, String string2, int n) {
        this.remove(string, n);
        this.insert(string, string2, n);
    }

    public void replace(AVPair aVPair) {
        this.remove(aVPair.getAttribute());
        this.put(aVPair.getAttribute(), aVPair);
    }

    public boolean remove(String string) {
        return this.remove((Object)string) != null;
    }

    public boolean remove(String string, int n) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair != null) {
            return aVPair.remove(n);
        }
        return false;
    }

    public boolean rename(String string, String string2) {
        AVPair aVPair = (AVPair)this.get(string);
        if (aVPair == null) {
            return false;
        }
        this.remove(string);
        aVPair.setAttribute(string2);
        this.put(string2, aVPair);
        return true;
    }

    public void merge(SOIF sOIF) {
        this.putAll(sOIF);
    }

    public void merge(SOIF sOIF, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                AVPair aVPair = (AVPair)sOIF.get(stringArray[i]);
                if (aVPair == null) continue;
                this.put(stringArray[i], aVPair);
            }
        } else {
            this.merge(sOIF);
        }
    }

    public void absorb(SOIF sOIF) {
        Iterator iterator = sOIF.values().iterator();
        while (iterator.hasNext()) {
            AVPair aVPair = (AVPair)iterator.next();
            this.insert(aVPair);
        }
    }

    public void absorb(SOIF sOIF, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            AVPair aVPair = sOIF.getAVPair(stringArray[i]);
            this.insert(aVPair);
        }
    }

    public void squeezeMV() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            AVPair aVPair = (AVPair)iterator.next();
            aVPair.squeeze();
        }
    }

    public Set getAttributes() {
        return this.keySet();
    }

    public String[] getAttributesArray() {
        String[] stringArray = new String[this.size()];
        this.keySet().toArray(stringArray);
        return stringArray;
    }

    public int getAttributeCount() {
        return this.size();
    }

    public int contentSize() {
        int n = 0;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            AVPair aVPair = (AVPair)iterator.next();
            n += aVPair.contentSize();
        }
        return n;
    }

    public Object put(Object object, Object object2) {
        String string = (String)object;
        AVPair aVPair = (AVPair)object2;
        return super.put(string.toLowerCase(), aVPair);
    }

    public Object get(Object object) {
        String string = (String)object;
        return super.get(string.toLowerCase());
    }

    public Object remove(Object object) {
        String string = (String)object;
        return super.remove(string.toLowerCase());
    }

    public boolean containsKey(Object object) {
        String string = (String)object;
        return super.containsKey(string.toLowerCase());
    }

    public byte[] toByteArray() throws IOException {
        return this.toByteArray(this.encoding);
    }

    public byte[] toByteArray(Set set) throws IOException {
        return this.toByteArray(this.encoding, set);
    }

    public byte[] toByteArray(String string) throws IOException {
        return this.toByteArray(string, null);
    }

    private byte[] toByteArrayOld(String string, Set set) throws IOException {
        try {
            SOIFBuffer sOIFBuffer = new SOIFBuffer(4000);
            DataOutputStream dataOutputStream = new DataOutputStream(sOIFBuffer);
            dataOutputStream.write(64);
            dataOutputStream.write(this.schemaName.getBytes(string));
            dataOutputStream.writeBytes(" { ");
            dataOutputStream.write(this.URL.getBytes(string));
            dataOutputStream.write(10);
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                AVPair aVPair = (AVPair)iterator.next();
                String string2 = aVPair.getAttribute();
                if (set != null && !set.contains(string2)) continue;
                int n = aVPair.getMaxIndex();
                for (int i = 0; i < n + 1; ++i) {
                    byte[] byArray = aVPair.getBytes(i);
                    if (byArray == null) continue;
                    dataOutputStream.write(string2.getBytes(string));
                    if (i > 0 || n > 0) {
                        dataOutputStream.write(45);
                        dataOutputStream.writeBytes(String.valueOf(i + 1));
                    }
                    dataOutputStream.writeBytes("{" + byArray.length + "}:\t");
                    dataOutputStream.write(byArray);
                    dataOutputStream.write(10);
                }
            }
            dataOutputStream.writeBytes("}\n\n");
            return sOIFBuffer.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] toByteArray(String string, Set set) throws IOException {
        try {
            boolean bl;
            SOIFBuffer sOIFBuffer = new SOIFBuffer(4000);
            DataOutputStream dataOutputStream = new DataOutputStream(sOIFBuffer);
            boolean bl2 = bl = !string.equalsIgnoreCase(this.encoding);
            if (string.equalsIgnoreCase("UTF-16")) {
                string = "UTF-16BE";
            }
            dataOutputStream.write(("@" + this.schemaName + " { " + this.URL + "\n").getBytes(string));
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                AVPair aVPair = (AVPair)iterator.next();
                String string2 = aVPair.getAttribute();
                StringBuffer stringBuffer = new StringBuffer(500);
                if (set != null && !set.contains(string2.toLowerCase())) continue;
                int n = aVPair.getMaxIndex();
                for (int i = 0; i < n + 1; ++i) {
                    String string3 = null;
                    byte[] byArray = null;
                    byArray = bl && (string3 = aVPair.getValue(i)) != null ? string3.getBytes(string) : aVPair.getBytes(i);
                    if (byArray == null) continue;
                    stringBuffer.setLength(0);
                    stringBuffer.append(string2);
                    if (i > 0 || n > 0) {
                        stringBuffer.append("-");
                        stringBuffer.append(String.valueOf(i + 1));
                    }
                    stringBuffer.append("{");
                    stringBuffer.append(String.valueOf(byArray.length));
                    stringBuffer.append("}:\t");
                    dataOutputStream.write(stringBuffer.toString().getBytes(string));
                    dataOutputStream.write(byArray);
                    stringBuffer.setLength(0);
                    dataOutputStream.write("\n".getBytes(string));
                }
            }
            dataOutputStream.write("}\n\n".getBytes(string));
            return sOIFBuffer.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SOIF @" + this.schemaName + " { " + this.URL + "\n");
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            AVPair aVPair = (AVPair)iterator.next();
            int n = aVPair.getMaxIndex();
            for (int i = 0; i < n + 1; ++i) {
                String string = aVPair.getValue(i);
                if (string == null) continue;
                stringBuffer.append(aVPair.getAttribute());
                if (i > 0 || n > 0) {
                    stringBuffer.append("-");
                    stringBuffer.append(i + 1);
                }
                stringBuffer.append("{" + string.length() + "}:\t" + string + "\n");
            }
        }
        stringBuffer.append("}\n\n");
        return stringBuffer.toString();
    }
}

