/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdmserver.RDMConfig;
import com.sun.portal.search.rdmserver.RDMContext;
import com.sun.portal.search.rdmserver.RDMService;
import com.sun.portal.search.rdmserver.RDMServiceDescriptor;
import com.sun.portal.search.rdmserver.UnsupportedService;
import com.sun.portal.search.util.CSLog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;

public class RDMServer {
    static RDMServer rdmsvr;
    RDMConfig rdmconfig;
    RDMContext rdmcontext;
    Map RDMServices = new HashMap();
    List RDMServiceClasses = new ArrayList();
    RDMService unsupportedService = new UnsupportedService();
    static Map rdm_logmsg_typestr;
    static DateFormat df;

    public RDMServer(RDMContext rDMContext) {
        rdmsvr = this;
        this.rdmcontext = rDMContext;
        this.RegisterRDMService("com.sun.portal.search.rdmserver.DatabaseService");
        this.RegisterRDMService("com.sun.portal.search.rdmserver.TaxonomyService");
        this.RegisterRDMService("com.sun.portal.search.rdmserver.SchemaService");
        this.RegisterRDMService("com.sun.portal.search.rdmserver.ServerDescriptionService");
        this.RegisterRDMService("com.sun.portal.search.rdmserver.ServerStatusService");
    }

    RDMContext getRDMContext() {
        return this.rdmcontext;
    }

    public void RegisterRDMService(String string) {
        RDMService rDMService = null;
        RDMServiceDescriptor rDMServiceDescriptor = null;
        try {
            rDMService = (RDMService)Class.forName(string).newInstance();
            this.RDMServiceClasses.add(rDMService);
            Set set = rDMService.getSupportedServices();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                rDMServiceDescriptor = (RDMServiceDescriptor)iterator.next();
                this.RDMServices.put(rDMServiceDescriptor, rDMService);
                CSLog.log(1, 2, "Loaded RDM service: " + rDMServiceDescriptor.getRDMType() + "/" + rDMServiceDescriptor.getQueryLanguage() + "/" + string);
            }
        }
        catch (Exception exception) {
            if (rDMServiceDescriptor == null) {
                CSLog.error(1, 1, "Error when loading service: " + string, exception);
            }
            CSLog.error(1, 1, "Error when loading service: " + rDMServiceDescriptor.getRDMType() + ", " + rDMServiceDescriptor.getQueryLanguage() + ", " + string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        try {
            RDMServiceDescriptor rDMServiceDescriptor;
            RDMService rDMService;
            rDMRequest.setRDMServer(this);
            this.normalizeRequest(rDMRequest, rDMResponse);
            String string = rDMRequest.getHeader().getCSID();
            if (string != null) {
                rDMResponse.getHeader().setCSID(string);
            }
            if ((rDMService = (RDMService)this.RDMServices.get(rDMServiceDescriptor = new RDMServiceDescriptor(rDMRequest.getHeader().getType(), rDMRequest.getHeader().getQueryLanguage()))) == null) {
                rDMService = this.unsupportedService;
            }
            rDMService.service(rDMRequest, rDMResponse);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Exception: rdm-service: ", exception);
            String string = "Internal Error";
            if (exception.getMessage() != null) {
                string = string + ": " + exception.getMessage();
            }
            rDMResponse.getHeader().setErrorMessage(string);
        }
        finally {
            rDMResponse.sendHeader();
        }
    }

    void normalizeRequest(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        String string;
        RDMHeader rDMHeader = rDMRequest.getHeader();
        String string2 = rDMHeader.getType();
        if (string2 == null || string2.length() == 0) {
            string2 = "-";
        }
        rDMHeader.setType(string2.toLowerCase());
        if (string2.equalsIgnoreCase("server-request")) {
            string2 = "server-description-request";
            rDMHeader.setType(string2);
        } else if (string2.equalsIgnoreCase("server-response")) {
            string2 = "server-description-response";
            rDMHeader.setType(string2);
        } else if (string2.equalsIgnoreCase("schema-request")) {
            string2 = "schema-description-request";
            rDMHeader.setType(string2);
        } else if (string2.equalsIgnoreCase("schema-response")) {
            string2 = "schema-description-response";
            rDMHeader.setType(string2);
        } else if (string2.equalsIgnoreCase("taxonomy-request")) {
            string2 = "taxonomy-description-request";
            rDMHeader.setType(string2);
        } else if (string2.equalsIgnoreCase("taxonomy-response")) {
            string2 = "taxonomy-description-response";
            rDMHeader.setType(string2);
        }
        String string3 = rDMHeader.getQueryLanguage();
        if (string3 != null && string3.length() == 0) {
            rDMHeader.getSOIF().remove("rdm-query-language");
        }
        if ((string = rDMHeader.getCSID()) != null && string.length() > 0 && !this.rdmconfig.searchcf.getDefault().equalsIgnoreCase(string)) {
            throw new Exception("Unsupported CSID.");
        }
    }

    public void init(RDMConfig rDMConfig) throws Exception {
        if (this.rdmconfig != null) {
            CSLog.warn(1, 1, "RDMServer.init() - already initialized");
            return;
        }
        this.rdmconfig = rDMConfig;
    }

    public void shutdown() throws Exception {
        try {
            Iterator iterator = this.RDMServiceClasses.iterator();
            while (iterator.hasNext()) {
                RDMService rDMService = (RDMService)iterator.next();
                rDMService.shutdown();
            }
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "RDMServer.shutdown()", exception);
        }
    }

    public static String getRDMTypeLogMsg(String string) {
        String string2 = (String)rdm_logmsg_typestr.get(string);
        if (string2 == null) {
            string2 = (String)rdm_logmsg_typestr.get("unknown");
        }
        return string2;
    }

    public String getVersion() {
        try {
            ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("PSversion");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(resourceBundle.getString("productname")).append(" RDM Server ").append(resourceBundle.getString("productversion"));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Sun ONE RDM Server Version 6.0";
        }
    }

    public void logRDM(RDMRequest rDMRequest, String string) {
        if (this.rdmconfig.do_rdm_log) {
            String string2 = rDMRequest.getHeader().getType();
            String string3 = rDMRequest.getHeader().getQueryLanguage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append(df.format(new Date()));
            stringBuffer.append("]");
            stringBuffer.append(" RDM=" + RDMServer.getRDMTypeLogMsg(string2) + " ql=" + (string3 != null ? string3 : "-") + " " + string);
            this.rdmcontext.logrdm(stringBuffer.toString());
        }
    }

    static {
        rdm_logmsg_typestr = new HashMap();
        rdm_logmsg_typestr.put("rd-request", "rd");
        rdm_logmsg_typestr.put("rd-delete-request", "rd-delete");
        rdm_logmsg_typestr.put("rd-response", "rd-response");
        rdm_logmsg_typestr.put("rd-delete-response", "rd-delete-response");
        rdm_logmsg_typestr.put("rd-submit-request", "rd-submit");
        rdm_logmsg_typestr.put("rd-submit-response", "rd-submit-response");
        rdm_logmsg_typestr.put("server-description-request", "server");
        rdm_logmsg_typestr.put("server-description-response", "server-response");
        rdm_logmsg_typestr.put("schema-description-request", "schema");
        rdm_logmsg_typestr.put("schema-description-response", "schema-response");
        rdm_logmsg_typestr.put("taxonomy-description-request", "tax");
        rdm_logmsg_typestr.put("taxonomy-description-response", "taxonomy-response");
        rdm_logmsg_typestr.put("status-request", "status");
        rdm_logmsg_typestr.put("status-response", "status-response");
        rdm_logmsg_typestr.put("unknown", "unknown");
        df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
    }
}

