/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.RDMResultSet;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.rdm.RDMView;
import com.sun.portal.search.rdmgr.RDSubmit;
import com.sun.portal.search.rdmgr.RDSubmitRequest;
import com.sun.portal.search.rdmserver.DbAccess;
import com.sun.portal.search.rdmserver.RDMService;
import com.sun.portal.search.rdmserver.RDMServiceDescriptor;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.Encoder;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.String2Array;

public class DatabaseService
extends RDMService {
    static final int MAX_RD_BATCH = 65520;
    DbAccess dbaccess;
    int curDbConnections;
    int maxDbConnections = 6;
    int indexBatchSize = 65520;
    RDSubmit rdsubmit = null;
    public static final String QL_URL = "url";
    public static final String QL_SEARCH = "search";
    public static final String QL_GATHERER = "gatherer";
    public static final String QL_SUBTREE = "subtree";
    public static final String QL_LEGACY_COMPASS = "compass";
    public static final String QL_LEGACY_NSIR = "nsir";
    public static final String QL_LEGACY_VERITY = "verity";
    public static final String QL_LEGACY_VERITY_QL = "verity-ql";

    public DatabaseService() {
        int n;
        String string = SearchConfig.getValue("database-max-concurrent");
        if (string != null && (n = Integer.parseInt(string)) > 0) {
            this.maxDbConnections = n;
        }
        if ((string = SearchConfig.getValue("search-max-index-batch")) != null) {
            this.indexBatchSize = Integer.parseInt(string);
        }
        if (this.indexBatchSize < 1 || this.indexBatchSize > 65520) {
            CSLog.warn(1, 1, "Resetting search-max-index-batch to 65520");
            this.indexBatchSize = 65520;
        }
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", null));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_SEARCH));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_GATHERER));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_URL));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_SUBTREE));
        this.supportedServices.add(new RDMServiceDescriptor("rd-submit-request", null));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_LEGACY_COMPASS));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_LEGACY_NSIR));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_LEGACY_VERITY));
        this.supportedServices.add(new RDMServiceDescriptor("rd-request", QL_LEGACY_VERITY_QL));
        this.dbaccess = DbAccess.getInstance();
    }

    public void service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        this.normalizeRequest(rDMRequest);
        String string = rDMRequest.getHeader().getType();
        if (string.equalsIgnoreCase("rd-request")) {
            rDMResponse.getHeader().setType("rd-response");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            if (rDMRequest.getQuery() == null) {
                rDMResponse.getHeader().setErrorMessage("Bad or missing query");
                return;
            }
            String string2 = rDMRequest.getHeader().getQueryLanguage();
            if (string2 == null) {
                rDMResponse.getHeader().setErrorMessage("Bad or missing query language");
                return;
            }
            if (string2.equalsIgnoreCase(QL_SEARCH)) {
                this.ql_search_service(rDMRequest, rDMResponse);
            } else if (string2.equalsIgnoreCase(QL_URL)) {
                this.ql_url_service(rDMRequest, rDMResponse);
            } else if (string2.equalsIgnoreCase(QL_GATHERER)) {
                this.ql_gatherer_service(rDMRequest, rDMResponse);
            } else if (string2.equalsIgnoreCase(QL_SUBTREE)) {
                this.ql_subtree_service(rDMRequest, rDMResponse);
            } else if (string2.equalsIgnoreCase(QL_LEGACY_NSIR) || string2.equalsIgnoreCase(QL_LEGACY_COMPASS) || string2.equalsIgnoreCase(QL_LEGACY_VERITY) || string2.equalsIgnoreCase(QL_LEGACY_VERITY_QL)) {
                rDMRequest.getHeader().setQueryLanguage(QL_SEARCH);
                this.ql_search_service(rDMRequest, rDMResponse);
            }
        } else if (string.equalsIgnoreCase("rd-submit-request")) {
            rDMResponse.getHeader().setType("rd-submit-response");
            this.rdsubmit_service(rDMRequest, rDMResponse);
        } else {
            rDMResponse.getHeader().setErrorMessage("Bad or missing request type");
            return;
        }
    }

    public void shutdown() throws Exception {
        this.dbaccess.shutdown(null);
    }

    public void normalizeRequest(RDMRequest rDMRequest) {
        RDMQuery rDMQuery = rDMRequest.getQuery();
        if (rDMQuery != null && rDMQuery.getDatabase() == null) {
            rDMQuery.setDatabase(SearchConfig.getValue("database-name"));
        }
    }

    public void ql_url_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        QLURLQuery qLURLQuery = new QLURLQuery();
        String string = rDMRequest.getQuery().getScope();
        if (string == null || string.length() == 0 || !this.URLScopeParse(string, qLURLQuery)) {
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        this.getURLResults(rDMRequest, rDMResponse, qLURLQuery);
    }

    public void ql_gatherer_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        QLSearchQuery qLSearchQuery = new QLSearchQuery();
        String string = rDMRequest.getQuery().getScope();
        if (string == null || string.length() == 0 || !this.gathererScopeParse(string, qLSearchQuery)) {
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        if (rDMRequest.getQuery().getViewHits() == null) {
            rDMRequest.getQuery().setViewHits("1..-1");
        }
        this.getSearchResults(rDMRequest, rDMResponse, qLSearchQuery);
    }

    public void ql_search_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        String[] stringArray;
        String string;
        String string2;
        QLSearchQuery qLSearchQuery = new QLSearchQuery();
        String string3 = rDMRequest.getQuery().getScope();
        if (string3 == null || string3.length() == 0 || !this.searchScopeParse(string3, qLSearchQuery)) {
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        String string4 = rDMRequest.getQuery().getSearchCategory();
        if (string4 != null && string4.length() > 0 && !string4.equalsIgnoreCase("ROOT")) {
            qLSearchQuery.newScope = "(classification <STARTS> " + string4 + ") <AND> (" + qLSearchQuery.scope + ")";
        }
        if ((string2 = rDMRequest.getQuery().getHighlight()) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("1"))) {
            qLSearchQuery.highlight = true;
        }
        if ((string = rDMRequest.getQuery().getHighlightTags()) != null && (stringArray = String2Array.string2Array(string, ',')) != null && (stringArray.length == 6 || stringArray.length == 12)) {
            qLSearchQuery.highlightTags = stringArray;
        }
        this.getSearchResults(rDMRequest, rDMResponse, qLSearchQuery);
    }

    public void ql_subtree_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        QLSearchQuery qLSearchQuery = new QLSearchQuery();
        String string = rDMRequest.getQuery().getScope();
        if (string == null || string.length() == 0 || !this.subtreeScopeParse(string, qLSearchQuery)) {
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        this.getSearchResults(rDMRequest, rDMResponse, qLSearchQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rdsubmit_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        String string;
        int n;
        block6: {
            Object var3_3 = null;
            RDMDb rDMDb = null;
            SToken sToken = rDMRequest.getSToken();
            n = 0;
            string = rDMRequest.getHeader().getSOIF().getValue("submit-database");
            if (string == null) {
                string = SearchConfig.getValue("database-name");
            }
            try {
                try {
                    rDMDb = this.dbaccess.writeStart(sToken, string);
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "Cannot access database.", exception);
                    throw new Exception("Cannot access database.");
                }
                rDMResponse.sendHeader();
                RDSubmitRequest rDSubmitRequest = new RDSubmitRequest();
                rDSubmitRequest.sis = rDMRequest.getInputStream();
                rDSubmitRequest.sos = rDMResponse.getOutputStream();
                rDSubmitRequest.db = rDMDb;
                rDSubmitRequest.max_rd_batch = this.indexBatchSize;
                n = new RDSubmit().process_input(sToken, rDSubmitRequest, rDMRequest.getTransaction());
                rDMResponse.getHeader().setResponseInterpret(n + " results");
                Object var10_10 = null;
                if (rDMDb == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (rDMDb != null) {
                    this.dbaccess.writeFinish(sToken, rDMDb);
                }
                throw throwable;
            }
            this.dbaccess.writeFinish(sToken, rDMDb);
        }
        rDMRequest.logRDM("db=" + string + " processed=" + n);
    }

    protected boolean subtreeScopeParse(String string, QLSearchQuery qLSearchQuery) {
        String string2;
        if (!string.regionMatches(true, 0, "descendant", 0, 10)) {
            return false;
        }
        int n = string.indexOf(10);
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(10, n).trim();
        if (string3.length() == 0) {
            return false;
        }
        qLSearchQuery.newScope = (string2 = string.substring(++n).trim()).length() == 0 ? "(classification <STARTS> " + Encoder.quotedEscape(string3, true) + ")" : (string3.equalsIgnoreCase("ROOT") ? string2 : "(classification <STARTS> " + Encoder.quotedEscape(string3, true) + ") <AND> (" + string2 + ")");
        return true;
    }

    protected boolean URLScopeParse(String string, QLURLQuery qLURLQuery) {
        if (string != null) {
            qLURLQuery.url = string;
            return true;
        }
        return false;
    }

    protected boolean gathererScopeParse(String string, QLSearchQuery qLSearchQuery) {
        qLSearchQuery.scope = string;
        if (string.equalsIgnoreCase("all")) {
            qLSearchQuery.newScope = "*";
            return true;
        }
        if (string.regionMatches(true, 0, "since", 0, 5)) {
            qLSearchQuery.newScope = "rd-last-modified > \"" + string.substring(5) + "\"";
            return true;
        }
        return false;
    }

    protected boolean searchScopeParse(String string, QLSearchQuery qLSearchQuery) {
        if (string != null) {
            qLSearchQuery.scope = string;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getURLResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLURLQuery qLURLQuery) throws Exception {
        int n;
        block9: {
            RDMView rDMView = new RDMView(rDMRequest);
            RDMDb rDMDb = null;
            SToken sToken = rDMRequest.getSToken();
            n = 0;
            try {
                try {
                    try {
                        rDMDb = this.dbaccess.readStart(sToken, rDMRequest.getQuery().getDatabase());
                    }
                    catch (Exception exception) {
                        CSLog.error(1, 1, "Cannot access database.", exception);
                        throw new Exception("Cannot access database.");
                    }
                    SOIF sOIF = rDMDb.fetch(sToken, qLURLQuery.url, rDMView.attr, 0, null);
                    if (sOIF != null) {
                        n = 1;
                    }
                    rDMResponse.getHeader().setResponseInterpret(n + " results");
                    rDMResponse.sendHeader();
                    if (sOIF != null) {
                        rDMResponse.getOutputStream().write(sOIF);
                    }
                }
                catch (Exception exception) {
                    rDMResponse.getHeader().setResponseInterpret("0 results");
                    throw exception;
                }
                Object var10_11 = null;
                if (rDMDb == null) break block9;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (rDMDb != null) {
                    this.dbaccess.readFinish(sToken, rDMDb);
                }
                throw throwable;
            }
            this.dbaccess.readFinish(sToken, rDMDb);
        }
        rDMRequest.logRDM("db=" + rDMRequest.getQuery().getDatabase() + " hits=" + n + " url=\"" + qLURLQuery.url + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getSearchResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLSearchQuery qLSearchQuery) throws Exception {
        int n;
        long l;
        long l2;
        block7: {
            RDMDb rDMDb = null;
            l2 = 0L;
            l = 0L;
            n = 0;
            SToken sToken = rDMRequest.getSToken();
            RDMTransaction rDMTransaction = rDMRequest.getTransaction();
            try {
                try {
                    rDMDb = this.dbaccess.readStart(sToken, rDMRequest.getQuery().getDatabase());
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "Cannot access database.", exception);
                    throw new Exception("Cannot access database.");
                }
                boolean bl = false;
                String string = qLSearchQuery.newScope;
                if (string == null) {
                    string = qLSearchQuery.scope;
                }
                RDMView rDMView = new RDMView(rDMRequest);
                RDMResultSet rDMResultSet = rDMDb.search(sToken, string, rDMView.hits.max, rDMView.attr, rDMView.order, rDMTransaction);
                l = rDMResultSet.getDocCount();
                l2 = rDMResultSet.getHitCount();
                int n2 = (int)Math.min(l2, Integer.MAX_VALUE);
                int n3 = rDMView.hits.min == 0 ? 0 : Math.min(rDMView.hits.min - 1, n2);
                int n4 = Math.min(rDMView.hits.max, n2);
                int n5 = n4 - n3;
                rDMResponse.getHeader().setResponseInterpret(n5 + " results out of " + l2 + " hits across " + l + " documents");
                rDMResponse.sendHeader();
                for (int i = n3; i < n4; ++n, ++i) {
                    SOIF sOIF = rDMResultSet.getResult(i, rDMView.attr, qLSearchQuery.highlightTags);
                    rDMResponse.getOutputStream().write(sOIF);
                }
                Object var23_21 = null;
                if (rDMDb == null) break block7;
            }
            catch (Throwable throwable) {
                Object var23_22 = null;
                if (rDMDb != null) {
                    this.dbaccess.readFinish(sToken, rDMDb);
                }
                throw throwable;
            }
            this.dbaccess.readFinish(sToken, rDMDb);
        }
        rDMRequest.logRDM("db=" + rDMRequest.getQuery().getDatabase() + " hits=" + n + "/" + l2 + "/" + l + " scope=\"" + Encoder.quotedEscape(qLSearchQuery.scope != null ? qLSearchQuery.scope : qLSearchQuery.newScope) + "\"");
    }

    class QLSearchQuery {
        String scope;
        String newScope;
        boolean highlight;
        String[] highlightTags;
        String searchCategory;

        QLSearchQuery() {
        }
    }

    class QLURLQuery {
        String url;

        QLURLQuery() {
        }
    }
}

