/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmgr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;
import sun.misc.BASE64Decoder;

public class PIPMigrate {
    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        Object object;
        Object object2;
        String string3 = "tmp/PKMigrate.ldif";
        if (stringArray.length != 1 && stringArray.length != 6) {
            PIPMigrate.Usage();
            System.exit(1);
        }
        string3 = stringArray[0];
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader("config/sie.conf"));
        }
        catch (Exception exception) {
            System.out.println("Error to open config/sie.conf: " + exception);
            System.out.println("Make sure to run in the server directory where Compass PK installed.");
            return;
        }
        BufferedReader bufferedReader2 = null;
        try {
            bufferedReader2 = new BufferedReader(new FileReader("../userdb/dbswitch.conf"));
        }
        catch (Exception exception) {
            System.out.println("Error to open ../userdb/dbswitch.conf: " + exception);
            System.out.println("Make sure to run in the server directory where Compass PK installed.");
            return;
        }
        String string4 = null;
        String string5 = null;
        int n = -1;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = bufferedReader.readLine();
        try {
            while (string9 != null) {
                if ((string9 = string9.trim()).startsWith("ServerEntry=")) {
                    string4 = string9.substring(12);
                    break;
                }
                string9 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (string4 == null) {
                throw new Exception("No ServerEntry Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to read config/sie.conf: " + exception);
            return;
        }
        boolean bl = false;
        string9 = bufferedReader2.readLine();
        try {
            while (string9 != null) {
                if ((string9 = string9.trim()).startsWith("default:binddn ")) {
                    string7 = string9.substring(15);
                } else if (string9.startsWith("default:encoded bindpw ")) {
                    string8 = string9.substring(23);
                    object2 = new BASE64Decoder();
                    string8 = new String(object2.decodeBuffer(string8));
                } else if (string9.startsWith("directory default ")) {
                    string9 = string9.substring(18);
                    try {
                        object2 = new LDAPUrl(string9);
                        string5 = object2.getHost();
                        n = object2.getPort();
                        string6 = object2.getDN();
                    }
                    catch (Exception exception) {
                        string5 = "";
                        string7 = "";
                        string8 = "";
                        n = 0;
                        bl = true;
                    }
                }
                string9 = bufferedReader2.readLine();
            }
            bufferedReader2.close();
            if (string8 == null) {
                throw new Exception("No 'default:encoded bindpw' Found");
            }
            if (string7 == null) {
                throw new Exception("No 'default:binddn' Found");
            }
            if (string5 == null || n == -1) {
                throw new Exception("No 'directory default' Found");
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to read ../userdb/dbswitch.conf: " + exception);
            return;
        }
        if (bl) {
            System.out.println("ldapdb, expecting input file: ../userdb/301b.ldif");
        } else {
            System.out.println(string7 + ":" + string8 + "@" + string5 + ":" + n + "-" + string6);
        }
        System.out.println(string4);
        object2 = null;
        try {
            object2 = new PrintWriter(new BufferedWriter(new FileWriter(string3)));
        }
        catch (Exception exception) {
            System.err.println("Error to open output " + string3 + ": " + exception);
            return;
        }
        LDAPConnection lDAPConnection = null;
        String string10 = "";
        if (stringArray.length == 6) {
            try {
                lDAPConnection = new LDAPConnection();
                object = stringArray[1];
                int n2 = Integer.parseInt(stringArray[2]);
                string2 = stringArray[3];
                string = stringArray[4];
                string10 = stringArray[5];
                lDAPConnection.connect((String)object, n2);
                lDAPConnection.authenticate(string2, string);
            }
            catch (LDAPException lDAPException) {
                System.out.println("Error for new ldap: " + lDAPException.toString());
                return;
            }
        }
        if (bl) {
            try {
                object = new LDIF("../userdb/301b.ldif");
                LDIFRecord lDIFRecord = object.nextRecord();
                while (lDIFRecord != null) {
                    int n3 = lDIFRecord.getContent().getType();
                    if (n3 != 0) continue;
                    string = (LDIFAttributeContent)lDIFRecord.getContent();
                    String string11 = lDIFRecord.getDN();
                    if (string11.length() > string4.length() && string11.endsWith(string4) && string11.startsWith("pipuid=")) {
                        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet(string.getAttributes());
                        String string12 = PIPMigrate.findPIPUID(lDAPAttributeSet, string11);
                        if (string12 == null) continue;
                        String string13 = PIPMigrate.getUserDN(string12, lDAPConnection, string10);
                        if (string13 == null) {
                            string13 = string12;
                        }
                        PIPMigrate.handleEntry(lDAPAttributeSet, (PrintWriter)object2, string13);
                    }
                    lDIFRecord = object.nextRecord();
                }
            }
            catch (IOException iOException) {
                System.out.println("Error for old ldif file: " + iOException.toString());
                return;
            }
        }
        object = null;
        LDAPEntry lDAPEntry = null;
        string2 = null;
        try {
            object = new LDAPConnection();
            object.connect(string5, n);
            object.authenticate(string7, string8);
            string = "pipuid=*";
            LDAPSearchConstraints lDAPSearchConstraints = object.getSearchConstraints();
            lDAPSearchConstraints.setBatchSize(0);
            lDAPSearchConstraints.setMaxResults(0);
            LDAPSearchResults lDAPSearchResults = object.search(string4, 2, string, null, false, lDAPSearchConstraints);
            while (lDAPSearchResults.hasMoreElements()) {
                Object object3;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                    LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                    String string14 = PIPMigrate.findPIPUID(lDAPAttributeSet, (String)(object3 = lDAPEntry.getDN()));
                    if (string14 == null) continue;
                    String string15 = PIPMigrate.getUserDN(string14, (LDAPConnection)object, string6);
                    if (string15 == null) {
                        System.out.println("Error get uid: " + string14);
                        continue;
                    }
                    String string16 = PIPMigrate.getUserDN(string14, lDAPConnection, string10);
                    if (string16 == null) {
                        string16 = string15;
                    }
                    PIPMigrate.handleEntry(lDAPAttributeSet, (PrintWriter)object2, string16);
                }
                catch (LDAPReferralException lDAPReferralException) {
                    System.out.println("Search reference: ");
                    object3 = lDAPReferralException.getURLs();
                    for (int i = 0; i < ((LDAPUrl[])object3).length; ++i) {
                        System.out.println("\t" + object3[i].getUrl());
                    }
                }
                catch (LDAPException lDAPException) {
                    System.out.println("Error: " + lDAPException.toString());
                }
            }
        }
        catch (LDAPException lDAPException) {
            System.out.println("Error for old ldap: " + lDAPException.toString());
        }
        if (object != null && object.isConnected()) {
            try {
                object.disconnect();
            }
            catch (LDAPException lDAPException) {
                System.out.println("Error: " + lDAPException.toString());
            }
        }
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                System.out.println("Error: " + lDAPException.toString());
            }
        }
        ((PrintWriter)object2).close();
    }

    static String getFirstValue(LDAPAttribute lDAPAttribute) {
        if (lDAPAttribute == null) {
            return null;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration != null && enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    static int handleEntry(LDAPAttributeSet lDAPAttributeSet, PrintWriter printWriter, String string) {
        LDAPAttribute lDAPAttribute = null;
        printWriter.println("dn: " + string);
        printWriter.println("changetype: modify");
        printWriter.println("add: objectClass");
        printWriter.println("objectClass: sunPortalPKSubscriptionsPerson");
        String string2 = null;
        String string3 = "3";
        int n = 0;
        long l = 0L;
        try {
            lDAPAttribute = lDAPAttributeSet.getAttribute("pipstatus");
            if (PIPMigrate.getFirstValue(lDAPAttribute).equals("0")) {
                return 0;
            }
            lDAPAttribute = lDAPAttributeSet.getAttribute("piptimestamp");
            string2 = PIPMigrate.getFirstValue(lDAPAttribute);
            lDAPAttribute = lDAPAttributeSet.getAttribute("pipmaxhits");
            string3 = PIPMigrate.getFirstValue(lDAPAttribute);
            lDAPAttribute = lDAPAttributeSet.getAttribute("pipidstcount");
            n = Integer.parseInt(PIPMigrate.getFirstValue(lDAPAttribute));
            lDAPAttribute = lDAPAttributeSet.getAttribute("pipfrequency");
            l = Integer.parseInt(PIPMigrate.getFirstValue(lDAPAttribute));
            l = l < 3L ? 7L : (l == 3L ? 30L : 365L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 1) {
            return 0;
        }
        lDAPAttribute = lDAPAttributeSet.getAttribute("pipstquery");
        if (lDAPAttribute == null) {
            return 0;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration == null) {
            return 0;
        }
        Enumeration enumeration2 = null;
        lDAPAttribute = lDAPAttributeSet.getAttribute("pipstinterest");
        if (lDAPAttribute != null) {
            enumeration2 = lDAPAttribute.getStringValues();
        }
        Enumeration enumeration3 = null;
        lDAPAttribute = lDAPAttributeSet.getAttribute("pipststatus");
        if (lDAPAttribute != null) {
            enumeration3 = lDAPAttribute.getStringValues();
        }
        Enumeration enumeration4 = null;
        lDAPAttribute = lDAPAttributeSet.getAttribute("pipstname");
        if (lDAPAttribute != null) {
            enumeration4 = lDAPAttribute.getStringValues();
        }
        for (int i = 1; enumeration.hasMoreElements() && i <= n; ++i) {
            String string4;
            String string5;
            if (enumeration4.hasMoreElements()) {
                string5 = (String)enumeration4.nextElement();
                string5 = string5.substring(string5.indexOf(32) + 1);
            } else {
                string5 = "Query" + i;
            }
            int n2 = 0;
            if (enumeration2.hasMoreElements()) {
                try {
                    String string6 = (String)enumeration2.nextElement();
                    string6 = string6.substring(string6.indexOf(32) + 1);
                    n2 = Integer.parseInt(string6);
                    if (n2 > 3 || n2 < 0) {
                        n2 = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (enumeration3.hasMoreElements()) {
                string4 = (String)enumeration3.nextElement();
                string4 = string4.substring(string4.indexOf(32) + 1);
            } else {
                string4 = "1";
            }
            String string7 = (String)enumeration.nextElement();
            string7 = string7.substring(string7.indexOf(32) + 1);
            String string8 = string5 + "|" + string7;
            if (string5.equals("_sendall")) {
                string8 = "All|( rd-rating > " + n2 + ")";
            } else if (n2 != 0) {
                string8 = string8 + " and ( rd-rating > " + n2 + ")";
            }
            string8 = string8 + "|" + l;
            printWriter.println("sunPortalSavedSearch: " + string8);
        }
        printWriter.println("");
        return 1;
    }

    static String getUserDN(String string, LDAPConnection lDAPConnection, String string2) {
        if (lDAPConnection == null) {
            return null;
        }
        String string3 = "uid=" + string;
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 2, string3, null, false);
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            if (lDAPEntry == null) {
                return null;
            }
            String string4 = lDAPEntry.getDN();
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String findPIPUID(LDAPAttributeSet lDAPAttributeSet, String string) {
        LDAPAttribute lDAPAttribute = null;
        lDAPAttribute = lDAPAttributeSet.getAttribute("pipuid");
        if (lDAPAttribute == null) {
            System.out.println("Error to get pipuid: " + string);
            return null;
        }
        String string2 = PIPMigrate.getFirstValue(lDAPAttribute);
        if (string2 == null) {
            System.out.println("Error get null pipuid: " + string);
            return null;
        }
        return string2;
    }

    static void Usage() {
        System.out.println("PIPMigrate outfile");
        System.out.println("PIPMigrate outfile host port binddn pw basedn");
    }
}

