/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimSession;
import com.aligo.pim.lotus.LotusPimAddressBook;
import com.aligo.pim.lotus.LotusPimAddressEntryItem;
import com.aligo.pim.lotus.LotusPimAddressEntryItemFilter;
import com.aligo.pim.lotus.LotusPimCalendar;
import com.aligo.pim.lotus.LotusPimDummyFolder;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimFolder;
import com.aligo.pim.lotus.LotusPimFolders;
import com.aligo.pim.lotus.LotusPimGlobalAddressBook;
import com.aligo.pim.lotus.LotusPimInbox;
import com.aligo.pim.lotus.LotusPimPersonalAddressBook;
import com.aligo.pim.lotus.LotusPimTask;
import com.aligo.pim.lotus.LotusPimUserInfo;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.AddressBookRecycle;
import com.aligo.pim.lotus.recycle.CalendarRecycle;
import com.aligo.pim.lotus.recycle.DatabaseRecycle;
import com.aligo.pim.lotus.recycle.DbDirectoryRecycle;
import com.aligo.pim.lotus.recycle.DefaultRecycle;
import com.aligo.pim.lotus.recycle.DeletedRecycle;
import com.aligo.pim.lotus.recycle.FolderRecycle;
import com.aligo.pim.lotus.recycle.InboxRecycle;
import com.aligo.pim.lotus.recycle.MasterRecycle;
import com.aligo.pim.lotus.recycle.OutboxRecycle;
import com.aligo.pim.lotus.recycle.PersonalAddressBookRecycle;
import com.aligo.pim.lotus.recycle.SentRecycle;
import com.aligo.pim.lotus.recycle.TaskRecycle;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.DbDirectory;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.View;

public class LotusPimSession
implements PimSession {
    Session _oSession = null;
    Database _oMailDatabase = null;
    DbDirectory _oDbDirectory = null;
    Database _oAddressBookDatabase = null;
    String m_szMailFileName = null;
    LotusPimInbox m_oPimInbox;
    LotusPimCalendar m_oPimCalendar;
    LotusPimGlobalAddressBook m_oPimGlobalAddressBook;
    LotusPimTask m_oPimTask;
    LotusPimInbox m_oPimSent;
    LotusPimInbox m_oPimDeleted;
    LotusPimPersonalAddressBook m_oPimPersonalAddressBook;
    MasterRecycle m_oMasterRecycle;
    LotusPimUserInfo m_oPimUserInfo;
    private View m_oPublicAddressBookPeopleView;
    private View m_oPublicAddressBookGroupView;

    public LotusPimSession(Session session, LotusPimUserInfo lotusPimUserInfo) {
        this._oSession = session;
        this.m_oPimUserInfo = lotusPimUserInfo;
        this.m_oMasterRecycle = new MasterRecycle(this);
    }

    public Session getLotusSession() throws LotusPimException {
        return this._oSession;
    }

    public OutboxRecycle getOutboxRecycle() {
        return this.m_oMasterRecycle.getOutboxRecycle();
    }

    public InboxRecycle getInboxRecycle() {
        return this.m_oMasterRecycle.getInboxRecycle();
    }

    public CalendarRecycle getCalendarRecycle() {
        return this.m_oMasterRecycle.getCalendarRecycle();
    }

    public DbDirectoryRecycle getDbDirectoryRecycle() {
        return this.m_oMasterRecycle.getDbDirectoryRecycle();
    }

    public DatabaseRecycle getDatabaseRecycle() {
        return this.m_oMasterRecycle.getDatabaseRecycle();
    }

    public DefaultRecycle getDefaultRecycle() {
        return this.m_oMasterRecycle.getDefaultRecycle();
    }

    public TaskRecycle getTaskRecycle() {
        return this.m_oMasterRecycle.getTaskRecycle();
    }

    public SentRecycle getSentRecycle() {
        return this.m_oMasterRecycle.getSentRecycle();
    }

    public DeletedRecycle getDeletedRecycle() {
        return this.m_oMasterRecycle.getDeletedRecycle();
    }

    public FolderRecycle getFolderRecycle() {
        return this.m_oMasterRecycle.getFolderRecycle();
    }

    public AddressBookRecycle getAddressBookRecycle() {
        return this.m_oMasterRecycle.getAddressBookRecycle();
    }

    public PersonalAddressBookRecycle getPersonalAddressBookRecycle() {
        return this.m_oMasterRecycle.getPersonalAddressBookRecycle();
    }

    public void recycle() throws LotusPimException {
        try {
            if (this._oAddressBookDatabase != null) {
                this._oAddressBookDatabase.recycle();
            }
            if (this._oMailDatabase != null) {
                this._oMailDatabase.recycle();
            }
            if (this._oDbDirectory != null) {
                this._oDbDirectory.recycle();
            }
            if (this._oSession != null) {
                this._oSession.recycle();
            }
            this._oAddressBookDatabase = null;
            this._oMailDatabase = null;
            this._oDbDirectory = null;
            this._oSession = null;
            this.m_oPimInbox = null;
            this.m_oPimCalendar = null;
            this.m_oPimGlobalAddressBook = null;
            this.m_oPimTask = null;
            this.m_oPimSent = null;
            this.m_oPimDeleted = null;
            this.m_oPimPersonalAddressBook = null;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    private DbDirectory getLotusDbDirectory() throws LotusPimException {
        try {
            if (this._oDbDirectory == null) {
                this._oDbDirectory = this.getLotusSession().getDbDirectory(null);
                this.getDbDirectoryRecycle().add(this._oDbDirectory);
            }
            return this._oDbDirectory;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    private String getMailFileName() throws LotusPimException {
        try {
            if (this.m_szMailFileName == null) {
                LotusPimAddressBook lotusPimAddressBook = this.getGlobalPeopleAddressBook();
                PimAddressEntryItems pimAddressEntryItems = lotusPimAddressBook.getAddressEntryItems();
                LotusPimAddressEntryItemFilter lotusPimAddressEntryItemFilter = (LotusPimAddressEntryItemFilter)pimAddressEntryItems.getAddressEntryItemFilter();
                lotusPimAddressEntryItemFilter.setCommonUserNameForMailFile(this.getLotusSession().getCommonUserName());
                LotusPimAddressEntryItem lotusPimAddressEntryItem = (LotusPimAddressEntryItem)pimAddressEntryItems.getFirstAddressEntryItem();
                if (lotusPimAddressEntryItem == null) {
                    lotusPimAddressBook = this.getGlobalPeopleAddressBook();
                    pimAddressEntryItems = lotusPimAddressBook.getAddressEntryItems();
                    lotusPimAddressEntryItem = (LotusPimAddressEntryItem)pimAddressEntryItems.getFirstAddressEntryItem();
                }
                while (lotusPimAddressEntryItem != null) {
                    if (lotusPimAddressEntryItem.getName().equals(this.getLotusSession().getCommonUserName())) break;
                    lotusPimAddressEntryItem = (LotusPimAddressEntryItem)pimAddressEntryItems.getNextAddressEntryItem();
                }
                if (lotusPimAddressEntryItem != null) {
                    this.m_szMailFileName = lotusPimAddressEntryItem.getMailFileName();
                } else {
                    throw new LotusPimException(27L);
                }
            }
            return this.m_szMailFileName;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void refreshDatabase() throws LotusPimException {
        try {
            this._oMailDatabase = this.getLotusDbDirectory().openDatabase(this.getMailFileName(), false);
            Date date = null;
            Date date2 = null;
            try {
                DateTime dateTime = this._oMailDatabase.getLastModified();
                DateTime dateTime2 = this._oMailDatabase.getLastFTIndexed();
                if (dateTime != null) {
                    date = dateTime.toJavaDate();
                }
                if (dateTime2 == null) {
                    this._oMailDatabase.updateFTIndex(true);
                } else {
                    try {
                        date2 = dateTime2.toJavaDate();
                    }
                    catch (Exception exception) {
                        this._oMailDatabase.updateFTIndex(true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (date2 != null && date != null && date.getTime() - date2.getTime() > 0L) {
                this._oMailDatabase.updateFTIndex(false);
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public Database getLotusMailDatabase() throws LotusPimException {
        try {
            if (this._oMailDatabase == null) {
                this.refreshDatabase();
            }
            return this._oMailDatabase;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public PimAddressEntryItem getCurrentUser() throws LotusPimException {
        try {
            return LotusPimUtility.getAddressEntryItem(this.getLotusSession(), this, this.getDefaultRecycle());
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimInbox getOutbox() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Inbox)");
            if (view == null) {
                return null;
            }
            this.getOutboxRecycle().add(view);
            LotusPimCalendar lotusPimCalendar = this.getCalendarForOutbox();
            return new LotusPimInbox(view, lotusPimCalendar, this, this.getOutboxRecycle());
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimInbox getInbox() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Inbox)");
            if (view == null) {
                return null;
            }
            this.getInboxRecycle().add(view);
            LotusPimCalendar lotusPimCalendar = this.getCalendarForInbox();
            if (this.m_oPimInbox == null) {
                this.m_oPimInbox = new LotusPimInbox(view, lotusPimCalendar, this, this.getInboxRecycle());
            } else {
                this.m_oPimInbox = null;
                this.m_oPimInbox = new LotusPimInbox(view, lotusPimCalendar, this, this.getInboxRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimInbox;
    }

    public LotusPimCalendar getCalendarForOutbox() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Calendar)");
            if (view == null) {
                return null;
            }
            this.getOutboxRecycle().add(view);
            return new LotusPimCalendar(view, this, this.getOutboxRecycle());
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimCalendar getCalendarForInbox() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Calendar)");
            if (view == null) {
                return null;
            }
            this.getInboxRecycle().add(view);
            return new LotusPimCalendar(view, this, this.getInboxRecycle());
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimCalendar getCalendarForFolder() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Calendar)");
            if (view == null) {
                return null;
            }
            this.getFolderRecycle().add(view);
            return new LotusPimCalendar(view, this, this.getFolderRecycle());
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimCalendar getCalendar() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Calendar)");
            if (view == null) {
                return null;
            }
            this.getCalendarRecycle().add(view);
            if (this.m_oPimCalendar == null) {
                this.m_oPimCalendar = new LotusPimCalendar(view, this, this.getCalendarRecycle());
            } else {
                this.m_oPimCalendar = null;
                this.m_oPimCalendar = new LotusPimCalendar(view, this, this.getCalendarRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimCalendar;
    }

    public View getLotusPersonalAddressBookView() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Contacts)");
            if (view != null) {
                this.getPersonalAddressBookRecycle().add(view);
            }
            return view;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public LotusPimPersonalAddressBook getPersonalAddressBook() throws LotusPimException {
        try {
            View view = this.getLotusPersonalAddressBookView();
            if (view == null) {
                return null;
            }
            if (this.m_oPimPersonalAddressBook == null) {
                this.m_oPimPersonalAddressBook = new LotusPimPersonalAddressBook(view, this, this.getPersonalAddressBookRecycle());
            } else {
                this.m_oPimPersonalAddressBook = null;
                this.m_oPimPersonalAddressBook = new LotusPimPersonalAddressBook(view, this, this.getPersonalAddressBookRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimPersonalAddressBook;
    }

    public Database getPublicAddressBookDatabase() throws LotusPimException {
        try {
            if (this._oAddressBookDatabase == null) {
                Vector vector = this.getLotusSession().getAddressBooks();
                Enumeration enumeration = vector.elements();
                Database database = null;
                while (enumeration.hasMoreElements()) {
                    database = (Database)enumeration.nextElement();
                    if (database != null && database.isPublicAddressBook()) break;
                }
                if (database == null) {
                    return null;
                }
                this._oAddressBookDatabase = database;
                this._oAddressBookDatabase.open();
            }
            return this._oAddressBookDatabase;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public View getLotusPublicAddressBookGroupView() throws LotusPimException {
        try {
            if (this.m_oPublicAddressBookGroupView == null) {
                Database database = this.getPublicAddressBookDatabase();
                if (database == null) {
                    return null;
                }
                this.m_oPublicAddressBookGroupView = database.getView("Groups");
                if (this.m_oPublicAddressBookGroupView == null) {
                    return null;
                }
                AddressBookRecycle addressBookRecycle = this.getAddressBookRecycle();
                addressBookRecycle.add(this.m_oPublicAddressBookGroupView);
                return this.m_oPublicAddressBookGroupView;
            }
            return this.m_oPublicAddressBookGroupView;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public View getLotusPublicAddressBookPeopleView() throws LotusPimException {
        try {
            if (this.m_oPublicAddressBookPeopleView == null) {
                Database database = this.getPublicAddressBookDatabase();
                if (database == null) {
                    return null;
                }
                this.m_oPublicAddressBookPeopleView = database.getView("People");
                if (this.m_oPublicAddressBookPeopleView == null) {
                    return null;
                }
                AddressBookRecycle addressBookRecycle = this.getAddressBookRecycle();
                addressBookRecycle.add(this.m_oPublicAddressBookPeopleView);
                return this.m_oPublicAddressBookPeopleView;
            }
            return this.m_oPublicAddressBookPeopleView;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public LotusPimAddressBook getGlobalAddressBookNoCache() throws LotusPimException {
        try {
            View view = this.getLotusPublicAddressBookPeopleView();
            if (view == null) {
                return null;
            }
            LotusPimAddressBook lotusPimAddressBook = new LotusPimAddressBook(view, this, this.getAddressBookRecycle());
            return lotusPimAddressBook;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimAddressBook getGlobalPeopleAddressBook() throws LotusPimException {
        try {
            View view = this.getLotusPublicAddressBookPeopleView();
            if (view == null) {
                return null;
            }
            LotusPimAddressBook lotusPimAddressBook = new LotusPimAddressBook(view, this, this.getAddressBookRecycle());
            return lotusPimAddressBook;
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public LotusPimGlobalAddressBook getGlobalAddressBook() throws LotusPimException {
        try {
            View view = this.getLotusPublicAddressBookGroupView();
            View view2 = this.getLotusPublicAddressBookPeopleView();
            if (view2 == null && view == null) {
                return null;
            }
            if (this.m_oPimGlobalAddressBook == null) {
                this.m_oPimGlobalAddressBook = new LotusPimGlobalAddressBook(view2, view, this, this.getAddressBookRecycle());
            } else {
                this.m_oPimGlobalAddressBook = null;
                this.m_oPimGlobalAddressBook = new LotusPimGlobalAddressBook(view2, view, this, this.getAddressBookRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimGlobalAddressBook;
    }

    public LotusPimTask getTask() throws LotusPimException {
        try {
            View view = this.getLotusMailDatabase().getView("($Calendar)");
            if (view == null) {
                return null;
            }
            this.getTaskRecycle().add(view);
            if (this.m_oPimTask == null) {
                this.m_oPimTask = new LotusPimTask(view, this, this.getTaskRecycle());
            } else {
                this.m_oPimTask = null;
                this.m_oPimTask = new LotusPimTask(view, this, this.getTaskRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimTask;
    }

    public LotusPimInbox getSent() throws LotusPimException {
        try {
            SentRecycle sentRecycle = this.getSentRecycle();
            View view = this.getLotusMailDatabase().getView("($Sent)");
            if (view == null) {
                return null;
            }
            sentRecycle.add(view);
            if (this.m_oPimSent == null) {
                this.m_oPimSent = new LotusPimInbox(view, this.m_oPimCalendar, this, this.getSentRecycle());
            } else {
                this.m_oPimSent = null;
                this.m_oPimSent = new LotusPimInbox(view, this.m_oPimCalendar, this, this.getSentRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimSent;
    }

    public LotusPimInbox getDeleted() throws LotusPimException {
        try {
            DeletedRecycle deletedRecycle = this.getDeletedRecycle();
            View view = this.getLotusMailDatabase().getView("($Trash)");
            if (view == null) {
                return null;
            }
            deletedRecycle.add(view);
            if (this.m_oPimDeleted == null) {
                this.m_oPimDeleted = new LotusPimInbox(view, this.m_oPimCalendar, this, this.getDeletedRecycle());
            } else {
                this.m_oPimDeleted = null;
                this.m_oPimDeleted = new LotusPimInbox(view, this.m_oPimCalendar, this, this.getDeletedRecycle());
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
        return this.m_oPimDeleted;
    }

    public LotusPimFolder getRootFolder() {
        return new LotusPimDummyFolder(null, this, this.getFolderRecycle());
    }

    private Vector getViews(String string) throws LotusPimException {
        try {
            Vector vector = this.getLotusMailDatabase().getViews();
            int n = 0;
            while (n < vector.size()) {
                View view = (View)vector.elementAt(n);
                if (!view.isFolder()) {
                    if (view.getName().equals("($Drafts)") || view.getName().equals("($Sent)")) {
                        if (!string.equalsIgnoreCase("Root Folder\\") && !view.getName().startsWith(string)) {
                            vector.removeElementAt(n);
                            --n;
                        }
                    } else {
                        vector.removeElementAt(n);
                        --n;
                    }
                } else if (!string.equalsIgnoreCase("Root Folder\\") && !view.getName().startsWith(string)) {
                    vector.removeElementAt(n);
                    --n;
                } else if (view.getName().equalsIgnoreCase("($Alarms)") || view.getName().equalsIgnoreCase("(Rules)") || view.getName().equalsIgnoreCase("(Group Calendars)")) {
                    vector.removeElementAt(n);
                    --n;
                }
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public LotusPimFolders getFolders(String string) throws LotusPimException {
        string = string + "\\";
        try {
            FolderRecycle folderRecycle = this.getFolderRecycle();
            Vector vector = this.getViews(string);
            folderRecycle.add(vector);
            return new LotusPimFolders(vector, string, this.getCalendarForFolder(), this, this.getFolderRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public View getView(String string, String string2) throws LotusPimException {
        try {
            Vector vector = this.getViews(string2);
            int n = 0;
            while (n < vector.size()) {
                View view = (View)vector.elementAt(n);
                if (view.getUniversalID().equals(string)) {
                    return view;
                }
                ++n;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

