/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.lotus.LotusPimAppointmentItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimExistingApptExistingReminderItem;
import com.aligo.pim.lotus.LotusPimExistingApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimRecipientItems;
import com.aligo.pim.lotus.LotusPimRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimUtility;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.ViewEntry;

public class LotusPimRecurringAppointmentItem
extends LotusPimMessageItem
implements PimAppointmentItem {
    public static final String ID_DELIMITER = "+";
    public static final String DATE_INDEX_DELIMITER = ":";
    private int m_iStartDateTimeIndex;
    private int m_iEndDateTimeIndex;
    private LotusPimRecurrencePatternItem m_oPimRecurrencePatternItem;
    private PimCalendarType m_oPimCalendarType;
    private boolean m_bIsAllDayEvent;
    private PimReminderItem m_oPimReminderItem;

    public LotusPimRecurringAppointmentItem(ViewEntry viewEntry, int n, int n2, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
        this.m_iStartDateTimeIndex = n;
        this.m_iEndDateTimeIndex = n2;
    }

    public LotusPimRecurringAppointmentItem(Document document, int n, int n2, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
        this.m_iStartDateTimeIndex = n;
        this.m_iEndDateTimeIndex = n2;
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString("OrgRepeat");
            if (string != null && string.equals("1")) {
                this.m_oPimRecurrencePatternItem = new LotusPimRecurrencePatternItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimCalendarType getType() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString("AppointmentType");
            if (string == null) {
                return null;
            }
            if (string.equals("3")) {
                this.m_oPimCalendarType = PimCalendarType.MEETING;
                return PimCalendarType.MEETING;
            }
            if (string.equals("1")) {
                this.m_oPimCalendarType = PimCalendarType.ANNIVERSARY;
                return PimCalendarType.ANNIVERSARY;
            }
            this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            return PimCalendarType.APPOINTMENT;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setType(PimCalendarType pimCalendarType) throws LotusPimException {
        try {
            if (pimCalendarType.equals(PimCalendarType.MEETING)) {
                this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"3");
                this.m_oPimCalendarType = pimCalendarType;
            } else {
                this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"0");
                this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getDuration() throws LotusPimException {
        try {
            if (this.isAllDayEvent()) {
                return 1440;
            }
            DateTime dateTime = this.getStartDateTime();
            DateTime dateTime2 = this.getEndDateTime();
            if (dateTime != null && dateTime2 != null) {
                int n = dateTime2.timeDifference(dateTime);
                return n / 60;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return 0;
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem("StartDateTime") && !(vector = this.getLotusDocument().getItemValue("StartDateTime")).isEmpty() && vector.size() > this.getStartDateTimeIndex()) {
                DateTime dateTime = (DateTime)vector.elementAt(this.getStartDateTimeIndex());
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    private int getStartDateTimeIndex() {
        return this.m_iStartDateTimeIndex;
    }

    private int getEndDateTimeIndex() {
        return this.m_iEndDateTimeIndex;
    }

    private DateTime getEndDateTime() throws LotusPimException {
        try {
            Vector vector;
            if (this.getLotusDocument().hasItem("EndDateTime") && !(vector = this.getLotusDocument().getItemValue("EndDateTime")).isEmpty() && vector.size() > this.getEndDateTimeIndex()) {
                DateTime dateTime = (DateTime)vector.elementAt(this.getEndDateTimeIndex());
                return dateTime;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getEndTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getEndDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public String getLocation() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("location")) {
                return this.getLotusDocument().getItemValueString("location");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public PimAddressEntryItem getOrganizer() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("Chair")) {
                return LotusPimUtility.getAddressEntryItem(this.getLotusSession(), this.getLotusDocument().getItemValueString("Chair"), this.getLotusPimSession(), this.getRecycle());
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public Date getStartTime() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("subject")) {
                return this.getLotusDocument().getItemValueString("subject");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public String getText() throws LotusPimException {
        try {
            if (this.getLotusDocument().hasItem("Body")) {
                return this.getLotusDocument().getItemValueString("Body");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return "";
    }

    public boolean isAllDayEvent() throws LotusPimException {
        try {
            String string = this.getLotusDocument().getItemValueString("AppointmentType");
            if (string == null) {
                this.m_bIsAllDayEvent = false;
            }
            this.m_bIsAllDayEvent = string.equals("2");
            return this.m_bIsAllDayEvent;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setAllDayEvent(boolean bl) throws LotusPimException {
        try {
            this.m_bIsAllDayEvent = bl;
            if (this.m_bIsAllDayEvent) {
                this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"2");
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setEndTime(Date date) throws LotusPimException {
        try {
            if (!this.getEndTime().equals(date)) {
                throw new LotusPimException(82L);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws LotusPimException {
    }

    public void setLocation(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("location", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setStartTime(Date date) throws LotusPimException {
        try {
            if (!this.getStartTime().equals(date)) {
                throw new LotusPimException(82L);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("subject", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.getLotusDocument().removeItem("Body");
            this.getLotusDocument().save(true);
            try {
                RichTextItem richTextItem = this.getLotusDocument().createRichTextItem("Body");
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                richTextItem.appendStyle(richTextStyle);
                richTextItem.appendText(string);
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue("Body", (Object)string);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Appointment Item forwarded ");
            LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimAppointmentItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            super.delete();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        this.delete();
    }

    public void send() throws LotusPimException {
        try {
            if (this.getLotusDocument().getItemValueInteger("_ViewIcon") == 158 && this.getLotusDocument().getItemValueString("AppointmentType").equals("3")) {
                Document document = this.getLotusDatabase().createDocument();
                this.getRecycle().add(document);
                this.getLotusDocument().copyAllItems(document, true);
                document.replaceItemValue("Form", (Object)"Notice");
                document.replaceItemValue("_ViewIcon", (Object)new Integer(133));
                document.replaceItemValue("subject", (Object)("Invitation: " + this.getSubject() + " (" + this.getStartTime() + " in " + this.getLocation() + ")"));
                document.replaceItemValue("Topic", (Object)this.getSubject());
                document.replaceItemValue("NoticeType", (Object)"I");
                document.replaceItemValue("ApptUNID", (Object)this.getID());
                document.replaceItemValue("$Orig", (Object)this.getID());
                LotusPimRecipientItems lotusPimRecipientItems = this.getLotusPimRecipientItems();
                if (lotusPimRecipientItems != null) {
                    document.replaceItemValue("SendTo", (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue("CopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("AltCopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("AltSendTo", (Object)lotusPimRecipientItems.getSendToVector());
                    document.replaceItemValue("InetCopyTo", (Object)lotusPimRecipientItems.getCopyToVector());
                    document.replaceItemValue("InetSendTo", (Object)lotusPimRecipientItems.getSendToVector());
                }
                this.getLotusDocument().replaceItemValue("$StorageCc", (Object)this.getLotusDocument().getItemValue("StorageOptionalNames"));
                this.getLotusDocument().replaceItemValue("$StorageTo", (Object)this.getLotusDocument().getItemValue("StorageRequiredNames"));
                LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
                lotusPimAppointmentItem.send();
                return;
            }
            super.send();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setChair(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("Chair", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setFrom(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("From", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSendTo(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("SendTo", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return this.getLotusDocument().getNoteID() + ID_DELIMITER + this.getStartDateTimeIndex() + DATE_INDEX_DELIMITER + this.getEndDateTimeIndex();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void updateAsMeetingAccepted() throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("Form", (Object)"Appointment");
            this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"3");
            this.getLotusDocument().replaceItemValue("_ViewIcon", (Object)new Integer(158));
            this.getLotusDocument().replaceItemValue("NoticeType", (Object)"A");
            this.getLotusDocument().replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                String string = this.getLotusDocument().getItemValueString("Alarms");
                if (string != null && string.equals("1") && this.getLotusDocument().hasItem("$Alarm") && this.getLotusDocument().getItemValueInteger("$Alarm") == 1) {
                    this.m_oPimReminderItem = new LotusPimExistingApptExistingReminderItem(this.getLotusDocument(), this.getLotusPimSession(), this.getRecycle());
                } else {
                    return null;
                }
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            this.m_oPimReminderItem = this.getReminderItem();
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimExistingApptNewReminderItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void sendMeetingRequest() throws LotusPimException {
    }

    public String getName() throws LotusPimException {
        try {
            return "Appointment: " + this.getSubject() + " in " + this.getLocation();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setAllDayEventDates() throws LotusPimException {
        Date date = this.getStartTime();
        Date date2 = this.getEndTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1) - 1900;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n, n2, 4, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = gregorianCalendar2.get(5);
        int n6 = gregorianCalendar2.get(1) - 1900;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(n6, n4, n5, 20, 0);
        this.setStartTime(calendar.getTime());
        this.setEndTime(calendar2.getTime());
    }

    public void update() throws LotusPimException {
        try {
            if (this.isThisItemNew()) {
                if (this.m_oPimCalendarType == null) {
                    this.m_oPimCalendarType = PimCalendarType.APPOINTMENT;
                }
                Cloneable cloneable = this.getStartTime();
                Object object = this.getEndTime();
                if (cloneable == null) {
                    cloneable = new Date();
                    this.setStartTime((Date)cloneable);
                }
                if (object == null) {
                    object = cloneable;
                    this.setEndTime((Date)object);
                }
                if (this.getEndDateTime().timeDifference(this.getStartDateTime()) < 0) {
                    throw new LotusPimException(13L);
                }
                this.getLotusDocument().replaceItemValue("$BusyName", (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue("$BusyPriority", (Object)"1");
                this.getLotusDocument().replaceItemValue("$CSVersion", (Object)"2");
                this.getLotusDocument().replaceItemValue("$ExpandGroups", (Object)"3");
                this.getLotusDocument().replaceItemValue("$NoPurge", (Object)this.getStartDateTime());
                this.getLotusDocument().replaceItemValue("$PublicAccess ", (Object)"1");
                this.getLotusDocument().replaceItemValue("$SMTPKeepNotesItems", (Object)"1");
                this.getLotusDocument().replaceItemValue("$UpdatedBy", (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue("$WebFlags", (Object)"J");
                this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
                this.getLotusDocument().replaceItemValue("Chair", (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
                cloneable = new Vector();
                ((Vector)cloneable).add("D");
                ((Vector)cloneable).add("S");
                this.getLotusDocument().replaceItemValue("ExcludeFromView", (Object)cloneable);
                this.getLotusDocument().replaceItemValue("Encrypt", (Object)"0");
                this.getLotusDocument().replaceItemValue("Form", (Object)"Appointment");
                this.getLotusDocument().replaceItemValue("From", (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue("Logo", (Object)"stdNotesLtr0");
                this.getLotusDocument().replaceItemValue("MailFirstPass", (Object)"1");
                this.getLotusDocument().replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
                this.getLotusDocument().replaceItemValue("SequenceNum", (Object)"1");
                this.getLotusDocument().replaceItemValue("Sign", (Object)"0");
                this.getLotusDocument().replaceItemValue("tmpOwnerHW", (Object)"1");
                this.getLotusDocument().replaceItemValue("WebDateTimeInit", (Object)"1");
                if (this.m_oPimCalendarType.equals(PimCalendarType.MEETING)) {
                    if (this.m_bIsAllDayEvent) {
                        this.setAllDayEventDates();
                    }
                    object = this.getLotusPimRecipientItems();
                    Vector vector = new Vector();
                    Vector vector2 = new Vector();
                    Vector vector3 = new Vector();
                    if (object != null) {
                        vector = ((LotusPimRecipientItems)object).getSendToVector();
                        vector2 = ((LotusPimRecipientItems)object).getCopyToVector();
                        vector3 = ((LotusPimRecipientItems)object).getBlindCopyToVector();
                        this.getLotusDocument().replaceItemValue("SendTo", (Object)vector);
                        this.getLotusDocument().replaceItemValue("CopyTo", (Object)vector2);
                        this.getLotusDocument().replaceItemValue("BlindCopyTo", (Object)vector3);
                    }
                    this.getLotusDocument().replaceItemValue("OptionalAttendees", vector2);
                    this.getLotusDocument().replaceItemValue("AltFYINames", (Object)vector3);
                    this.getLotusDocument().replaceItemValue("AltOptionalNames", (Object)vector2);
                    this.getLotusDocument().replaceItemValue("AltRequiredNames", (Object)vector);
                    this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"3");
                    this.getLotusDocument().replaceItemValue("FYIAttendees", (Object)vector3);
                    this.getLotusDocument().replaceItemValue("INetFYINames", (Object)vector3);
                    this.getLotusDocument().replaceItemValue("INetOptionalNames", (Object)vector2);
                    this.getLotusDocument().replaceItemValue("INetRequiredNames", (Object)vector);
                    Vector vector4 = new Vector();
                    vector4.addAll(vector);
                    vector4.addAll(vector2);
                    vector4.addAll(vector3);
                    this.getLotusDocument().replaceItemValue("Recipients", vector4);
                    this.getLotusDocument().replaceItemValue("RequiredAttendees", (Object)vector);
                    this.getLotusDocument().replaceItemValue("_ViewIcon", (Object)new Integer(158));
                    Vector<String> vector5 = new Vector<String>();
                    Vector<String> vector6 = new Vector<String>();
                    Vector<String> vector7 = new Vector<String>();
                    int n = 0;
                    while (n < vector.size()) {
                        vector5.add("1");
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        vector6.add("1");
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < vector3.size()) {
                        vector7.add("1");
                        ++n3;
                    }
                    this.getLotusDocument().replaceItemValue("StorageFYINames", vector7);
                    this.getLotusDocument().replaceItemValue("StorageOptionalNames", vector6);
                    this.getLotusDocument().replaceItemValue("StorageRequiredNames", vector5);
                } else if (this.m_bIsAllDayEvent) {
                    this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"2");
                    this.getLotusDocument().replaceItemValue("OrgTable", (Object)"PO");
                    this.getLotusDocument().replaceItemValue("_ViewIcon", (Object)new Integer(9));
                    this.setAllDayEventDates();
                } else {
                    this.getLotusDocument().replaceItemValue("AppointmentType", (Object)"0");
                    this.getLotusDocument().replaceItemValue("MailOptions", (Object)"0");
                    this.getLotusDocument().replaceItemValue("OrgTable", (Object)"CO");
                    this.getLotusDocument().replaceItemValue("_ViewIcon", (Object)new Integer(160));
                }
            }
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

