/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ProcessConfig {
    Map avs = null;
    ArrayList avsArray = null;
    ArrayList inProcessArray = null;
    String csid = null;
    public String fileName = null;
    ArrayList preComment = null;
    ArrayList afterComment = null;
    long fileLastModified = 0L;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("Usage: ProcessConfig inputFileName outputFileName");
        }
        ProcessConfig processConfig = ProcessConfig.parseProcessConf(stringArray[0]);
        processConfig.updateFile(stringArray[1]);
    }

    public ProcessConfig(String string) {
        this.fileName = string;
        this.Init();
    }

    private void Init() {
        this.avs = new HashMap();
        this.avsArray = new ArrayList();
        this.inProcessArray = new ArrayList();
        this.preComment = new ArrayList();
        this.afterComment = new ArrayList();
    }

    private void reInit() {
        try {
            File file = new File(this.fileName);
            long l = file.lastModified();
            if (l <= this.fileLastModified) {
                return;
            }
            this.Init();
            this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ProcessConfig parseProcessConf(String string) throws Exception {
        ProcessConfig processConfig = new ProcessConfig(string);
        processConfig.parse();
        return processConfig;
    }

    String Quote(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = (string = string.trim()).toCharArray();
        if (cArray.length == 0) {
            return "";
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\' || cArray[i] == '\"') {
                stringBuffer.append('\\');
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (Character.isWhitespace(cArray[i]) || !Character.isLetterOrDigit(cArray[i])) {
                bl = true;
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (bl) {
            return "\"" + stringBuffer.toString() + "\"";
        }
        return stringBuffer.toString();
    }

    AVPair str2AVPair(String string) throws Exception {
        boolean bl;
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("#")) {
            bl2 = true;
            string = string.substring(1);
        }
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        char[] cArray = (string = string.trim()).toCharArray();
        if (cArray.length == 0) {
            return null;
        }
        n3 = cArray.length;
        for (n2 = 0; n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != '='; ++n2) {
        }
        if (n2 == n3 || Character.isWhitespace(cArray[n2])) {
            return null;
        }
        String string2 = string.substring(0, n2);
        if ((n = ++n2) == n3) {
            return new AVPair(string2, "", bl2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = bl = cArray[n] == '\"';
        if (bl) {
            ++n;
        }
        for (n2 = n; n2 < n3; ++n2) {
            if (bl) {
                if (cArray[n2] == '\"') {
                    ++n2;
                    break;
                }
            } else if (Character.isWhitespace(cArray[n2])) break;
            if (cArray[n2] == '\\') {
                ++n2;
            }
            if (n2 >= n3) continue;
            stringBuffer.append(cArray[n2]);
        }
        return new AVPair(string2, stringBuffer.toString(), bl2);
    }

    private void parse() throws Exception {
        File file = new File(this.fileName);
        this.fileLastModified = file.lastModified();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (string != null) {
            AVPair aVPair;
            string = string.trim();
            if (!bl3 && bl) {
                if (string.startsWith(">")) {
                    bl = false;
                    bl2 = true;
                } else {
                    aVPair = this.str2AVPair(string);
                    this.avs.put(aVPair.name, aVPair);
                    this.avsArray.add(aVPair);
                }
            } else if (!bl3 && bl2) {
                if (string.startsWith("</Process")) {
                    bl3 = true;
                    bl2 = false;
                } else {
                    this.inProcessArray.add(string);
                }
            } else if (string.startsWith("<Process ")) {
                bl = true;
                string = string.substring(9);
                aVPair = this.str2AVPair(string);
                if (aVPair.name.compareToIgnoreCase("csid") != 0) {
                    throw new Exception("Missing csid=... in <Process ...");
                }
                this.csid = aVPair.valueString;
            } else if (bl3) {
                this.afterComment.add(string);
            } else {
                this.preComment.add(string);
            }
            string = bufferedReader.readLine();
        }
    }

    public void updateFile() {
        this.updateFile(this.fileName);
    }

    public void updateFile(String string) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            printWriter = new PrintWriter(fileOutputStream, true);
        }
        catch (Exception exception) {
            System.out.println("[updateProcessConf]Exception:" + exception.getMessage());
            return;
        }
        this.updateFile(printWriter);
    }

    public void updateFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.preComment.size(); ++n) {
            printWriter.println((String)this.preComment.get(n));
        }
        printWriter.println("<Process csid=" + this.Quote(this.csid));
        for (n = 0; n < this.avsArray.size(); ++n) {
            AVPair aVPair = (AVPair)this.avsArray.get(n);
            if (aVPair.comment) {
                printWriter.print("#   ");
            } else {
                printWriter.print("    ");
            }
            printWriter.println(aVPair.name + "=" + this.Quote(aVPair.valueString));
        }
        printWriter.println(">");
        for (n = 0; n < this.inProcessArray.size(); ++n) {
            printWriter.println((String)this.inProcessArray.get(n));
        }
        printWriter.println("</Process>");
        for (n = 0; n < this.afterComment.size(); ++n) {
            printWriter.println((String)this.afterComment.get(n));
        }
        printWriter.close();
    }

    public String get(String string) {
        this.reInit();
        AVPair aVPair = (AVPair)this.avs.get(string);
        if (aVPair != null && !aVPair.comment) {
            return aVPair.valueString;
        }
        return null;
    }

    public void put(String string, String string2) {
        AVPair aVPair;
        int n = -1;
        if (string == null || string2 == null) {
            return;
        }
        if (this.avs.containsKey(string) && (aVPair = (AVPair)this.avs.get(string)) != null) {
            if (!aVPair.comment || string2.length() > 0) {
                aVPair = (AVPair)this.avs.remove(string);
                if (aVPair != null) {
                    n = this.avsArray.indexOf(aVPair);
                    this.avsArray.remove(aVPair);
                }
            } else {
                return;
            }
        }
        if (string2.length() > 0) {
            aVPair = new AVPair(string, string2, false);
            this.avs.put(string, aVPair);
            if (n >= 0) {
                this.avsArray.add(n, aVPair);
            } else {
                this.avsArray.add(aVPair);
            }
        }
    }

    class AVPair {
        String name = null;
        String valueString = null;
        boolean comment = false;

        AVPair(String string, String string2, boolean bl) {
            this.name = string;
            this.valueString = string2;
            this.comment = bl;
        }
    }
}

