/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.robot.StringFilter;
import com.sun.portal.search.util.PBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FilterRule {
    public String id;
    public boolean enable = false;
    public String nickname = "";
    public boolean default_ad = false;
    public boolean quickcf = false;
    public static final String[] methods_labels = new String[]{"is", "contains", "begins with", "ends with", "regular expression"};
    public static final String[] filter_methods = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    public static final String[] srcs_labels = new String[]{"URL", "protocol", "host", "path", "MIME type"};
    public static final String[] filter_srcs = new String[]{"url", "protocol", "host", "uri", "type"};
    public ArrayList comments = null;
    public ArrayList pre_comments = null;
    public ArrayList filters = null;

    public FilterRule(String string) {
        HashMap hashMap = new HashMap();
        String string2 = null;
        try {
            PBlock.str2pblock((String)string, hashMap);
        }
        catch (Exception exception) {
            System.out.println("PBlockstr2pblock:Exception:" + exception.getMessage());
        }
        string2 = (String)hashMap.get("id");
        if (string2 != null) {
            this.id = string2;
        }
        if ((string2 = (String)hashMap.get("enable")) != null && string2.compareToIgnoreCase("TRUE") == 0) {
            this.enable = true;
        }
        if ((string2 = (String)hashMap.get("quikcf")) != null && string2.compareToIgnoreCase("TRUE") == 0) {
            this.quickcf = true;
        }
        if ((string2 = (String)hashMap.get("default")) != null && string2.compareToIgnoreCase("ALLOW") == 0) {
            this.default_ad = true;
        }
        if ((string2 = (String)hashMap.get("nickname")) != null) {
            this.nickname = string2;
        }
        this.filters = new ArrayList();
    }

    public FilterRule(String string, boolean bl, String string2, boolean bl2, boolean bl3) {
        this.id = string;
        this.enable = bl;
        this.nickname = string2;
        this.default_ad = bl2;
        this.quickcf = bl3;
        this.filters = new ArrayList();
    }

    public boolean Match(String string) {
        for (int i = 0; i < this.filters.size(); ++i) {
            StringFilter stringFilter = (StringFilter)this.filters.get(i);
            if (!stringFilter.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer("<Rule id=\"" + this.id + "\" enable=\"" + RobotConfig.BtoString(this.enable) + "\" default=\"" + RobotConfig.ADtoString(this.default_ad) + "\" nickname=\"" + this.nickname + "\" >\n");
        for (int i = 0; i < this.filters.size(); ++i) {
            StringFilter stringFilter = (StringFilter)this.filters.get(i);
            stringBuffer.append(stringFilter.toXMLString());
        }
        return stringBuffer.toString();
    }

    public String toConfigString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pre_comments != null) {
            for (n = 0; n < this.pre_comments.size(); ++n) {
                object = (String)this.pre_comments.get(n);
                stringBuffer.append("# " + (String)object + "\n");
            }
        }
        stringBuffer.append("<Rule id=" + this.id + " enable=" + RobotConfig.BtoString(this.enable) + " quikcf=" + RobotConfig.BtoString(this.quickcf) + " default=" + RobotConfig.ADtoString(this.default_ad) + " nickname=\"" + this.nickname + "\" >\n");
        if (this.comments != null) {
            for (n = 0; n < this.comments.size(); ++n) {
                object = (String)this.comments.get(n);
                stringBuffer.append("# " + (String)object + "\n");
            }
        }
        for (n = 0; n < this.filters.size(); ++n) {
            object = (StringFilter)this.filters.get(n);
            stringBuffer.append(((StringFilter)object).toConfigString());
        }
        stringBuffer.append("</Rule>\n");
        return stringBuffer.toString();
    }

    public void addComment(String string) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(string);
    }

    public void addPreComment(ArrayList arrayList) {
        this.pre_comments = arrayList;
    }

    public boolean addFilter(String string, String string2, String string3) {
        for (int i = 0; i < filter_methods.length; ++i) {
            if (filter_methods[i].compareToIgnoreCase(string2) != 0) continue;
            StringFilter stringFilter = new StringFilter(string, i, string3);
            this.filters.add(stringFilter);
            return true;
        }
        return false;
    }

    public boolean delFilterByIndex(int n) {
        return n >= 0 && n < this.filters.size() && this.filters.remove(n) != null;
    }

    public void removeAllFilter() {
        this.filters.clear();
    }

    public void addFilter(String string) {
        HashMap hashMap = new HashMap();
        Object var3_3 = null;
        try {
            PBlock.str2pblock((String)string, hashMap);
        }
        catch (Exception exception) {
            System.out.println("[addFilter]PBlockstr2pblock:Exception:" + exception.getMessage());
        }
        String string2 = (String)hashMap.get("src");
        Object var6_6 = null;
        int n = 0;
        while (true) {
            if (n >= filter_methods.length) break;
            if (hashMap.containsKey(filter_methods[n])) break;
            ++n;
        }
        if (n == filter_methods.length) {
            return;
        }
        String string3 = (String)hashMap.get(filter_methods[n]);
        StringFilter stringFilter = new StringFilter(string2, n, string3);
        this.filters.add(stringFilter);
    }

    public static int StringtoMethodIndex(String string) {
        for (int i = 0; i < filter_methods.length; ++i) {
            if (string.compareToIgnoreCase(filter_methods[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public static String getMethodText(int n) {
        if (n < 0 && n > filter_methods.length) {
            return Integer.toString(n);
        }
        return filter_methods[n];
    }

    public int numberOfStringFilters() {
        return this.filters.size();
    }

    public String getComments() {
        if (this.comments == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.comments.size(); ++i) {
            stringBuffer.append((String)this.comments.get(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public void setComments(String string) {
        if (string == null) {
            return;
        }
        if (this.comments == null) {
            this.comments = new ArrayList();
        } else {
            this.comments.clear();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            this.comments.add(string2);
        }
    }
}

