/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.iplanet.am.util.AdminUtils;
import com.sun.identity.security.EncryptAction;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.autoclassify.AutoclassifyConfig;
import com.sun.portal.search.autoclassify.AutoclassifyContext;
import com.sun.portal.search.autoclassify.HeartBeat;
import com.sun.portal.search.autoclassify.HeartBeatFailureException;
import com.sun.portal.search.autoclassify.RDStore;
import com.sun.portal.search.autoclassify.RemoteSearch;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.DateParser;
import com.sun.portal.search.util.Getopt;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Autoclassify {
    AutoclassifyContext context = null;
    String server_root = ".";
    String logDir = null;
    String taxPath = null;
    String backupTaxPath = null;
    Date since = null;
    Date dbSince = null;
    Date startAt = new Date();
    String rdmServer = null;
    Map newTaxMap = null;
    Map oldTaxMap = null;
    Map results = new HashMap();
    HeartBeat heartbeat = null;
    RDStore rdstore = null;
    public boolean securityMode = false;
    String user = null;
    String password = null;

    public Autoclassify(AutoclassifyContext autoclassifyContext, String string, Date date, String string2) throws Exception {
        String string3;
        this.server_root = string;
        this.context = autoclassifyContext;
        this.logDir = string + File.separator + "logs";
        this.taxPath = string + File.separator + "config" + File.separator + "taxonomy.rdm";
        this.since = date;
        this.rdmServer = string2;
        this.since = date;
        String string4 = SearchConfig.getValue((String)"autoclass-lockfilepath");
        if (string4 == null) {
            string4 = this.logDir + File.separator + "autoclassify.lock";
        }
        if ((string3 = SearchConfig.getValue((String)"security-mode")) != null && string3.toLowerCase().equals("on")) {
            this.securityMode = true;
            this.user = AdminUtils.getAdminDN();
            this.password = (String)AccessController.doPrivileged(new EncryptAction(new String(AdminUtils.getAdminPassword())));
        }
        this.heartbeat = new HeartBeat(string4);
        this.heartbeat.start();
    }

    public void shutdown() {
        this.heartbeat.Stop();
        while (this.heartbeat.isAlive()) {
        }
    }

    Map readTaxToMap(String string, boolean bl) throws Exception {
        HashMap hashMap = new HashMap();
        try {
            Object object;
            SOIFInputStream sOIFInputStream = new SOIFInputStream(string);
            RDMTaxonomy rDMTaxonomy = new RDMTaxonomy(sOIFInputStream);
            if (bl && (object = rDMTaxonomy.getSOIF().getValue("LastRun")) != null) {
                try {
                    this.dbSince = AutoclassifyConfig.formatter.parse((String)object);
                }
                catch (Exception exception) {
                    CSLog.error((int)0, (int)0, (String)exception.getMessage());
                }
            }
            object = rDMTaxonomy.find("ROOT");
            CreateClassMap createClassMap = new CreateClassMap(hashMap);
            object.apply(0, (RDMCallback)createClassMap);
        }
        catch (Exception exception) {
            CSLog.error((int)0, (int)5, (String)exception.getMessage());
        }
        return hashMap;
    }

    private void backupTaxonomy(String string, String string2) throws Exception {
        SOIFInputStream sOIFInputStream = new SOIFInputStream(string);
        SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(string2);
        SOIF sOIF = null;
        while ((sOIF = sOIFInputStream.readSOIF()) != null) {
            if (sOIF.getSchemaName().equalsIgnoreCase("TAXONOMY")) {
                sOIF.insert("LastRun", AutoclassifyConfig.formatter.format(this.startAt));
            }
            sOIFOutputStream.write(sOIF);
        }
        sOIFInputStream.close();
        sOIFOutputStream.close();
    }

    private void resetTaxonomyMap(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map2 = (Map)this.newTaxMap.get(string);
            map2.remove("USETIMESTAMP");
        }
    }

    static String getLocalizedString(String string) {
        try {
            return Autoclassify.getLocalizedString(string, AutoclassifyConfig.getResourceBundle());
        }
        catch (Exception exception) {
            return string;
        }
    }

    String getLocalizedUIString(String string) {
        if (this.context == null) {
            return string;
        }
        return Autoclassify.getLocalizedString(string, this.context.getResourceBundle());
    }

    void indexResult(String string, String string2) {
        String string3 = this.server_root + File.separator + "run-cs-cli rdmgr -m -q -p stdout -y " + string + " " + string2;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                Autoclassify.println(string4);
            }
        }
        catch (Exception exception) {
            Autoclassify.println("rt.exec Exception:" + exception.getMessage());
        }
    }

    public void doAutoClassify(String string, String string2, int n) throws Exception {
        Autoclassify.println(this.getLocalizedUIString("classify_database") + string);
        CSLog.log((int)0, (int)1, (String)(Autoclassify.getLocalizedString("classify_database") + string));
        this.backupTaxPath = this.server_root + File.separator + "db" + File.separator + string + File.separator + "taxonomy.classifed";
        try {
            String string3;
            Object object;
            Map map;
            Object object2;
            if (this.newTaxMap == null) {
                this.newTaxMap = this.readTaxToMap(this.taxPath, false);
            } else {
                this.resetTaxonomyMap(this.newTaxMap);
            }
            this.oldTaxMap = this.readTaxToMap(this.backupTaxPath, true);
            if (this.since != null) {
                Autoclassify.println(this.getLocalizedUIString("overridelastrunat") + this.context.dateTimeFormat(this.since));
                this.dbSince = this.since;
            } else if (this.dbSince != null) {
                Autoclassify.println(this.getLocalizedUIString("lastrunat") + this.context.dateTimeFormat(this.dbSince));
            } else {
                Autoclassify.println(this.getLocalizedUIString("firsttimerun"));
            }
            this.rdstore = new RDStore(n, string2);
            Iterator iterator = this.oldTaxMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                map = (Map)this.oldTaxMap.get(object2);
                object = (Map)this.newTaxMap.get(object2);
                if (object != null) {
                    String string4;
                    string3 = (String)object.get("RULE");
                    if (string3.compareToIgnoreCase(string4 = (String)map.get("RULE")) != 0) {
                        map.put("DELETED", "true");
                        continue;
                    }
                    object.put("USETIMESTAMP", "true");
                    continue;
                }
                map.put("DELETED", "true");
            }
            Autoclassify.println(this.getLocalizedUIString("removeclass"));
            iterator = this.oldTaxMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                map = (Map)this.oldTaxMap.get(object2);
                object = (String)map.get("DELETED");
                if (object == null || !((String)object).equals("true")) continue;
                this.getRemoveClassificationRDs(string, (String)object2);
            }
            Autoclassify.println("");
            Autoclassify.println(this.getLocalizedUIString("addclass"));
            iterator = this.newTaxMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                map = (Map)this.newTaxMap.get(object2);
                object = (String)map.get("USETIMESTAMP");
                string3 = (String)map.get("RULE");
                if (!(string3 != null & string3.length() > 0)) continue;
                if (object != null && ((String)object).equals("true")) {
                    this.getRDs(string, (String)object2, string3, this.dbSince, this.startAt);
                    continue;
                }
                this.getRDs(string, (String)object2, string3, null, this.startAt);
            }
            Autoclassify.println("");
            Autoclassify.println(this.getLocalizedUIString("indexingresult"));
            int n2 = this.rdstore.CreateSOIF("result.soif");
            if (n2 > 0) {
                this.indexResult(string, "result.soif");
            }
            this.rdstore.close();
            this.backupTaxonomy(this.taxPath, this.backupTaxPath);
            CSLog.log((int)0, (int)1, (String)(n2 + Autoclassify.getLocalizedString("numberrdupdated")));
        }
        catch (HeartBeatFailureException heartBeatFailureException) {
            throw heartBeatFailureException;
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
        }
    }

    private void removeAutoClassification(SOIF sOIF, String string) {
        String string2;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        AVPair aVPair = sOIF.getAVPair("RD-Classified");
        for (n = 0; aVPair != null && n <= aVPair.getMaxIndex(); ++n) {
            string2 = aVPair.getValue(n);
            if (string2 == null || string2.compareToIgnoreCase(string) != 0) continue;
            bl2 = true;
            aVPair.remove(n);
            aVPair.squeeze();
            if (aVPair.getMaxIndex() != 0) break;
            aVPair.insert("", 0);
            break;
        }
        if (bl2) {
            aVPair = sOIF.getAVPair("CLASSIFICATION");
            for (n = 0; aVPair != null && n <= aVPair.getMaxIndex(); ++n) {
                string2 = aVPair.getValue(n);
                if (string2 == null || string2.compareToIgnoreCase(string) != 0) continue;
                aVPair.remove(n);
                aVPair.squeeze();
                if (aVPair.getMaxIndex() != 0) break;
                aVPair.insert("", 0);
                break;
            }
        }
    }

    private void appendValueToSOIF(SOIF sOIF, String string, String string2) {
        AVPair aVPair = sOIF.getAVPair(string);
        if (aVPair != null) {
            aVPair.insert(string2, aVPair.getMaxIndex() + 1);
        } else {
            sOIF.insert(string, string2);
        }
    }

    private void addingAutoClassification(SOIF sOIF, String string) {
        String string2;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        AVPair aVPair = sOIF.getAVPair("CLASSIFICATION");
        for (n = 0; aVPair != null && n <= aVPair.getMaxIndex(); ++n) {
            string2 = aVPair.getValue(n);
            if (string2 == null || string2.compareToIgnoreCase(string) != 0) continue;
            bl = true;
            break;
        }
        aVPair = sOIF.getAVPair("RD-Classified");
        for (n = 0; aVPair != null && n <= aVPair.getMaxIndex(); ++n) {
            string2 = aVPair.getValue(n);
            if (string2 == null || string2.compareToIgnoreCase(string) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl && !bl2) {
            this.appendValueToSOIF(sOIF, "RD-Classified", string);
            this.appendValueToSOIF(sOIF, "CLASSIFICATION", string);
        }
    }

    void getRemoveClassificationRDs(String string, String string2) throws Exception {
        String string3 = "Classification = \"" + string2 + "\"";
        RemoteSearch remoteSearch = new RemoteSearch(string3, "CLASSIFICATION,RD-Classified", "search", string, this.rdmServer, this.user, this.password);
        SOIFInputStream sOIFInputStream = remoteSearch.getResult();
        int n = 0;
        SOIF sOIF = sOIFInputStream.readSOIF();
        while (sOIF != null) {
            String string4 = sOIF.getURL();
            SOIF sOIF2 = this.rdstore.getRD(string4);
            if (sOIF2 != null) {
                this.removeAutoClassification(sOIF2, string2);
            } else {
                this.removeAutoClassification(sOIF, string2);
                this.rdstore.putRD(sOIF);
            }
            sOIF = sOIFInputStream.readSOIF();
            ++n;
        }
        Autoclassify.print("(-" + n + ")");
    }

    void getRDs(String string, String string2, String string3, Date date, Date date2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("(" + string3 + ")");
        if (date != null) {
            stringBuffer.append(" <and> RD-Last-Changed >\"");
            stringBuffer.append(AutoclassifyConfig.formatter.format(date));
            stringBuffer.append("\"");
        }
        if (date2 != null) {
            stringBuffer.append(" <and> RD-Last-Changed <=\"");
            stringBuffer.append(AutoclassifyConfig.formatter.format(date2));
            stringBuffer.append("\"");
        }
        RemoteSearch remoteSearch = new RemoteSearch(stringBuffer.toString(), "CLASSIFICATION,RD-Classified", "search", string, this.rdmServer, this.user, this.password);
        SOIFInputStream sOIFInputStream = remoteSearch.getResult();
        int n = 0;
        SOIF sOIF = sOIFInputStream.readSOIF();
        while (sOIF != null) {
            String string4 = sOIF.getURL();
            SOIF sOIF2 = this.rdstore.getRD(string4);
            if (sOIF2 != null) {
                this.addingAutoClassification(sOIF2, string2);
            } else {
                this.addingAutoClassification(sOIF, string2);
                this.rdstore.putRD(sOIF);
            }
            sOIF = sOIFInputStream.readSOIF();
            ++n;
        }
        Autoclassify.print("(+" + n + ")");
    }

    static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public static Locale stringToLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String[] stringArray = Autoclassify.split(string, "_");
        if (stringArray.length >= 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return Locale.getDefault();
    }

    public static void log(String string) {
    }

    public static void print(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            System.out.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void println(String string) {
        Autoclassify.print(string);
        System.out.println();
    }

    public static String getLocalizedString(String string, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Autoclassify autoclassify = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string = null;
        String string2 = null;
        String string3 = ".";
        String[] stringArray2 = null;
        Date date = null;
        try {
            Object object;
            ResourceBundle resourceBundle;
            ResourceBundle resourceBundle2 = resourceBundle = AutoclassifyConfig.getResourceBundle();
            AutoclassifyContext autoclassifyContext = new AutoclassifyContext();
            autoclassifyContext.setResourceBundle(resourceBundle2);
            Getopt getopt = new Getopt(stringArray, "t:s:l:d:");
            block10: while (getopt.optInd < stringArray.length) {
                char c = (char)getopt.getopt();
                switch (c) {
                    case 't': {
                        string = getopt.optArg;
                        continue block10;
                    }
                    case 's': {
                        string2 = getopt.optArg;
                        continue block10;
                    }
                    case 'l': {
                        object = Autoclassify.stringToLocale(getopt.optArg);
                        resourceBundle2 = ResourceBundle.getBundle("autoclassify", (Locale)object);
                        autoclassifyContext.setResourceBundle(resourceBundle2);
                        autoclassifyContext.setUILocale((Locale)object);
                        continue block10;
                    }
                    case 'd': {
                        stringArray2 = Autoclassify.split(getopt.optArg, ":");
                        continue block10;
                    }
                }
                Autoclassify.println(Autoclassify.getLocalizedString("usage", resourceBundle));
                return;
            }
            if (string2 == null) {
                Autoclassify.println(Autoclassify.getLocalizedString("usage", resourceBundle));
                return;
            }
            if (string != null) {
                date = DateParser.parse(string);
            }
            SearchConfig.init((String)(string3 + File.separator + "config" + File.separator + "search.conf"));
            String string4 = SearchConfig.getValue((String)"autoclass-logfilepath");
            if (string4 == null) {
                string4 = string3 + File.separator + "logs" + File.separator + "autoclassify.log";
            }
            CSLog.init((int)1, (String)string4);
            autoclassify = new Autoclassify(autoclassifyContext, string3, date, string2);
            object = SearchConfig.getValue((String)"autoclass-dbfilepath");
            if (object == null) {
                object = string3 + File.separator + "tmp" + File.separator + "autoclassify.log";
            }
            String string5 = SearchConfig.getValue((String)"autoclass-rdsinmemory");
            int n = 10000;
            if (string5 != null) {
                try {
                    n = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Autoclassify.println(autoclassify.getLocalizedUIString("prompt_started"));
            CSLog.log((int)0, (int)0, (String)Autoclassify.getLocalizedString("prompt_started"));
            CSLog.log((int)0, (int)0, (String)(Autoclassify.getLocalizedString("security_mode") + (autoclassify.securityMode ? Autoclassify.getLocalizedString("security_on") : Autoclassify.getLocalizedString("security_off"))));
            String[] stringArray3 = DBUtil.getDBStringArray(string3);
            if (stringArray2 == null) {
                stringArray2 = stringArray3;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                autoclassify.doAutoClassify(stringArray2[i], (String)object, n);
            }
            Autoclassify.println("");
            Autoclassify.println(autoclassify.getLocalizedUIString("prompt_stopped"));
            CSLog.log((int)0, (int)0, (String)Autoclassify.getLocalizedString("prompt_stopped"));
        }
        catch (Exception exception) {
            Autoclassify.println(exception.getMessage());
            CSLog.log((int)0, (int)0, (String)exception.getMessage());
            exception.printStackTrace();
        }
        if (autoclassify != null) {
            autoclassify.shutdown();
        }
    }

    class CreateClassMap
    implements RDMCallback {
        Map classMap = null;

        public CreateClassMap(Map map) {
            this.classMap = map;
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            if (rDMClassification.getId() == "ROOT") {
                return;
            }
            String string = rDMClassification.getMatchingRule();
            if (string == null) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("RULE", string.trim());
            this.classMap.put(rDMClassification.getId(), hashMap);
        }
    }
}

