/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ValidationException;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFException;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TaxonomyTreeModel
extends TreeModelBase
implements Serializable {
    public Locale userLocale = Locale.getDefault();
    public static final String FIELD_ID = "Id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CONCEPTS = "concepts";
    public static final String FIELD_FILES = "files";
    public static final String FIELD_VIEWBEAN_CLASS = "viewbean";
    public static final String MODEL_NAME = "TaxonomyTreeModel";
    private String name;
    private RDMTaxonomy tax;
    private RDMClassification root;
    private String errorMsg = null;
    private String editErrorMsg = null;
    private boolean modified;
    private long lastModified;
    private Date lastActionDate;

    public TaxonomyTreeModel() {
        CSDebug.logln("TaxonomyTreeModel()");
        this.load();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void root() throws ModelControlException {
        try {
            this.setCurrentNode(this.root);
            this.setNodeLevel(0);
            this.setIterationComplete(false);
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - root() exception e=" + exception.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.default"));
        }
    }

    public void beforeRoot() throws ModelControlException {
        try {
            this.setNodeLevel(-1);
            this.setIterationComplete(false);
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - beforeRoot() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public String getNodeDesc(String string) throws ModelControlException {
        if (string != null) {
            RDMClassification rDMClassification = this.tax.find(string);
            try {
                if (rDMClassification != null) {
                    if (rDMClassification == this.root) {
                        return this.tax.getDescription();
                    }
                    return rDMClassification.getDescription();
                }
                CSDebug.logln("TaxonomyTreeModel - getNodeDesc(" + string + ") - didn't find the node in tree");
                return null;
            }
            catch (Exception exception) {
                CSDebug.logln("TaxonomyTreeModel - getNodeDesc(" + string + ") exception e=" + exception.getMessage());
                throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
            }
        }
        return null;
    }

    public String getNodeRule(String string) throws ModelControlException {
        if (string != null) {
            RDMClassification rDMClassification = this.tax.find(string);
            try {
                if (rDMClassification != null) {
                    if (rDMClassification == this.root) {
                        return null;
                    }
                    return rDMClassification.getMatchingRule();
                }
                CSDebug.logln("TaxonomyTreeModel - getNodeRule(" + string + ") - didn't find the node in tree");
                return null;
            }
            catch (Exception exception) {
                CSDebug.logln("TaxonomyTreeModel - getNodeDesc(" + string + ") exception e=" + exception.getMessage());
                throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
            }
        }
        return null;
    }

    public String getNodeName(String string) throws ModelControlException {
        if (string != null) {
            RDMClassification rDMClassification = this.tax.find(string);
            try {
                if (rDMClassification != null) {
                    if (rDMClassification.getParent() == null) {
                        return this.tax.getId();
                    }
                    return rDMClassification.getId();
                }
                CSDebug.logln("TaxonomyTreeModel - getNodeDesc(" + string + ") - didn't find the node in tree");
                return null;
            }
            catch (Exception exception) {
                CSDebug.logln("TaxonomyTreeModel - getNodeName(" + string + ") exception e=" + exception.getMessage());
                throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
            }
        }
        return null;
    }

    public String getNodeName() throws ModelControlException {
        RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
        try {
            if (rDMClassification != null) {
                if (rDMClassification.getParent() == null) {
                    return this.tax.getId();
                }
                return rDMClassification.getId();
            }
            return null;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getNodeName() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public String getNodeType() throws ModelControlException {
        try {
            String string = null;
            string = this.isParentNode() ? "Parent" : "Leaf";
            return string;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getNodeType() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public RDMClassification getNode(String string) {
        try {
            RDMClassification rDMClassification = this.tax.find(string);
            return rDMClassification;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getNode(" + string + ") exception e=" + exception.getMessage());
            return null;
        }
    }

    public Object getCurrentNode() {
        try {
            Object object = super.getCurrentNode();
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setCurrentNode(String string) throws ModelControlException {
        try {
            this.setCurrentNode(this.getNode(string));
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - setCurrentNode(" + string + ") exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public String getNodeID() {
        RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
        try {
            if (rDMClassification != null) {
                return TaxonomyTreeModel.hashNodeId(rDMClassification.getId());
            }
            return null;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getNodeID() exception e=" + exception.getMessage());
            return null;
        }
    }

    public boolean isParentNode(String string) {
        if (string != null) {
            try {
                RDMClassification rDMClassification = this.tax.find(string);
                if (rDMClassification != null) {
                    return rDMClassification.nChildren() > 0;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean isParentNode() {
        try {
            RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
            if (rDMClassification != null) {
                return rDMClassification.nChildren() > 0;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - isParentNode() exception e=" + exception.getMessage());
            return false;
        }
    }

    public boolean isChildNode() {
        RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
        try {
            if (rDMClassification != null) {
                return rDMClassification.getParent() != null;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - isChildNode() exception e=" + exception.getMessage());
            return false;
        }
    }

    public boolean isLastChild(RDMClassification rDMClassification, RDMClassification rDMClassification2) throws ModelControlException {
        try {
            int n = rDMClassification.nChildren() - 1;
            return rDMClassification.nthChild(n) == rDMClassification2;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - isLastChild(" + rDMClassification + "," + rDMClassification2 + ") failed");
            throw new ModelControlException("failed to verify if currentNode is last child");
        }
    }

    public boolean isLastChild() throws ModelControlException {
        return this.isLastChild(((RDMClassification)this.getCurrentNode()).getParent(), (RDMClassification)this.getCurrentNode());
    }

    public boolean firstChild() throws ModelControlException {
        try {
            RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
            if (rDMClassification != null && this.isParentNode()) {
                this.setCurrentNode(rDMClassification.getChildren().get(0));
                this.incrementNodeLevel();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - firstChild() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public List getChildren(String string) {
        if (string != null) {
            try {
                RDMClassification rDMClassification = this.tax.find(string);
                return rDMClassification.getChildren();
            }
            catch (Exception exception) {
                CSDebug.logln("TaxnomyTreeModel - getChildren() exception retrieveing childrens");
                return null;
            }
        }
        return null;
    }

    public boolean parent() throws ModelControlException {
        try {
            RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
            if (rDMClassification != null && this.isChildNode()) {
                this.setCurrentNode(rDMClassification.getParent());
                this.decrementNodeLevel();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - parent() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public boolean nextSibling() throws ModelControlException {
        try {
            RDMClassification rDMClassification;
            RDMClassification rDMClassification2 = (RDMClassification)this.getCurrentNode();
            if (rDMClassification2 != null && (rDMClassification = rDMClassification2.getParent()) != null) {
                int n = rDMClassification.getChildren().indexOf(rDMClassification2);
                if (++n < rDMClassification.nChildren()) {
                    this.setCurrentNode(rDMClassification.nthChild(n));
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - nextSibling() exception e=" + exception.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public Object getValue(String string) {
        try {
            Object[] objectArray = this.getValues(string);
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            return objectArray[0];
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getValue(" + string + ") exception e=" + exception.getMessage());
            return null;
        }
    }

    public void setValue(String string, Object object) throws ValidationException {
        try {
            this.setValues(string, new Object[]{object});
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getValue(" + string + "," + object + ") exception e=" + exception.getMessage());
            throw new ValidationException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public Object[] getValues(String string) {
        try {
            RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
            if (rDMClassification != null) {
                String string2 = null;
                string2 = string.compareTo(FIELD_NAME) == 0 ? (rDMClassification.getParent() == null ? this.tax.getId() : rDMClassification.getSubcategory()) : rDMClassification.getSOIF().getValue(string);
                return new Object[]{string2};
            }
            return null;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getValues(" + string + ") exception e=" + exception.getMessage());
            throw new ValidationException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public void setValues(String string, Object[] objectArray) throws ValidationException {
        try {
            RDMClassification rDMClassification = (RDMClassification)this.getCurrentNode();
            if (rDMClassification != null) {
                if (rDMClassification.getParent() == null) {
                    this.tax.getSOIF().replace(string, (String)objectArray[0]);
                } else {
                    rDMClassification.getSOIF().replace(string, (String)objectArray[0]);
                }
            }
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - setValues(" + string + ",...) exception e=" + exception.getMessage());
            throw new ValidationException("TaxonomyTreeModel exception e=" + exception.getMessage());
        }
    }

    public void deleteNode(String string) throws ModelControlException {
        try {
            RDMClassification rDMClassification = this.tax.find(string);
            if (rDMClassification != null) {
                RDMClassification rDMClassification2 = rDMClassification.getParent();
                if (rDMClassification2 != null) {
                    int n = rDMClassification.getNumDescendant();
                    int n2 = rDMClassification2.nChildren();
                    int n3 = rDMClassification2.getChildren().indexOf(rDMClassification);
                    rDMClassification2.getChildren().remove(n3);
                    Collections.sort(rDMClassification2.getChildren());
                    boolean bl = false;
                    for (RDMClassification rDMClassification3 = rDMClassification2; rDMClassification3 != null; rDMClassification3 = rDMClassification3.getParent()) {
                        int n4 = rDMClassification3.getNumDescendant();
                        rDMClassification3.setNumDescendant(n4 - (n + 1));
                    }
                } else {
                    try {
                        this.tax = new RDMTaxonomy(this.getLocalizedString("category.edit.default_taxonomy_name"));
                        this.root = this.tax.find("ROOT");
                    }
                    catch (Exception exception) {
                        throw new ModelControlException(this.getLocalizedString("category.edit.error.delete") + " " + string + " " + this.getLocalizedString("category.edit.error.delete_not_found"));
                    }
                }
            } else {
                CSDebug.logln("TaxonomyTreeModel - deleteNode(" + string + ") not found");
                throw new ModelControlException(this.getLocalizedString("category.edit.error.delete_default"));
            }
            this.setModifiedState(true);
        }
        catch (NullPointerException nullPointerException) {
            CSDebug.logln("TaxonomyTreeModel - deleteNode(" + string + ",...) exception e=" + nullPointerException.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.delete_default"));
        }
    }

    public int nChildren(String string) {
        try {
            RDMClassification rDMClassification = this.tax.find(string);
            return rDMClassification.nChildren();
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - nChildren(" + string + ") got exception e=" + exception.getMessage());
            return -1;
        }
    }

    public int getNumDescendant(String string) {
        try {
            RDMClassification rDMClassification = this.tax.find(string);
            return rDMClassification.getNumDescendant();
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - getNumDescendant(" + string + ") got exception e=" + exception.getMessage());
            return -1;
        }
    }

    public void insertChildNode(String string, String string2, String string3, String string4) throws ModelControlException {
        try {
            if (this.tax == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add_child") + " " + string2);
            }
            RDMClassification rDMClassification = this.tax.find(string);
            this.insertChildNode(rDMClassification, string2, string3, string4);
        }
        catch (ModelControlException modelControlException) {
            throw modelControlException;
        }
        catch (NullPointerException nullPointerException) {
            CSDebug.logln("TaxonomyTreeModel - insertChildNode(" + string + "," + string2 + "," + string3 + ") exception e=" + nullPointerException.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_default"));
        }
    }

    public void insertSiblingNode(String string, String string2, String string3, String string4) throws ModelControlException {
        try {
            if (this.tax == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add_sibling") + " " + string2);
            }
            RDMClassification rDMClassification = this.tax.find(string).getParent();
            this.insertChildNode(rDMClassification, string2, string3, string4);
        }
        catch (ModelControlException modelControlException) {
            throw modelControlException;
        }
        catch (NullPointerException nullPointerException) {
            CSDebug.logln("TaxonomyTreeModel - insertSiblingNode(" + string + "," + string2 + "," + string3 + ") exception e=" + nullPointerException.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_sibling") + " " + string2 + " " + this.getLocalizedString("category.edit.error.add_sibling_to") + " " + string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertChildNode(RDMClassification rDMClassification, String string, String string2, String string3) throws ModelControlException {
        try {
            String string4 = null;
            string4 = rDMClassification == this.root ? string : rDMClassification.getId() + ":" + string;
            if (rDMClassification == null) throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + string4 + " " + this.getLocalizedString("category.edit.error.add_no_parent"));
            if (rDMClassification == this.root && (string.equals("ROOT") || string.equals(this.tax.getId()))) {
                if (!string.equals("ROOT")) throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_top_classification"));
                throw new ModelControlException(this.getLocalizedString("category.edit.error.root_child"));
            }
            if (this.tax.find(string4) != null) throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + string4 + " " + this.getLocalizedString("category.edit.error.add_exists"));
            RDMClassification rDMClassification2 = this.newChild(rDMClassification, string, string2, string3, rDMClassification.getTaxonomyId());
            if (rDMClassification2 == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + string4 + " " + this.getLocalizedString("category.edit.error.add_cannot_create"));
            }
            this.tax.insert(rDMClassification2);
            this.setModifiedState(true);
            return;
        }
        catch (NullPointerException nullPointerException) {
            CSDebug.logln("TaxonomyTreeModel - insertChildNode-RD(" + rDMClassification + "," + string + "," + string2 + ") failed adding child=" + string + " to the node " + rDMClassification.getId() + " cause is exception e=" + nullPointerException.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_default"));
        }
    }

    public void updateNode(String string, String string2, String string3, String string4) throws ModelControlException {
        block12: {
            try {
                if (string2.trim() != "") {
                    RDMClassification rDMClassification = this.tax.find(string);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (rDMClassification.getParentId() == null) {
                        this.updateTaxonomy(string2, string3);
                    } else {
                        if (rDMClassification.getParent() == this.root && (string2.equals(this.tax.getId()) || string2.equals("ROOT"))) {
                            if (string2.equals("ROOT")) {
                                throw new ModelControlException(this.getLocalizedString("category.edit.error.root_child"));
                            }
                            throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_taxonomy"));
                        }
                        if (string.indexOf(58) != -1) {
                            stringBuffer.append(string.substring(0, string.lastIndexOf(":")));
                            stringBuffer.append(":" + string2);
                        } else {
                            stringBuffer.append(string2);
                        }
                        boolean bl = false;
                        if (!string2.equals(TaxonomyTreeModel.lastNode(string))) {
                            RDMClassification rDMClassification2 = rDMClassification.getParent();
                            for (int i = 0; i < rDMClassification2.nChildren(); ++i) {
                                if (!rDMClassification2.nthChild(i).getId().equals(stringBuffer.toString())) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) {
                            throw new ModelControlException(this.getLocalizedString("category.edit.error.update") + " " + stringBuffer.toString() + " " + this.getLocalizedString("category.edit.error.add_exists"));
                        }
                        rDMClassification.setSubcategory(stringBuffer.toString());
                        this.recurseUpdateNode(rDMClassification, string, stringBuffer.toString());
                        rDMClassification.setDescription(string3);
                        rDMClassification.setMatchingRule(string4);
                        this.setModifiedState(true);
                    }
                    break block12;
                }
                throw new ModelControlException(this.getLocalizedString("category.edit.error.update") + " " + string + " " + this.getLocalizedString("category.edit.error.update_blank"));
            }
            catch (NullPointerException nullPointerException) {
                CSDebug.logln("TaxonomyTreeModel - udateNode() caught null pointer excpetion ");
                throw new ModelControlException(this.getLocalizedString("category.edit.error.update_default"));
            }
        }
    }

    public String getTaxonomyDescription() {
        if (this.tax != null) {
            return this.tax.getDescription();
        }
        return null;
    }

    public void updateTaxonomy(String string, String string2) throws ModelControlException {
        try {
            if (!string.trim().equals("")) {
                boolean bl = false;
                for (int i = 0; i < this.root.nChildren(); ++i) {
                    if (!this.root.nthChild(i).getId().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_taxonomy"));
                }
            } else {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.blank_taxonomy"));
            }
            this.recurseUpdateNodeTaxonomy(this.root, string);
            this.tax.setId(string);
            this.tax.setDescription(string2.trim());
            this.setModifiedState(true);
        }
        catch (NullPointerException nullPointerException) {
            throw new ModelControlException(this.getLocalizedString("category.edit.error.update_default"));
        }
    }

    public void recurseUpdateNodeTaxonomy(RDMClassification rDMClassification, String string) throws ModelControlException {
        try {
            rDMClassification.setTaxonomyId(string);
            for (int i = 0; i < rDMClassification.nChildren(); ++i) {
                this.recurseUpdateNodeTaxonomy(rDMClassification.nthChild(i), string);
            }
        }
        catch (NullPointerException nullPointerException) {
            String string2 = rDMClassification != null ? rDMClassification.getId() : "(rc is NULL)";
            CSDebug.logln("cannot recursivly update taxonomy for children of category " + string2);
            throw new ModelControlException("cannot recursively update Taxonomy on children of category " + string2);
        }
    }

    public void recurseUpdateNode(RDMClassification rDMClassification, String string, String string2) throws ModelControlException {
        try {
            CharSequence charSequence;
            CharSequence charSequence2;
            String string3 = rDMClassification.getId();
            if (string3.startsWith(string)) {
                charSequence2 = new StringBuffer(string2);
                charSequence = string3.substring(string.length());
                if (((String)charSequence).length() > 0) {
                    ((StringBuffer)charSequence2).append((String)charSequence);
                }
                rDMClassification.setId(((StringBuffer)charSequence2).toString());
            }
            if ((charSequence2 = rDMClassification.getParentId()) != null && ((String)charSequence2).startsWith(string)) {
                charSequence = new StringBuffer(string2);
                String string4 = ((String)charSequence2).substring(string.length());
                if (string4.length() > 0) {
                    ((StringBuffer)charSequence).append(string4);
                }
                rDMClassification.setParentId(((StringBuffer)charSequence).toString());
            }
            for (int i = 0; i < rDMClassification.nChildren(); ++i) {
                this.recurseUpdateNode(rDMClassification.nthChild(i), string, string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            CSDebug.logln("cannot recursivly update children of category " + string);
            throw new ModelControlException("cannot recursivly update children of category " + string);
        }
    }

    public ArrayList getDescendance(String string) throws ModelControlException {
        try {
            RDMClassification rDMClassification = this.tax.find(string);
            ArrayList arrayList = new ArrayList();
            this.getDescendance(rDMClassification, arrayList);
            return arrayList;
        }
        catch (Exception exception) {
            throw new ModelControlException("Cannot get the descendance of node=" + string);
        }
    }

    private void getDescendance(RDMClassification rDMClassification, ArrayList arrayList) {
        for (int i = 0; i < rDMClassification.nChildren(); ++i) {
            RDMClassification rDMClassification2 = rDMClassification.nthChild(i);
            arrayList.add(rDMClassification2.getId());
            this.getDescendance(rDMClassification2, arrayList);
        }
    }

    public static String lastNode(String string) {
        try {
            int n;
            String string2 = null;
            string2 = string != null ? ((n = string.lastIndexOf(58)) > 0 ? string.substring(n + 1) : string) : null;
            return string2;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel - insertChildNode-RD(" + string + ") exception e=" + exception.getMessage());
            return null;
        }
    }

    public void load() {
        try {
            this.setErrorMsg(null);
            this.tax = null;
            this.root = null;
            String string = SearchConfig.getValue((String)"taxonomy-description");
            SOIFInputStream sOIFInputStream = new SOIFInputStream(string, "UTF-8");
            this.tax = new RDMTaxonomy(sOIFInputStream);
            if (this.tax == null) {
                this.root = null;
                CSDebug.logln("TaxonomyTreeModel - load() - cannot load Taxonomy");
            } else {
                this.root = this.tax.find("ROOT");
                if (this.root == null) {
                    CSDebug.logln("TaxonomyTreeModel - load() - cannot find the root category in loaded Taxonomy");
                    this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
                }
                this.setErrorMsg(null);
                this.setModifiedState(false);
                this.setTimeStamp();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.missing_config_file"));
            CSDebug.logln("TaxonomyTreeModel load() fileNotFoundException fnf=" + fileNotFoundException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            CSDebug.logln("TaxonomyTreeModel load() UnsupportedEncodingException ue=" + unsupportedEncodingException.getMessage());
        }
        catch (SOIFException sOIFException) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            CSDebug.logln("TaxonomyTreeModel load() SOIFException se=" + sOIFException.getMessage());
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.indexOf(SOIF.INVALIDSOIF) != -1) {
                this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            } else {
                this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
            }
            CSDebug.logln("TaxonomyTreeModel load() Exception e=" + exception.getMessage());
        }
    }

    RDMClassification newChild(RDMClassification rDMClassification, String string, String string2, String string3, String string4) {
        try {
            if (string.trim() != "") {
                String string5 = rDMClassification.getId();
                String string6 = string5.equals("ROOT") ? string : string5 + ":" + string;
                RDMClassification rDMClassification2 = new RDMClassification(string6);
                rDMClassification2.setTaxonomyId(string4);
                rDMClassification2.setParentId(string5);
                rDMClassification2.setDescription(string2);
                rDMClassification2.setMatchingRule(string3);
                return rDMClassification2;
            }
            return null;
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel newChild() exception e=" + exception.getMessage());
            return null;
        }
    }

    public void save() throws ModelControlException {
        String string = CSConfig.getServerRoot();
        try {
            SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(SearchConfig.getValue((String)"taxonomy-description"), "UTF-8");
            sOIFOutputStream.write(this.tax.getSOIF());
            sOIFOutputStream.flush();
            this.write(sOIFOutputStream);
            sOIFOutputStream.flush();
            sOIFOutputStream.close();
            if (!DBUtil.indexCategories(CSConfig.getServerRoot())) {
                CSDebug.logln("TaxonomyTreeModel save() - failed to reindex categories");
            }
            this.setErrorMsg(null);
            this.setModifiedState(false);
            this.setTimeStamp();
            CSConfig.loadTaxonomy();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.missing_config_file"));
            CSDebug.logln("TaxonomyTreeModel save() fileNotFoundException fnf=" + fileNotFoundException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            CSDebug.logln("TaxonomyTreeModel save() UnsupportedEncodingException ue=" + unsupportedEncodingException.getMessage());
        }
        catch (Exception exception) {
            CSDebug.logln("TaxonomyTreeModel save() exception e=" + exception.getMessage());
            this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
        }
    }

    public boolean getModifiedState() {
        return this.modified;
    }

    private void setModifiedState(boolean bl) {
        this.modified = bl;
        this.lastActionDate = new Date();
    }

    public void write(SOIFOutputStream sOIFOutputStream) {
        this.write(sOIFOutputStream, this.root);
    }

    private void write(SOIFOutputStream sOIFOutputStream, RDMClassification rDMClassification) {
        try {
            Object var3_3 = null;
            if (rDMClassification != this.root) {
                sOIFOutputStream.write(rDMClassification.getSOIF());
            }
            if (rDMClassification.getNumDescendant() != 0) {
                for (int i = 0; i < rDMClassification.nChildren(); ++i) {
                    this.write(sOIFOutputStream, rDMClassification.nthChild(i));
                }
            }
        }
        catch (IOException iOException) {
            CSDebug.logln("TaxonomyTreeModel.dump() - caught IOException");
        }
    }

    public void dump(RDMClassification rDMClassification) {
        CSDebug.logln("TaxonomyTreeModel - dumping ----------------------------- taxonomy=" + this.tax.getId());
        this.dumpChildren(rDMClassification, 0);
    }

    public void dumpChildren(RDMClassification rDMClassification, int n) {
        try {
            int n2;
            StringBuffer stringBuffer = new StringBuffer("level(" + rDMClassification.getDepth() + "):");
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append("  ");
            }
            CSDebug.logln(stringBuffer.toString() + new String(rDMClassification.getSOIF().toByteArray()));
            if (rDMClassification.getNumDescendant() != 0) {
                for (n2 = 0; n2 < rDMClassification.nChildren(); ++n2) {
                    this.dumpChildren(rDMClassification.nthChild(n2), n + 1);
                }
            }
        }
        catch (IOException iOException) {
            CSDebug.logln("TaxonomyTreeModel.dump() - caught IOException");
        }
    }

    public RDMClassification getRoot() {
        return this.root;
    }

    public String getLocalizedString(String string) {
        return SearchResource.geti18nString(string, this.userLocale);
    }

    public boolean isConfigNewer() throws ModelControlException {
        try {
            File file = new File(SearchConfig.getValue((String)"taxonomy-description"));
            if (this.getTimeStamp() < file.lastModified() && this.getTimeStamp() != 0L) {
                CSDebug.logln("TaxonomyTreeModel - isConfigNewer() - on file taxonomy(" + file.lastModified() + ") is newer than model (" + this.getTimeStamp() + ")");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("Failed to verify if taxonomy config file is newer than the TaxonomyTreeModel model");
            throw new ModelControlException(this.getLocalizedString("category.edit.warning.config_timestamp"));
        }
    }

    public static String hashNodeId(String string) {
        if (string != null) {
            return String.valueOf(string.hashCode());
        }
        CSDebug.logln("Failed to get the hashCode for <NULL> node");
        return null;
    }

    public void setErrorMsg(String string) {
        this.errorMsg = string;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Date getLastActionDate() {
        return this.lastActionDate;
    }

    private void setLastActionDate(long l) {
        this.lastActionDate = new Date(l);
    }

    private long getTimeStamp() {
        return this.lastModified;
    }

    private void setTimeStamp() {
        try {
            File file = new File(SearchConfig.getValue((String)"taxonomy-description"));
            this.lastModified = file.lastModified();
            this.setLastActionDate(this.lastModified);
        }
        catch (Exception exception) {
            CSDebug.logln("failed to set the timestamp of the config file in the model's e=" + exception.getMessage());
            this.setErrorMsg(this.getLocalizedString("category.edit.warning.config_timestamp"));
        }
    }

    public boolean isValidName(String string) throws ModelControlException {
        if (string != null) {
            String string2 = string.trim();
            if (string2.length() != 0) {
                if (string2.indexOf(58) == -1 && string2.indexOf(59) == -1 && string2.indexOf(60) == -1 && string2.indexOf(62) == -1 && string2.indexOf(34) == -1 && string2.indexOf(92) == -1) {
                    return true;
                }
                throw new ModelControlException(this.getLocalizedString("category.edit.error.invalid_name"));
            }
            throw new ModelControlException(this.getLocalizedString("category.edit.error.invalid_name"));
        }
        throw new ModelControlException(this.getLocalizedString("category.edit.error.blank_taxonomy"));
    }
}

