/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.Locale;

public class FiltersListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    private RobotConfig rc = null;
    public static final String FIELD_ENABLE = "Enable";
    public static final String FIELD_ID = "FilterID";
    public static final String FIELD_NICKNAME = "NickName";
    public static final String FIELD_DEFAULT = "Default";
    public static final String FIELD_DELETE = "Delete";
    public static final String FIELD_USEDINSITES = "UsedInSites";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    public Locale userLocale = Locale.getDefault();

    public FiltersListModel() {
        this.rc = CSConfig.getRobotConfig();
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("FilterListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("update")) {
            object = this.update(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            FilterRule filterRule = this.rc.GetRuleByIndex(this.getLocation());
            if (filterRule == null) continue;
            String string = (String)this.getValue(FIELD_ENABLE);
            filterRule.enable = string.compareTo(ENABLE_VALUES[0]) == 0;
        }
        this.rc.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        int n;
        CSDebug.logln("FiltersListModel.delete");
        this.beforeFirst();
        String[] stringArray = new String[this.getSize()];
        while (this.next()) {
            FilterRule filterRule;
            n = this.getLocation();
            String string = (String)this.getValue(FIELD_DELETE);
            stringArray[n] = null;
            if (string.compareTo("true") != 0 || (filterRule = this.rc.GetRuleByIndex(n)) == null) continue;
            stringArray[n] = filterRule.id;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            this.rc.delRule(stringArray[n]);
        }
        this.rc.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.clear();
        int n = this.rc.numOfRules();
        for (int i = 0; i < n; ++i) {
            FilterRule filterRule = this.rc.GetRuleByIndex(i);
            if (filterRule == null) continue;
            this.appendRow();
            this.setValue(FIELD_ENABLE, filterRule.enable ? ENABLE_VALUES[0] : ENABLE_VALUES[1]);
            this.setValue(FIELD_ID, filterRule.id);
            this.setValue(FIELD_DEFAULT, filterRule.quickcf ? SearchResource.geti18nString("filter.quikcf", this.userLocale) : "");
            String string = SearchResource.geti18nString(filterRule.nickname, this.userLocale, false);
            if (string != null) {
                this.setValue(FIELD_NICKNAME, string);
            } else {
                this.setValue(FIELD_NICKNAME, filterRule.nickname);
            }
            this.setValue(FIELD_DELETE, "false");
            String[] stringArray = this.rc.getFiletrRulesetIDsForFilterRule(filterRule.id);
            if (stringArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < stringArray.length; ++j) {
                    FilterRuleset filterRuleset = this.rc.GetRuleSet(stringArray[j]);
                    stringBuffer.append("<a href=\"Site?id=" + filterRuleset.id + "\">" + filterRuleset.nickname + "</a>");
                    if (j >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                CSDebug.logln(stringBuffer.toString());
                this.setValue(FIELD_USEDINSITES, stringBuffer.toString());
                continue;
            }
            this.setValue(FIELD_USEDINSITES, "");
        }
        this.beforeFirst();
        return null;
    }
}

