/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.ArrayList;

public class FilterGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_MATCH = "Match";
    public static final String FIELD_RULE = "Rule";
    public static final String FIELD_DELETE = "Delete";

    public FilterGroupListModel() {
        CSDebug.logln("FilterGroupListModel()");
    }

    public void setID(String string) {
        this.rulesetID = string;
    }

    public void setDelIndex(int n) {
        this.delIndex = n;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_MATCH) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("FilterGroupListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("insert")) {
            object = this.insert(modelExecutionContext);
        } else if (string.equals("update")) {
            object = this.update(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln("FilterGroupListModel.update()");
        this.beforeFirst();
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            filterRuleset.removeFilters();
            while (this.next()) {
                String string = (String)this.getValue(FIELD_RULE);
                String string2 = (String)this.getValue(FIELD_MATCH);
                if (string == null || string.trim().length() <= 0) continue;
                CSDebug.logln("Adding filter:ID=" + string + " onMatch=" + string2);
                filterRuleset.AddFilter(string, RobotConfig.ADStringtoBoolean(string2));
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            this.setValue(FIELD_MATCH, RobotConfig.BtoString(filterRuleset.onMatch));
        }
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String string = (String)this.getValue(FIELD_DELETE);
            if (string == null || string.compareTo("true") != 0) continue;
            int n = this.getRowIndex();
            arrayList.add(this.getCurrentContext().getValueList().get(n));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getCurrentContext().getValueList().remove(arrayList.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("FilterGroupModel.retrieve");
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            this.clear();
            int n = filterRuleset.numOfFilters();
            for (int i = 0; i < n; ++i) {
                String string = filterRuleset.getFiltersIDByIndex(i);
                String string2 = filterRuleset.getFiltersonMatchByIndex(i);
                this.appendRow();
                this.setValue(FIELD_RULE, string);
                this.setValue(FIELD_MATCH, string2);
            }
        }
        this.beforeFirst();
        return null;
    }
}

