/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.cli;

import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.jsp.JspWriter;

public class RunImportAgent {
    public static final String IMPORTMGR_CMD = "importmgr";
    private String[] r_env = null;
    private boolean isValid = false;
    private boolean isRunning = false;
    private boolean isQuery = false;
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    private String binDir = "";
    private String libDir = "";
    private String libPath = "";
    private String serverRoot = "";
    private String configDir = "";
    private String logDir = "";
    private boolean wait = true;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage:RunImportAgent server_root action");
            return;
        }
        CSConfig.init(stringArray[0]);
        RunImportAgent runImportAgent = new RunImportAgent(CSConfig.getServerRoot(), CSConfig.getBinPath(), CSConfig.getLibDir(), CSConfig.getLibPath(), null, null);
        runImportAgent.command(stringArray[1]);
    }

    public RunImportAgent(String string, String string2, String string3, String string4, String string5, String string6) {
        SearchConfig searchConfig = SearchConfig.getSearchConfig();
        if (string != null) {
            this.serverRoot = string;
            if (string2 != null) {
                this.binDir = string2;
            }
            if (string4 != null) {
                this.libPath = string4;
            }
            if (string3 != null) {
                this.libDir = string3;
            }
        } else {
            this.serverRoot = CSConfig.getServerRoot();
            this.binDir = CSConfig.getBinPath();
            this.libDir = CSConfig.getLibDir();
            this.libPath = CSConfig.getLibPath();
        }
        this.configDir = string5 != null ? string5 : this.serverRoot + File.separator + "config";
        this.logDir = string6 != null ? string6 : this.serverRoot + File.separator + "logs";
        this.r_env = RunImportAgent.isWindows() ? new String[6] : new String[5];
        this.r_env[0] = "LD_LIBRARY_PATH=" + this.libPath;
        this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
        this.r_env[2] = "CS_LOGDIR=" + this.logDir;
        this.r_env[3] = "PATH=" + this.libPath + ":" + this.binDir;
        this.r_env[4] = "CAT_SERVER_ROOT=" + this.serverRoot;
        if (RunImportAgent.isWindows()) {
            String string7;
            String string8;
            String string9 = "C:\\WINNT";
            if (System.getProperty("os.name").equals("Windows XP")) {
                string9 = "C:\\WINDOWS";
            }
            if ((string8 = System.getProperty(string7 = "COMSPEC")) == null || "".equals(string8.trim())) {
                string8 = string9 + "\\system32\\cmd.exe";
            }
            this.r_env[5] = string7 + "=" + string8;
        }
    }

    public void command(String string) {
        if (string.compareToIgnoreCase("Run") == 0) {
            this.run(null);
        }
    }

    public synchronized void run(JspWriter jspWriter) {
        CSDebug.logln("Starting importmgr");
        SearchConfig.getSearchConfig();
        String string = SearchConfig.getValue((String)"csid");
        String string2 = this.libDir + File.separator + IMPORTMGR_CMD + " -c " + this.configDir + File.separator + "search.conf" + " " + string + " run all";
        String[] stringArray = new String[6];
        stringArray[0] = this.libDir + File.separator + IMPORTMGR_CMD;
        stringArray[1] = "-c";
        stringArray[2] = this.configDir + File.separator + "search.conf";
        stringArray[3] = string;
        stringArray[4] = "run";
        stringArray[5] = "all";
        String[] stringArray2 = stringArray;
        CSDebug.logln("cmd=" + string2);
        Runtime runtime = Runtime.getRuntime();
        try {
            if (jspWriter != null) {
                jspWriter.flush();
            }
            Process process = runtime.exec(stringArray2, this.r_env);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (jspWriter == null) continue;
                jspWriter.println(string3);
                jspWriter.flush();
            }
        }
        catch (IOException iOException) {
            CSDebug.logln("rt.exec Exception:" + iOException.getMessage());
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

