/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.util.PBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImportConfig {
    public static final String QL_GATHERER = "gatherer";
    public static final String QL_COMPASS = "compass";
    public static final String QL_SEARCH = "search";
    public static final String TYPE_LOCALFILE = "localfile";
    public static final String TYPE_COMPASS = "cs";
    public static final String CONFDIR = "config";
    public static final String IMPORT_CONF = "import.conf";
    static final String header = "# Written automatically by importmgr -- DO NOT EDIT";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CSID = "csid";
    public static final String SEARCH_URI = "search-uri";
    public static final String SEARCH_DB = "search-db";
    public static final String LOCAL_DB = "local-db";
    public static final String USE_RDM_INCOMING = "use-rdm-incoming";
    public static final String SRCFILE = "srcfile";
    public static final String RDM_QUERY_LANGUAGE = "rdm-query-language";
    public static final String DESTINATION_CSID = "destination-csid";
    public static final String ENABLE = "enable";
    public static final String TIME_STAMP = "last-collection-time";
    public static final String EMAIL = "email";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String VIEW_ATTRIBUTES = "view-attributes";
    public static final String VIEW_HITS = "view-hits";
    public static final String VIEW_ORDER = "view-order";
    public static final String SCOPE = "scope";
    public static final String NICKNAME = "nickname";
    public static final String TIMEOUT = "timeout";
    private static final String[] use4equalFields = new String[]{"csid", "local-db", "srcfile", "rdm-query-language", "view-attributes", "scope"};
    public static final String US_AUTH = "use-auth";
    public static final String AGENT_TYPE = "agent-type";
    public static final String SERVER_PORT = "server";
    public static final String INSTANCE_NAME = "instance-name";
    public static final String IS_SSL = "is-ssl";
    public static final String IS_COMPASS = "is-compass";
    public static final String CHARSET = "charset";
    HashMap valuesMap = new HashMap();
    int id = 0;
    static int lastID = 0;
    static long fileLastModified = 0L;
    static String default_csid;
    static String fileName;
    static ArrayList importAgents;
    static HashMap importAgentsMap;

    public static void main(String[] stringArray) {
        try {
            ImportConfig.init(stringArray[0]);
        }
        catch (Exception exception) {
            CSDebug.logln("Exception:" + exception.getMessage());
        }
        ImportConfig.updateFile(stringArray[0] + ".new");
    }

    private ImportConfig(int n, HashMap hashMap) {
        this.id = n;
        this.valuesMap = hashMap;
    }

    public static void init(String string) throws Exception {
        fileName = string;
        try {
            File file = new File(string);
            fileLastModified = file.lastModified();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string2 = bufferedReader.readLine();
            boolean bl = false;
            HashMap hashMap = null;
            while (string2 != null) {
                String string3;
                String string4 = string2.trim();
                if (bl) {
                    if (string4.startsWith("</Import>")) {
                        string3 = (String)hashMap.get(ID);
                        if (string3 != null) {
                            int n = Integer.parseInt(string3);
                            if (n > lastID) {
                                lastID = n;
                            }
                            ImportConfig importConfig = new ImportConfig(Integer.parseInt(string3), hashMap);
                            importAgents.add(importConfig);
                            importAgentsMap.put(string3, importConfig);
                            bl = false;
                        }
                    } else {
                        if (string4.startsWith("#")) {
                            string2 = bufferedReader.readLine();
                            continue;
                        }
                        PBlock.str2pblock((String)string4, (Map)hashMap);
                    }
                } else if (string4.startsWith("<Import ") && string4.endsWith(">")) {
                    bl = true;
                    hashMap = new HashMap();
                    string3 = string4.substring(8, string4.length() - 1);
                    PBlock.str2pblock((String)string3, hashMap);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void reInit() {
        try {
            File file = new File(fileName);
            long l = file.lastModified();
            if (l <= fileLastModified) {
                return;
            }
            lastID = 0;
            importAgents.clear();
            importAgentsMap.clear();
            ImportConfig.init(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateFile() {
        ImportConfig.updateFile(fileName);
    }

    public static void updateFile(String string) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")), true);
            printWriter.println(header);
            for (int i = 0; i < importAgents.size(); ++i) {
                ImportConfig importConfig = (ImportConfig)importAgents.get(i);
                importConfig.print(printWriter);
                printWriter.println();
            }
            printWriter.close();
            File file = new File(string);
            fileLastModified = file.lastModified();
        }
        catch (Exception exception) {
            return;
        }
    }

    public static synchronized ImportConfig newImportAgent() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = lastID + 1;
        hashMap.put(ID, Integer.toString(n));
        ImportConfig importConfig = new ImportConfig(n, hashMap);
        ++lastID;
        return importConfig;
    }

    public static boolean addImportAgent(ImportConfig importConfig) {
        for (int i = 0; i < importAgents.size(); ++i) {
            ImportConfig importConfig2 = (ImportConfig)importAgents.get(i);
            if (!importConfig2.isEqualTo(importConfig)) continue;
            return false;
        }
        importAgents.add(importConfig);
        importAgentsMap.put(Integer.toString(importConfig.id), importConfig);
        return true;
    }

    public static ArrayList getImportAgents() {
        ImportConfig.reInit();
        return importAgents;
    }

    public static ImportConfig getImportConfigByIndex(int n) {
        ImportConfig.reInit();
        if (n >= 0 && n < importAgents.size()) {
            return (ImportConfig)importAgents.get(n);
        }
        return null;
    }

    public static boolean DeleteImportConfigByIndex(int n) {
        ImportConfig importConfig;
        return n >= 0 && n < importAgents.size() && (importConfig = (ImportConfig)importAgents.remove(n)) != null && importAgentsMap.remove(importConfig.getValue(ID)) != null;
    }

    public static boolean DeleteImportConfigByID(String string) {
        ImportConfig importConfig = (ImportConfig)importAgentsMap.remove(string);
        if (importConfig != null) {
            importAgents.remove(importConfig);
            return true;
        }
        return false;
    }

    public static ImportConfig getImportConfigByID(String string) {
        ImportConfig.reInit();
        return (ImportConfig)importAgentsMap.get(string);
    }

    public static int numOfImportConfig() {
        ImportConfig.reInit();
        return importAgents.size();
    }

    public void setDefault(String string) {
        default_csid = string;
    }

    public String getDefault() {
        return default_csid;
    }

    public String getID() {
        return this.getValue(ID);
    }

    public String getValue(String string) {
        if (string.compareToIgnoreCase(RDM_QUERY_LANGUAGE) == 0) {
            String string2 = (String)this.valuesMap.get(RDM_QUERY_LANGUAGE);
            if (string2 != null && string2.compareTo(QL_GATHERER) != 0) {
                return QL_SEARCH;
            }
            return QL_GATHERER;
        }
        if (string.compareToIgnoreCase(US_AUTH) == 0) {
            String string3 = (String)this.valuesMap.get(USER);
            if (string3 != null) {
                return "true";
            }
            return "false";
        }
        if (string.compareToIgnoreCase(AGENT_TYPE) == 0) {
            String string4 = (String)this.valuesMap.get(CSID);
            if (string4 != null && string4.length() > 0) {
                return TYPE_COMPASS;
            }
            return TYPE_LOCALFILE;
        }
        if (string.compareToIgnoreCase(SERVER_PORT) == 0) {
            String string5 = (String)this.valuesMap.get(CSID);
            if (string5 != null && string5.length() > 0) {
                int n = string5.indexOf("//") + 2;
                int n2 = string5.lastIndexOf(47);
                return string5.substring(n, n2);
            }
            return "";
        }
        if (string.compareToIgnoreCase(INSTANCE_NAME) == 0) {
            String string6 = (String)this.valuesMap.get(CSID);
            if (string6 != null && string6.length() > 0) {
                int n = string6.lastIndexOf(47) + 1;
                return string6.substring(n);
            }
            return "";
        }
        if (string.compareToIgnoreCase(IS_COMPASS) == 0) {
            String string7 = (String)this.valuesMap.get(USE_RDM_INCOMING);
            if (string7 != null) {
                return "true";
            }
            return "false";
        }
        if (string.compareToIgnoreCase(IS_SSL) == 0) {
            String string8 = (String)this.valuesMap.get(CSID);
            if (string8 != null && string8.length() > 0 && string8.startsWith("x-catalogs")) {
                return "true";
            }
            return "false";
        }
        return (String)this.valuesMap.get(string);
    }

    public void setValue(Object object, Object object2) {
        if (this.valuesMap != null) {
            if (this.valuesMap.containsKey(object)) {
                this.valuesMap.remove(object);
            }
            this.valuesMap.put(object, object2);
        }
    }

    public void remove(Object object) {
        if (this.valuesMap != null && this.valuesMap.containsKey(object)) {
            this.valuesMap.remove(object);
        }
    }

    public HashMap getMap() {
        return this.valuesMap;
    }

    public void print(PrintWriter printWriter) {
        String string = (String)this.valuesMap.get(ID);
        printWriter.println("<Import id=" + string + ">");
        Iterator iterator = this.valuesMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.compareToIgnoreCase(ID) == 0) continue;
            printWriter.println(string2 + "=\"" + (String)this.valuesMap.get(string2) + "\"");
        }
        printWriter.println("</Import>");
    }

    public boolean isEqualTo(ImportConfig importConfig) {
        for (int i = 0; i < use4equalFields.length; ++i) {
            String string = this.getValue(use4equalFields[i]);
            String string2 = importConfig.getValue(use4equalFields[i]);
            if (!(string == null && string != null || string != null && string2 == null) && (string == null || string2 == null || string.equals(string2))) continue;
            return false;
        }
        return true;
    }

    static {
        fileName = null;
        importAgents = new ArrayList();
        importAgentsMap = new HashMap();
    }
}

