/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class AdminMenu {
    private static HashMap menus = new HashMap();
    public static String default_menutext = "Server|Server,Robot|Control,Database|ImportAgents,Categories|Reindex,Reports|RobotAdvancedReport";
    public static String[] default_submenus = new String[]{"Settings|Server, Advanced|AdvancedLog", "Control, Sites|Sites, Filters|Filters, Crawling|Crawling, Indexing|Indexing, Simulator|Simulator, Site Probe|SiteProbe, Schedule|RobotSchedule", "Import|ImportAgents, Edit|RDEditor, Schema|SchemaEditor, Partition|Partition, Reindex|Reindex, Purge|Purge, Analysis|DbStat, Schedule|ImportSchedule", "Category Editor|TaxonomyEditor, Classification Rules Editor|RobotCnRules, Reindex|Reindex", "Starting Points|StartPoints, Excluded URLs|ExcludedURLs, Robot Advanced Reports|RobotAdvancedReport, View Log Files|Logs"};
    private MenuPair[] main_mps = null;
    private Hashtable sub_menus = null;
    private Hashtable sub2main = null;

    public static void main(String[] stringArray) {
        AdminMenu adminMenu = AdminMenu.getMenu(Locale.getDefault());
        for (int i = 0; i < adminMenu.main_mps.length; ++i) {
            System.out.println("menu:" + adminMenu.main_mps[i].name);
        }
    }

    public static AdminMenu getMenu(Locale locale) {
        AdminMenu adminMenu = (AdminMenu)menus.get(locale);
        if (adminMenu == null) {
            adminMenu = new AdminMenu(locale);
            menus.put(locale, adminMenu);
        }
        return adminMenu;
    }

    public AdminMenu(Locale locale) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("searchadminmenu", locale);
        }
        catch (Exception exception) {
            return;
        }
        this.sub_menus = new Hashtable();
        this.sub2main = new Hashtable();
        String string = resourceBundle.getString("csmenu.list");
        if (string != null) {
            this.main_mps = this.menuTexts2MenuPairArray(string);
            for (int i = 0; i < this.main_mps.length; ++i) {
                try {
                    string = resourceBundle.getString("submenu." + this.main_mps[i].handle);
                    if (string == null) continue;
                    MenuPair[] menuPairArray = this.menuTexts2MenuPairArray(string);
                    this.sub_menus.put(this.main_mps[i].handle, menuPairArray);
                    for (int j = 0; j < menuPairArray.length; ++j) {
                        this.sub2main.put(menuPairArray[j].handle, this.main_mps[i].handle);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            this.main_mps = this.menuTexts2MenuPairArray(default_menutext);
            for (int i = 0; i < this.main_mps.length; ++i) {
                MenuPair[] menuPairArray = this.menuTexts2MenuPairArray(default_submenus[i]);
                this.sub_menus.put(this.main_mps[i].handle, menuPairArray);
                for (int j = 0; j < menuPairArray.length; ++j) {
                    this.sub2main.put(menuPairArray[j].handle, this.main_mps[i].handle);
                }
            }
        }
    }

    protected MenuPair[] menuTexts2MenuPairArray(String string) {
        if (string != null && string.length() > 0) {
            MenuPair[] menuPairArray;
            ArrayList<MenuPair> arrayList = new ArrayList<MenuPair>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                menuPairArray = stringTokenizer.nextToken();
                MenuPair menuPair = new MenuPair((String)menuPairArray);
                arrayList.add(menuPair);
            }
            menuPairArray = new MenuPair[1];
            return arrayList.toArray(menuPairArray);
        }
        return null;
    }

    public int numOfMainMenu() {
        if (this.main_mps != null) {
            return this.main_mps.length;
        }
        return 0;
    }

    public int numOfSubMenu(String string) {
        MenuPair[] menuPairArray = (MenuPair[])this.sub_menus.get(string);
        if (menuPairArray != null) {
            return menuPairArray.length;
        }
        return 0;
    }

    public String getFirstSubHandle(String string) {
        MenuPair[] menuPairArray = (MenuPair[])this.sub_menus.get(string);
        if (menuPairArray != null && menuPairArray.length > 0) {
            return menuPairArray[0].handle;
        }
        return string;
    }

    public String getMainMenuTextByIndex(int n) {
        return this.main_mps[n].name;
    }

    public String getSubMenuTextByIndex(String string, int n) {
        MenuPair[] menuPairArray = (MenuPair[])this.sub_menus.get(string);
        return menuPairArray[n].name;
    }

    public String getSubMenuHandleByIndex(String string, int n) {
        MenuPair[] menuPairArray = (MenuPair[])this.sub_menus.get(string);
        if (menuPairArray != null) {
            return menuPairArray[n].handle;
        }
        return string;
    }

    public String getMainMenuHandleByIndex(int n) {
        return this.main_mps[n].handle;
    }

    private Object[] getSubList(String string) {
        if (this.sub_menus == null) {
            return null;
        }
        return (Object[])this.sub_menus.get(string);
    }

    public String getMainHandleBySubHandle(String string) {
        String string2 = (String)this.sub2main.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String menuURL(String string) {
        int n = string.indexOf(124);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String menuText(String string) {
        int n = string.indexOf(124);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    class MenuPair {
        String name = null;
        String handle = null;

        public MenuPair() {
        }

        public MenuPair(String string) {
            int n = string.indexOf(124);
            if (n > 0) {
                this.name = string.substring(0, n);
                this.handle = string.substring(n + 1).trim();
            } else {
                this.name = string.trim();
                this.handle = string.trim();
            }
        }
    }
}

