/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.util.DefaultErrorHandler;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.InputSource;

public class XMLSchemaLoader
implements XMLGrammarLoader {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/standard-uri-conformant"};
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource"};
    private boolean fIsCheckedFully = false;
    private boolean fAllowJavaEncodings = false;
    private boolean fStrictURI = false;
    private SymbolTable fSymbolTable = null;
    private XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    private XMLEntityResolver fEntityResolver = null;
    private XMLGrammarPool fGrammarPool = null;
    private String fExternalSchemas = null;
    private String fExternalNoNSSchema = null;
    private Object fJAXPSource = null;
    private Hashtable fJAXPCache;
    private Locale fLocale = Locale.getDefault();
    private XSDHandler fSchemaHandler;
    private XSGrammarBucket fGrammarBucket;
    private XSDeclarationPool fDeclPool = null;
    private SubstitutionGroupHandler fSubGroupHandler;
    private CMBuilder fCMBuilder;
    private boolean fJAXPProcessed = false;
    private XSDDescription fXSDDescription = new XSDDescription();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$xml$sax$InputSource;

    public XMLSchemaLoader() {
        this(new SymbolTable(), null, new XMLEntityManager(), null, null, null);
    }

    public void reset() {
        this.fGrammarBucket.reset();
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        if (this.fGrammarPool != null) {
            Grammar[] initialGrammars = this.fGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int i = 0;
            while (i < initialGrammars.length) {
                if (!this.fGrammarBucket.putGrammar((SchemaGrammar)initialGrammars[i], true)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                }
                ++i;
            }
            this.fCMBuilder.setDeclPool(null);
        } else {
            this.fDeclPool.reset();
            this.fCMBuilder.setDeclPool(this.fDeclPool);
        }
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityResolver, this.fSymbolTable, this.fGrammarPool, this.fAllowJavaEncodings, this.fStrictURI);
        if (this.fGrammarPool == null) {
            this.fDeclPool.reset();
            this.fSchemaHandler.setDeclPool(this.fDeclPool);
        } else {
            this.fSchemaHandler.setDeclPool(null);
        }
        this.fSubGroupHandler.reset();
        this.fJAXPProcessed = false;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        if (featureId.equals(SCHEMA_FULL_CHECKING)) {
            return this.fIsCheckedFully;
        }
        if (featureId.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            return this.fErrorReporter.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        throw new XMLConfigurationException(0, featureId);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (featureId.equals(SCHEMA_FULL_CHECKING)) {
            this.fIsCheckedFully = state;
        } else if (featureId.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, state);
        } else if (featureId.equals(ALLOW_JAVA_ENCODINGS)) {
            this.fAllowJavaEncodings = state;
        } else if (featureId.equals(STANDARD_URI_CONFORMANT_FEATURE)) {
            this.fStrictURI = state;
        } else {
            throw new XMLConfigurationException(0, featureId);
        }
    }

    private void processJAXPSchemaSource(Hashtable locationPairs) throws IOException {
        this.fJAXPProcessed = true;
        if (this.fJAXPSource == null) {
            return;
        }
        Class<?> componentType = this.fJAXPSource.getClass().getComponentType();
        XMLInputSource xis = null;
        String sid = null;
        if (componentType == null) {
            SchemaGrammar g;
            if ((this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(this.fJAXPSource)) != null) {
                this.fGrammarBucket.putGrammar(g);
                return;
            }
            this.fXSDDescription.reset();
            xis = this.xsdToXMLInputSource(this.fJAXPSource);
            sid = xis.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (sid != null) {
                this.fXSDDescription.setLiteralSystemId(sid);
                this.fXSDDescription.setExpandedSystemId(sid);
                this.fXSDDescription.fLocationHints = new String[]{sid};
            }
            g = this.loadSchema(this.fXSDDescription, xis, locationPairs);
            if (this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) {
                this.fJAXPCache.put(this.fJAXPSource, g);
            }
            this.fGrammarBucket.putGrammar(g);
            return;
        }
        if (componentType != (class$java$lang$Object == null ? (class$java$lang$Object = XMLSchemaLoader.class$("java.lang.Object")) : class$java$lang$Object) && componentType != (class$java$lang$String == null ? (class$java$lang$String = XMLSchemaLoader.class$("java.lang.String")) : class$java$lang$String) && componentType != (class$java$io$File == null ? (class$java$io$File = XMLSchemaLoader.class$("java.io.File")) : class$java$io$File) && componentType != (class$java$io$InputStream == null ? (class$java$io$InputStream = XMLSchemaLoader.class$("java.io.InputStream")) : class$java$io$InputStream) && componentType != (class$org$xml$sax$InputSource == null ? (class$org$xml$sax$InputSource = XMLSchemaLoader.class$("org.xml.sax.InputSource")) : class$org$xml$sax$InputSource)) {
            throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have an array of type {" + componentType.getName() + "}. Possible types of the array supported are Object, String, File, " + "InputStream, InputSource.");
        }
        Object[] objArr = (Object[])this.fJAXPSource;
        Vector<String> jaxpSchemaSourceNamespaces = new Vector<String>();
        int i = 0;
        while (i < objArr.length) {
            SchemaGrammar g;
            if ((objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(objArr[i])) != null) {
                this.fGrammarBucket.putGrammar(g);
            } else {
                this.fXSDDescription.reset();
                xis = this.xsdToXMLInputSource(objArr[i]);
                sid = xis.getSystemId();
                this.fXSDDescription.fContextType = (short)3;
                if (sid != null) {
                    this.fXSDDescription.setLiteralSystemId(sid);
                    this.fXSDDescription.setExpandedSystemId(sid);
                    this.fXSDDescription.fLocationHints = new String[]{sid};
                }
                String targetNamespace = null;
                SchemaGrammar grammar = this.loadSchema(this.fXSDDescription, xis, locationPairs);
                if (grammar != null) {
                    targetNamespace = grammar.getTargetNamespace();
                    if (jaxpSchemaSourceNamespaces.contains(targetNamespace)) {
                        throw new IllegalArgumentException(" When using array of Objects as the value of SCHEMA_SOURCE property , no two Schemas should share the same targetNamespace. ");
                    }
                    jaxpSchemaSourceNamespaces.add(targetNamespace);
                    if (objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) {
                        this.fJAXPCache.put(objArr[i], grammar);
                    }
                    this.fGrammarBucket.putGrammar(grammar);
                }
            }
            ++i;
        }
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public XMLSchemaLoader(SymbolTable symbolTable) {
        this(symbolTable, null, new XMLEntityManager(), null, null, null);
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, errorHandler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public Object getProperty(String propertyId) throws XMLConfigurationException {
        if (propertyId.equals(SYMBOL_TABLE)) {
            return this.fSymbolTable;
        }
        if (propertyId.equals(ERROR_REPORTER)) {
            return this.fErrorReporter;
        }
        if (propertyId.equals(ERROR_HANDLER)) {
            return this.fErrorReporter.getErrorHandler();
        }
        if (propertyId.equals(ENTITY_RESOLVER)) {
            return this.fEntityResolver;
        }
        if (propertyId.equals(XMLGRAMMAR_POOL)) {
            return this.fGrammarPool;
        }
        if (propertyId.equals(SCHEMA_LOCATION)) {
            return this.fExternalSchemas;
        }
        if (propertyId.equals(SCHEMA_NONS_LOCATION)) {
            return this.fExternalNoNSSchema;
        }
        if (propertyId.equals(JAXP_SCHEMA_SOURCE)) {
            return this.fJAXPSource;
        }
        throw new XMLConfigurationException(0, propertyId);
    }

    public void setProperty(String propertyId, Object state) throws XMLConfigurationException, ClassCastException {
        if (propertyId.equals(SYMBOL_TABLE)) {
            this.fSymbolTable = (SymbolTable)state;
        } else if (propertyId.equals(ERROR_REPORTER)) {
            this.fErrorReporter = (XMLErrorReporter)state;
        } else if (propertyId.equals(ERROR_HANDLER)) {
            this.fErrorReporter.setProperty(propertyId, state);
        } else if (propertyId.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)state;
        } else if (propertyId.equals(XMLGRAMMAR_POOL)) {
            this.fGrammarPool = (XMLGrammarPool)state;
        } else if (propertyId.equals(SCHEMA_LOCATION)) {
            this.fExternalSchemas = (String)state;
        } else if (propertyId.equals(SCHEMA_NONS_LOCATION)) {
            this.fExternalNoNSSchema = (String)state;
        } else if (propertyId.equals(JAXP_SCHEMA_SOURCE)) {
            this.fJAXPSource = state;
            this.fJAXPProcessed = false;
        } else {
            throw new XMLConfigurationException(0, propertyId);
        }
    }

    public static boolean tokenizeSchemaLocationStr(String schemaStr, Hashtable locations) {
        if (schemaStr != null) {
            StringTokenizer t = new StringTokenizer(schemaStr, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = t.nextToken();
                if (!t.hasMoreTokens()) {
                    return false;
                }
                String location = t.nextToken();
                LocationArray la = (LocationArray)locations.get(namespace);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(namespace, la);
                }
                la.addLocation(location);
            }
        }
        return true;
    }

    public Grammar loadGrammar(XMLInputSource source) throws IOException, XNIException {
        this.reset();
        XSDDescription desc = new XSDDescription();
        desc.fContextType = (short)3;
        desc.setBaseSystemId(source.getBaseSystemId());
        desc.setLiteralSystemId(source.getSystemId());
        Hashtable locationPairs = new Hashtable();
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNSSchema, locationPairs, this.fErrorReporter);
        SchemaGrammar grammar = this.loadSchema(desc, source, locationPairs);
        if (grammar != null && this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", this.fGrammarBucket.getGrammars());
        }
        return grammar;
    }

    private XMLInputSource xsdToXMLInputSource(Object val) {
        if (val instanceof String) {
            String loc = (String)val;
            if (this.fEntityResolver != null) {
                this.fXSDDescription.reset();
                this.fXSDDescription.setValues(null, loc, null, null);
                XMLInputSource xis = null;
                try {
                    xis = this.fEntityResolver.resolveEntity(this.fXSDDescription);
                }
                catch (IOException ex) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{loc}, (short)1);
                }
                if (xis == null) {
                    return new XMLInputSource(null, loc, null);
                }
                return xis;
            }
        } else {
            if (val instanceof InputSource) {
                return XMLSchemaLoader.saxToXMLInputSource((InputSource)val);
            }
            if (val instanceof InputStream) {
                return new XMLInputSource(null, null, null, (InputStream)val, null);
            }
            if (val instanceof File) {
                File file = (File)val;
                BufferedInputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException ex) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{file.toString()}, (short)1);
                }
                return new XMLInputSource(null, null, null, is, null);
            }
        }
        throw new XMLConfigurationException(1, "\"http://java.sun.com/xml/jaxp/properties/schemaSource\" property cannot have a value of type {" + val.getClass().getName() + "}. Possible types of the value supported are String, File, InputStream, " + "InputSource OR an array of these types.");
    }

    private static XMLInputSource saxToXMLInputSource(InputSource sis) {
        String publicId = sis.getPublicId();
        String systemId = sis.getSystemId();
        Reader charStream = sis.getCharacterStream();
        if (charStream != null) {
            return new XMLInputSource(publicId, systemId, null, charStream, null);
        }
        InputStream byteStream = sis.getByteStream();
        if (byteStream != null) {
            return new XMLInputSource(publicId, systemId, null, byteStream, sis.getEncoding());
        }
        return new XMLInputSource(publicId, systemId, null);
    }

    public static void processExternalHints(String sl, String nsl, Hashtable locations, XMLErrorReporter er) {
        block7: {
            XSAttributeDecl attrDecl;
            if (sl != null) {
                try {
                    attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                    attrDecl.fType.validate(sl, null, null);
                    if (!XMLSchemaLoader.tokenizeSchemaLocationStr(sl, locations)) {
                        er.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sl}, (short)0);
                    }
                }
                catch (InvalidDatatypeValueException ex) {
                    er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
                }
            }
            if (nsl == null) break block7;
            try {
                attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                attrDecl.fType.validate(nsl, null, null);
                LocationArray la = (LocationArray)locations.get(XMLSymbols.EMPTY_STRING);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(XMLSymbols.EMPTY_STRING, la);
                }
                la.addLocation(nsl);
            }
            catch (InvalidDatatypeValueException ex) {
                er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
            }
        }
    }

    SchemaGrammar loadSchema(XSDDescription desc, XMLInputSource source, Hashtable locationPairs) throws IOException, XNIException {
        if (!this.fJAXPProcessed) {
            this.processJAXPSchemaSource(locationPairs);
        }
        SchemaGrammar grammar = this.fSchemaHandler.parseSchema(source, desc, locationPairs);
        if (this.fIsCheckedFully) {
            XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        return grammar;
    }

    XMLSchemaLoader(XMLErrorReporter errorReporter, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this(null, errorReporter, null, grammarBucket, sHandler, builder);
    }

    public static XMLInputSource resolveDocument(XSDDescription desc, Hashtable locationPairs, XMLEntityResolver entityResolver) throws IOException {
        String[] hints;
        String namespace;
        String ns;
        LocationArray tempLA;
        String loc = null;
        if ((desc.getContextType() == 2 || desc.fromInstance()) && (tempLA = (LocationArray)locationPairs.get(ns = (namespace = desc.getTargetNamespace()) == null ? XMLSymbols.EMPTY_STRING : namespace)) != null) {
            loc = tempLA.getFirstLocation();
        }
        if (loc == null && (hints = desc.getLocationHints()) != null && hints.length > 0) {
            loc = hints[0];
        }
        String expandedLoc = XMLEntityManager.expandSystemId(loc, desc.getBaseSystemId(), false);
        desc.setLiteralSystemId(loc);
        desc.setExpandedSystemId(expandedLoc);
        return entityResolver.resolveEntity(desc);
    }

    XMLSchemaLoader(SymbolTable symbolTable, XMLErrorReporter errorReporter, XMLEntityResolver entityResolver, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this.fSymbolTable = symbolTable;
        if (errorReporter == null) {
            errorReporter = new XMLErrorReporter();
            errorReporter.setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = errorReporter;
        this.fEntityResolver = entityResolver;
        if (grammarBucket == null) {
            grammarBucket = new XSGrammarBucket();
        }
        this.fGrammarBucket = grammarBucket;
        if (sHandler == null) {
            sHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        }
        this.fSubGroupHandler = sHandler;
        CMNodeFactory nodeFactory = new CMNodeFactory();
        if (builder == null) {
            builder = new CMBuilder(nodeFactory);
        }
        this.fCMBuilder = builder;
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
        this.fDeclPool = new XSDeclarationPool();
        this.fJAXPCache = new Hashtable();
    }

    static class LocationArray {
        int length;
        String[] locations = new String[2];

        public int getLength() {
            return this.length;
        }

        LocationArray() {
        }

        public void resize(int oldLength, int newLength) {
            String[] temp = new String[newLength];
            System.arraycopy(this.locations, 0, temp, 0, Math.min(oldLength, newLength));
            this.locations = temp;
            this.length = Math.min(oldLength, newLength);
        }

        public String getFirstLocation() {
            return this.length > 0 ? this.locations[0] : null;
        }

        public String[] getLocationArray() {
            if (this.length < this.locations.length) {
                this.resize(this.locations.length, this.length);
            }
            return this.locations;
        }

        public void addLocation(String location) {
            if (this.length >= this.locations.length) {
                this.resize(this.length, Math.max(1, this.length * 2));
            }
            this.locations[this.length++] = location;
        }
    }
}

