/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import com.sun.portal.portletcontainercommon.PreferencesValidatorSetter;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

public class DPPortletPreferencesImpl
implements PortletPreferences,
PreferencesValidatorSetter {
    private Logger _logger;
    private String _channel;
    private ProviderContext _pc;
    private PreferencesValidator _pv;
    private HttpServletRequest _req;
    private boolean _readOnly;
    private Map _prefPropertiesMap;
    private Map _additionalPrefMap;
    private boolean _additionalPrefModified;
    private Map _predefinedPrefMap;
    private Set _modifiedList;
    private static final String PORTLET_PREFERENCE_PREFIX = "__Portlet__";
    private static final String ADDITIONAL_PREFERENCE = "__Portlet__AdditionalPreferences";
    private static final String PORTLET_PREFERENCE_PROPS = "__Portlet__PreferenceProperties";
    private static final String CURRENT_ACTION = "javax.portlet.currentAction";
    private static final String ALLOW_SAVE_PREF = "allowSavePref";
    private static final String PREFERENCE_READONLY = "isReadOnly";
    private static final String PREFERENCE_DEFAULT = "default";
    private static String[] EMPTY_STRING_ARRAY = new String[0];

    public DPPortletPreferencesImpl(HttpServletRequest req, ProviderContext pc, String channel, boolean readOnly, Logger logger) {
        block4: {
            this._logger = logger;
            this._channel = channel;
            this._req = req;
            this._pc = pc;
            try {
                this._prefPropertiesMap = this._pc.getCollectionProperty(this._channel, PORTLET_PREFERENCE_PROPS);
            }
            catch (ProviderContextException pce) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block4;
                this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.DPPortletPreferenceImp(): " + (Object)((Object)pce));
            }
        }
        if (this._prefPropertiesMap == null) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.DPPortletPreferenceImp(): __Portlet__PreferenceProperties map not defined");
            }
            this._prefPropertiesMap = new HashMap();
        }
        this._predefinedPrefMap = new HashMap();
        this._modifiedList = new HashSet();
        this._additionalPrefModified = false;
        this._readOnly = readOnly;
    }

    public DPPortletPreferencesImpl(HttpServletRequest req, ProviderContext pc, String channel, Logger logger) {
        this(req, pc, channel, false, logger);
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.getIsReadOnly(key);
    }

    public String getValue(String key, String def) {
        String[] defs = new String[]{def};
        String[] values = this.getValues(key, defs);
        if (values == null || values.length == 0) {
            return def;
        }
        return values[0];
    }

    public String[] getValues(String key, String[] def) {
        String value = this.getPrefValue(key, this.arrayToString(def));
        String[] prefs = this.stringToArray(value);
        if (prefs == null || prefs.length == 0) {
            return def;
        }
        return prefs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this._readOnly) {
            throw new ReadOnlyException("");
        }
        if (this.getIsPredefined(key)) {
            if (this.getIsReadOnly(key)) throw new ReadOnlyException("");
            this._predefinedPrefMap.put(key, value);
            this._modifiedList.add(key);
            return;
        } else {
            this.loadAdditionalPrefMap();
            this._additionalPrefMap.put(key, value);
            this._additionalPrefModified = true;
        }
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        this.setValue(key, this.arrayToString(values));
    }

    public Enumeration getNames() {
        Map prefMap = (Map)this._prefPropertiesMap.get(PREFERENCE_DEFAULT);
        Set names = prefMap.keySet();
        HashSet cloneNames = new HashSet(names);
        this.loadAdditionalPrefMap();
        cloneNames.addAll(this._additionalPrefMap.keySet());
        Vector v = new Vector(cloneNames);
        return v.elements();
    }

    public Map getMap() {
        HashMap<String, String[]> prefMap = new HashMap<String, String[]>();
        Enumeration names = this.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            prefMap.put(name, this.getValues(name, null));
        }
        if (prefMap.size() > 0) {
            return prefMap;
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.getIsPredefined(key)) {
            if (this.getIsReadOnly(key)) throw new ReadOnlyException("");
            this._predefinedPrefMap.put(key, this.getDefault(key));
            this._modifiedList.add(key);
            return;
        } else {
            this.loadAdditionalPrefMap();
            this._additionalPrefMap.remove(key);
            this._additionalPrefModified = true;
        }
    }

    public void store() throws IOException, ValidatorException {
        boolean savePref = false;
        try {
            savePref = this._pc.getBooleanProperty(this._channel, ALLOW_SAVE_PREF);
        }
        catch (ProviderContextException pce) {
            // empty catch block
        }
        String currentAction = (String)this._req.getAttribute(CURRENT_ACTION);
        if (!currentAction.equals("RENDER") || savePref) {
            if (this._pv != null) {
                this._pv.validate((PortletPreferences)this);
            }
        } else {
            throw new IllegalStateException();
        }
        this.saveAdditionalPrefMap();
        this.savePredefinedPrefMap();
    }

    public void setPreferencesValidator(PreferencesValidator pv) {
        this._pv = pv;
    }

    private String getPrefValue(String key, String def) {
        String pref = null;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.getIsPredefined(key)) {
            this.loadPredefinedPref(key, def);
            if (this._predefinedPrefMap.containsKey(key)) {
                return (String)this._predefinedPrefMap.get(key);
            }
            return def;
        }
        this.loadAdditionalPrefMap();
        pref = (String)this._additionalPrefMap.get(key);
        if (pref != null) {
            return pref;
        }
        return def;
    }

    private String[] stringToArray(String value) {
        List valueArray = PortletPreferencesUtility.getPreferenceValues((String)value);
        return valueArray.toArray(EMPTY_STRING_ARRAY);
    }

    private String arrayToString(String[] values) {
        return PortletPreferencesUtility.getPreferenceString((String[])values);
    }

    private HashMap cloneMap(Map original) {
        HashMap clone = null;
        if (original instanceof HashMap) {
            return (HashMap)((HashMap)original).clone();
        }
        clone = new HashMap();
        Iterator names = original.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            clone.put(name, original.get(name));
        }
        return clone;
    }

    private void loadAdditionalPrefMap() {
        if (this._additionalPrefMap == null) {
            block7: {
                this._additionalPrefMap = new HashMap();
                try {
                    if (this._pc.existsCollectionProperty(this._channel, ADDITIONAL_PREFERENCE)) {
                        Map prefMap = this._pc.getCollectionProperty(this._channel, ADDITIONAL_PREFERENCE);
                        if (prefMap != null) {
                            this._additionalPrefMap = this.cloneMap(prefMap);
                        }
                    } else if (this._logger.isLoggable(Level.WARNING)) {
                        this._logger.log(Level.WARNING, "DPPortletPreferenceImp.loadAdditionalPrefMap(): Additional Preference List not defined in display profile");
                    }
                }
                catch (ProviderContextException pce) {
                    if (!this._logger.isLoggable(Level.SEVERE)) break block7;
                    this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.loadAdditionalPrefMap(): " + (Object)((Object)pce));
                }
            }
            this._additionalPrefModified = false;
        }
    }

    private void loadPredefinedPref(String prefName, String def) {
        block4: {
            if (!this._predefinedPrefMap.containsKey(prefName)) {
                try {
                    String pref = this._pc.getStringProperty(this._channel, PORTLET_PREFERENCE_PREFIX + prefName, def);
                    if (this._logger.isLoggable(Level.INFO)) {
                        this._logger.log(Level.INFO, "Loading " + PORTLET_PREFERENCE_PREFIX + prefName + " value is " + pref);
                    }
                    this._predefinedPrefMap.put(prefName, pref);
                }
                catch (ProviderContextException pce) {
                    if (!this._logger.isLoggable(Level.SEVERE)) break block4;
                    this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.loadPredefinedPrefMap(): " + (Object)((Object)pce));
                }
            }
        }
    }

    private void saveAdditionalPrefMap() {
        if (this._additionalPrefModified) {
            block3: {
                try {
                    this._pc.setCollectionProperty(this._channel, ADDITIONAL_PREFERENCE, (Map)this.cloneMap(this._additionalPrefMap));
                }
                catch (ProviderContextException pce) {
                    if (!this._logger.isLoggable(Level.SEVERE)) break block3;
                    this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.saveAdditionalPrefMap(): " + (Object)((Object)pce));
                }
            }
            this._additionalPrefModified = false;
        }
    }

    private void savePredefinedPrefMap() {
        Iterator iter = this._modifiedList.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this._predefinedPrefMap.get(key);
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.log(Level.INFO, "DPPortletPreferenceImp.savePredefinedPrefMap(): saving " + key + " as " + value + " to dp ");
            }
            try {
                this._pc.setStringProperty(this._channel, PORTLET_PREFERENCE_PREFIX + key, value);
            }
            catch (ProviderContextException pce) {
                if (!this._logger.isLoggable(Level.SEVERE)) continue;
                this._logger.log(Level.SEVERE, "DPPortletPreferenceImp.savePredefinedPrefMap(): " + (Object)((Object)pce));
            }
        }
        this._modifiedList.clear();
    }

    private boolean getIsReadOnly(String key) {
        Boolean isReadOnly;
        boolean retval = false;
        Map isReadOnlyMap = (Map)this._prefPropertiesMap.get(PREFERENCE_READONLY);
        if (isReadOnlyMap != null && (isReadOnly = (Boolean)isReadOnlyMap.get(key)) != null) {
            retval = isReadOnly;
        }
        return retval;
    }

    private String getDefault(String key) {
        String def = null;
        Map defaultMap = (Map)this._prefPropertiesMap.get(PREFERENCE_DEFAULT);
        if (defaultMap != null) {
            def = (String)defaultMap.get(key);
        }
        return def;
    }

    private boolean getIsPredefined(String key) {
        Map prefMap = (Map)this._prefPropertiesMap.get(PREFERENCE_READONLY);
        return prefMap.containsKey(key);
    }
}

