/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.portlet.impl;

import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.portlet.CacheManager;
import com.sun.portal.container.portlet.NoSuchCachedContentException;
import com.sun.portal.container.portlet.PortletCacheEntry;
import com.sun.portal.providers.context.ProviderContext;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CacheManagerImpl
implements CacheManager {
    public static final String CACHED_PORTLETS = "javax.portlet.cache_portlets";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletCacheEntry getCachedPortlet(ContainerRequest request) {
        PortletCacheEntry pce;
        Map cachedPortlets;
        PortletCacheEntry cacheEntry = null;
        String portletEntityID = request.getEntityID();
        Map map = cachedPortlets = this.getCachedPortletsMap(request);
        synchronized (map) {
            pce = (PortletCacheEntry)cachedPortlets.get(portletEntityID);
        }
        if (pce != null && pce.getCacheType() == 1) {
            long now = System.currentTimeMillis();
            if (pce.getExpirationTime() > now) {
                cacheEntry = pce;
            } else {
                this.removeCachedPortlet(request);
            }
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCachedPortlet(ContainerRequest request, PortletCacheEntry entry) {
        Map cachedPortlets;
        String portletEntityID = request.getEntityID();
        Map map = cachedPortlets = this.getCachedPortletsMap(request);
        synchronized (map) {
            cachedPortlets.put(portletEntityID, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedPortlet(ContainerRequest request) {
        Map cachedPortlets;
        String portletEntityID = request.getEntityID();
        Map map = cachedPortlets = this.getCachedPortletsMap(request);
        synchronized (map) {
            cachedPortlets.remove(portletEntityID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCachedPortlets(ContainerRequest request) {
        Map cachedPortlets;
        Map map = cachedPortlets = this.getCachedPortletsMap(request);
        synchronized (map) {
            cachedPortlets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheExpired(ContainerRequest request) throws IllegalStateException, NoSuchCachedContentException {
        PortletCacheEntry pce;
        Map cachedPortlets;
        boolean cacheExpired = true;
        String portletEntityID = request.getEntityID();
        Map map = cachedPortlets = this.getCachedPortletsMap(request);
        synchronized (map) {
            pce = (PortletCacheEntry)cachedPortlets.get(portletEntityID);
        }
        if (pce != null) {
            if (pce.getCacheType() == 1) {
                long now = System.currentTimeMillis();
                if (pce.getExpirationTime() > now) {
                    cacheExpired = false;
                }
            }
        } else {
            throw new NoSuchCachedContentException("CacheManagerImpl.isCacheExpired: Cache entry is not found. EntityID:" + portletEntityID);
        }
        return cacheExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getCachedPortletsMap(ContainerRequest request) {
        HttpServletRequest req = request.getHttpServletRequest();
        ProviderContext pc = (ProviderContext)req.getAttribute("provider_context");
        HashMap cachedPortlets = (HashMap)pc.getSessionProperty(CACHED_PORTLETS);
        if (cachedPortlets == null) {
            ProviderContext providerContext = pc;
            synchronized (providerContext) {
                cachedPortlets = (Map)pc.getSessionProperty(CACHED_PORTLETS);
                if (cachedPortlets == null) {
                    cachedPortlets = new HashMap();
                    pc.setSessionProperty(CACHED_PORTLETS, cachedPortlets);
                }
            }
        }
        return cachedPortlets;
    }
}

