/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.mail;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.portal.providers.mail.MailProvider;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.UIDFolder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessengerExpressHelper
implements MailApplicationHelper {
    public MailProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    private MsgExpURL mailMsgExpURL = null;
    private long lastCheckTime = 0L;
    private long checkInterval;
    protected String appName = "";
    protected String containerName = "";

    public void init(MailProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        this.checkInterval = Integer.parseInt(this.adapterProperties.getProperty("checkInterval", "5000"));
    }

    public String getStartURL(MailProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception e) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)e);
        }
        return url;
    }

    public String getApplicationURL(MailProvider provider, HttpServletRequest request) throws Exception {
        ProviderContext pc = provider.getProviderContext();
        String clientURL = null;
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String host = this.adapterProperties.getProperty("host");
        String baseURL = clientProtocol + "://" + host + ":" + clientPort;
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null) {
            if (this.adapterProperties.getProperty("serverSSOEnabled", "").equals("true")) {
                clientURL = baseURL;
            } else {
                String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth");
                String uid = null;
                String password = null;
                String domain = null;
                if (enableProxyAuth != null && enableProxyAuth.equals("true")) {
                    uid = this.adapterProperties.getProperty("proxyAdminUid");
                    password = this.adapterProperties.getProperty("proxyAdminPassword");
                    domain = this.adapterProperties.getProperty("domain");
                } else {
                    uid = this.adapterProperties.getProperty("uid");
                    password = this.adapterProperties.getProperty("password");
                    domain = this.adapterProperties.getProperty("domain");
                }
                if (pc.isDebugMessageEnabled()) {
                    if (uid != null) {
                        pc.debugMessage((Object)("MessengerExpressHelper.getApplicationURL(): uid=" + uid));
                    }
                    if (domain != null) {
                        pc.debugMessage((Object)("MessengerExpressHelper.getApplicationURL(): domain=" + domain));
                    }
                    if (baseURL != null) {
                        pc.debugMessage((Object)("MessengerExpressHelper.getApplicationURL(): baseURL=" + baseURL));
                    }
                }
                clientURL = this.getWebmailURL(uid, password, domain, baseURL);
            }
        } else {
            clientURL = baseURL;
        }
        return clientURL;
    }

    private String getWebmailURL(String user, String pass, String domain, String baseUrl) {
        if (baseUrl != null && !baseUrl.equals("") && baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        MsgExpURL newMEUrl = new MsgExpURL(user, pass, baseUrl);
        boolean urlValid = false;
        if (this.mailMsgExpURL != null && this.mailMsgExpURL.equals(newMEUrl) && this.isValidSession(this.mailMsgExpURL)) {
            urlValid = true;
            newMEUrl = this.mailMsgExpURL;
            SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".getWebmailURL(): returning previously generated SSO URL "));
        }
        if (!urlValid) {
            String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth");
            String urlstr = null;
            if (enableProxyAuth != null && enableProxyAuth.equals("true")) {
                SSOToken tok = null;
                urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(user) + "&password=" + URLEncoder.encode(pass);
                try {
                    tok = this.ssoAdapter.getSSOToken();
                }
                catch (SSOAdapterException ssoae) {
                    tok = null;
                }
                if (tok != null) {
                    AMStoreConnection amsc = null;
                    AMUser auser = null;
                    String puid = null;
                    String usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                    try {
                        amsc = new AMStoreConnection(tok);
                        auser = amsc.getUser(tok.getPrincipal().getName());
                        puid = auser.getStringAttribute(usrAttr);
                    }
                    catch (SSOException ssoe) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getWebmailURL(): proxy uid retrieval failed "), (Throwable)ssoe);
                    }
                    catch (AMException ame) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getWebmailURL(): proxy uid retrieval failed "), (Throwable)ame);
                    }
                    if (puid != null && puid.length() > 0) {
                        if (domain != null) {
                            puid = puid + "@" + domain;
                        }
                        urlstr = urlstr + "&proxyauth=" + URLEncoder.encode(puid);
                    }
                }
            } else if (domain != null && !domain.equals("")) {
                String fqUser = user + "@" + domain;
                urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(fqUser) + "&password=" + URLEncoder.encode(pass);
            } else {
                urlstr = baseUrl + "/login.msc?user=" + URLEncoder.encode(user) + "&password=" + URLEncoder.encode(pass);
                SSOAdapterDebug.logMessage((String)"MessengerExpressHelper.getWebmailURL:  domain not set");
            }
            SSOAdapterDebug.logMessage((String)("MessengerExpressHelper.getWebmailURL:  urlstr=" + urlstr));
            String authUrl = this.getRelativeSsoUrl(urlstr, newMEUrl);
            SSOAdapterDebug.logMessage((String)("MessengerExpressHelper.getWebmailURL:  authUrl=" + authUrl));
            if (authUrl != null) {
                newMEUrl.setSsoUri(baseUrl + authUrl + "&view=portal");
            } else {
                newMEUrl = null;
                SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".getWebmailURL(): returning null URL."));
                return null;
            }
        }
        this.mailMsgExpURL = newMEUrl;
        String mailSessId = null;
        if (newMEUrl != null) {
            mailSessId = newMEUrl.getWebmailSessionId();
        }
        if (mailSessId == null) {
            mailSessId = "";
        }
        if (newMEUrl != null) {
            return newMEUrl.getSsoUri();
        }
        return baseUrl;
    }

    private boolean isValidSession(MsgExpURL meURL) {
        Date newCheckDate = new Date();
        long newCheckTime = newCheckDate.getTime();
        long timeSinceLastCheck = newCheckTime - this.lastCheckTime;
        if (timeSinceLastCheck < this.checkInterval) {
            return true;
        }
        this.lastCheckTime = newCheckTime;
        String webmailSessionId = meURL.getWebmailSessionId();
        if (webmailSessionId == null) {
            SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".isValidSession():  " + "webmailSessionId is null.  Generating new URL"));
            return false;
        }
        String pageContent = "";
        String urlstr = meURL.baseUri + "/mbox.msc?sid=" + webmailSessionId + "&security=false&mbox=INBOX&start=0&count=20&date=false";
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr);
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
        }
        catch (IOException ioe) {
            SSOAdapterDebug.logError((String)(this.getClass().getName() + ".isValidSession():  " + "error making URL connection:  " + ioe));
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                pageContent = pageContent + inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            SSOAdapterDebug.logError((String)(this.getClass().getName() + ".isValidSession():  failed:  " + e));
            e.printStackTrace();
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        if (pageContent.indexOf("parent.timeoutCB()") > 0) {
            SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".isValidSession():  failed:  " + "Messenger Express session timed out."));
            pageContent = null;
            meURL.setWebmailSessionId(null);
            return false;
        }
        SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".isValidSession():  failed:  " + "Messenger Express session is still valid."));
        return true;
    }

    private String getRelativeSsoUrl(String urlstr, MsgExpURL meURL) {
        String authUrl = null;
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr);
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
        }
        catch (MalformedURLException mfe) {
            SSOAdapterDebug.logError((String)(this.getClass().getName() + ".getRelativeSsoUrl(): Malformed URL: base" + " clientURL = " + meURL.getBaseUri()));
            return null;
        }
        catch (IOException ioe) {
            SSOAdapterDebug.logError((String)(this.getClass().getName() + ".getRelativeSsoUrl(): Error making url connection "), (Throwable)ioe);
            return null;
        }
        String location = urlconn.getHeaderField("Location");
        if (location != null) {
            int sessionIdBegin = 0;
            sessionIdBegin = location.indexOf("sid");
            if (sessionIdBegin < 0) {
                SSOAdapterDebug.logMessage((String)(this.getClass().getName() + ".getRelativeSsoUrl(): Cannot find session id in response. Cannot Authenticate!"));
                meURL.setWebmailSessionId(null);
                authUrl = null;
            } else {
                String inter = location.substring(sessionIdBegin + 4);
                int sessionIdEnd = inter.indexOf("&");
                String mailSessionId = inter.substring(0, sessionIdEnd);
                meURL.setWebmailSessionId(mailSessionId);
                authUrl = location.charAt(0) != '/' ? "/" + location : location;
            }
        }
        return authUrl;
    }

    public StringBuffer getAppPrefsEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = mprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(mprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
        }
        catch (ProviderContextException pce) {
            pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)mprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
        }
        return content;
    }

    public URL processAppPrefsEdit(MailProvider mprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = mprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(request, mprov);
            pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("MessengerExpressHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    pc.debugMessage((Object)("MessengerExpressHelper.processAppPrefsEdit(): key=" + key));
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        if (pc.existsStringProperty(mprov.getName(), key, pflist)) {
                            pc.setStringProperty(mprov.getName(), key, reqString, pflist);
                            pc.debugMessage((Object)("MessengerExpressHelper.processAppPrefsEdit(): reqString(filtered)=" + reqString));
                            continue;
                        }
                        if (pc.existsStringProperty(mprov.getName(), key)) {
                            pc.setStringProperty(mprov.getName(), key, reqString);
                            pc.debugMessage((Object)("MessengerExpressHelper.processAppPrefsEdit(): reqString=" + reqString));
                            continue;
                        }
                        pc.debugWarning((Object)("MessengerExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqNumber.equals("")) continue;
                        if (pc.existsIntegerProperty(mprov.getName(), key, pflist)) {
                            pc.setIntegerProperty(mprov.getName(), key, Integer.parseInt(reqNumber), pflist);
                            continue;
                        }
                        if (pc.existsIntegerProperty(mprov.getName(), key)) {
                            pc.setIntegerProperty(mprov.getName(), key, Integer.parseInt(reqNumber));
                            continue;
                        }
                        pc.debugWarning((Object)("MessengerExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (pc.existsBooleanProperty(mprov.getName(), key, pflist)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (pc.existsBooleanProperty(mprov.getName(), key)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    pc.debugWarning((Object)("MessengerExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("MessengerExpressHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("MessengerExpressHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    public String getMessageURL(MailProvider provider, HttpServletRequest request, Message message) throws Exception {
        String messageURL = null;
        StringBuffer urlBuffer = new StringBuffer(this.getApplicationURL(provider, request));
        Folder folder = message.getFolder();
        if (this.adapterProperties.getProperty("serverSSOEnabled", "").equals("true")) {
            urlBuffer.append("/?argv=mbox=");
            urlBuffer.append(URLEncoder.encode(message.getFolder().getFullName()));
            urlBuffer.append("&argv=msg=");
            urlBuffer.append(((UIDFolder)folder).getUID(message));
        } else {
            urlBuffer.append("&mbox=");
            urlBuffer.append(URLEncoder.encode(message.getFolder().getFullName()));
            urlBuffer.append("&msg=");
            urlBuffer.append(((UIDFolder)folder).getUID(message));
        }
        messageURL = urlBuffer.toString();
        return messageURL;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, MailProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("CalendarExpressHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("CalendarExpressHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    private class MsgExpURL {
        private String user = null;
        private String pass = null;
        private String baseUri = null;
        private String webmailSessionId = null;
        private String sso_uri = null;

        MsgExpURL(String user, String pass, String baseUri) {
            this.user = user;
            this.pass = pass;
            this.baseUri = baseUri;
        }

        boolean equals(MsgExpURL meUrl2Comp) {
            return meUrl2Comp.baseUri.equals(this.baseUri) && meUrl2Comp.user.equals(this.user) && meUrl2Comp.pass.equals(this.pass);
        }

        String getBaseUri() {
            return this.baseUri;
        }

        String getSsoUri() {
            return this.sso_uri;
        }

        void setSsoUri(String sso_uri) {
            this.sso_uri = sso_uri;
        }

        String getWebmailSessionId() {
            return this.webmailSessionId;
        }

        void setWebmailSessionId(String webmailSessionId) {
            this.webmailSessionId = webmailSessionId;
        }

        void release() {
            this.user = null;
            this.pass = null;
            this.baseUri = null;
            this.sso_uri = null;
            this.webmailSessionId = null;
        }
    }
}

