/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class UserAttributeDescriptor {
    public static final String NAME = "name";
    private String _name;
    private List _descriptions = new ArrayList();
    private Map _descriptionMap = new HashMap();
    private Logger _logger;

    public UserAttributeDescriptor(Logger logger) {
        this._logger = logger;
    }

    public void load(Element element, Namespace namespace) {
        this._name = element.getChildTextTrim(NAME, namespace);
        List descriptionElements = element.getChildren("description", namespace);
        Iterator i = descriptionElements.iterator();
        while (i.hasNext()) {
            Element descriptionElement = (Element)i.next();
            this._descriptions.add(descriptionElement.getTextTrim());
            List descList = descriptionElement.getAttributes();
            int j = descList.indexOf("lang");
            if (j == -1) {
                String lang = Locale.getDefault().toString().replace('_', '-');
                this._descriptionMap.put(lang, descriptionElement.getTextTrim());
                continue;
            }
            Attribute dAttr = (Attribute)descList.get(j);
            this._descriptionMap.put(dAttr.getValue(), descriptionElement.getTextTrim());
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        String description = null;
        if (!this._descriptions.isEmpty()) {
            description = (String)this._descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this._descriptions;
    }

    public Map getDescriptionMap() {
        return this._descriptionMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("UserAttributeDescriptor ");
        sb.append(" attribute name [");
        if (this._name != null) {
            sb.append(this._name);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" description [");
        if (!this._descriptions.isEmpty()) {
            sb.append((String)this._descriptions.get(0));
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        return sb.toString();
    }
}

