/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.xml;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLProvider
extends URLScraperProvider {
    private ResourceBundle bundle = null;
    private static Map xslTransformerMap = new HashMap(10);
    private static final String EMPTY_XSL_FILENAME = "emptyXslFileName";
    private static final String XML_FETCH_ERROR = "xmlFetchError";
    private static final String XML_TRANSFOMING_ERROR = "xmlTransformingError";
    private static final String DEFAULT_TRANSFORMER_FACTORY = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";

    protected File getXSL(String string) throws ProviderException {
        File file = null;
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL(): XSL File Name  = " + string));
        }
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL(): XSL File Name  = " + string));
        }
        if ((file = super.getFile(string)) == null) {
            try {
                file = this.getProviderContext().getTemplatePath(this.getName(), string);
            }
            catch (ProviderContextException providerContextException) {
                throw new ProviderException("XMLProvider.getXSL(): ", (Throwable)providerContextException);
            }
        }
        if (file != null && this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)("XMLProvider.getXSL: the file:" + file.getName()));
        }
        if (file == null) {
            try {
                URL uRL = new URL(string);
                throw new ProviderException("XMLProvider.getXSL(): Unsupported URL type :" + uRL.getProtocol());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return file;
    }

    protected StringBuffer getXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        String string = this.getURL();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            string2 = string.substring(0, string.indexOf(58));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (string2 != null && string2.equalsIgnoreCase("file")) {
            String string3 = null;
            try {
                string3 = string.substring(string.indexOf(47));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.getProviderContext().debugError((Object)("XMLProvider.getXML(): Unsupported URL type : " + string), (Throwable)indexOutOfBoundsException);
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  Unsupported URL type : " + string, (Throwable)indexOutOfBoundsException);
            }
            try {
                stringBuffer = this.getFileAsBuffer(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.getProviderContext().debugError((Object)("XMLProvider.getContent(): UnsupportedEncoding specified : " + string3), (Throwable)unsupportedEncodingException);
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  UnsupportedEncoding specified : " + string3, (Throwable)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                this.getProviderContext().debugError((Object)("XMLProvider.getContent():IOException received : " + string3), (Throwable)iOException);
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  IOException received : " + string3, (Throwable)iOException);
            }
        }
        try {
            stringBuffer = this.getHttpContent(httpServletRequest, httpServletResponse, string);
        }
        catch (InterruptedException interruptedException) {
            this.getProviderContext().debugError((Object)("XMLProvider.getXML(): fetcher did not finish : " + string), (Throwable)interruptedException);
            throw new ProviderException("XMLProvider.getXML():Getting XML Content failed fetcher did not finish : " + string, (Throwable)interruptedException);
        }
        catch (MalformedURLException malformedURLException) {
            this.getProviderContext().debugError((Object)("XMLProvider.getXML(). Malformed URL : " + string), (Throwable)malformedURLException);
            throw new ProviderException("XMLProvider.getXML():Getting XML Content failed Malformed URL : " + string, (Throwable)malformedURLException);
        }
        return stringBuffer;
    }

    private synchronized StringBuffer doTransform(StringBuffer stringBuffer, String string) throws ProviderException {
        StringWriter stringWriter;
        StringBuffer stringBuffer2 = null;
        Transformer transformer = null;
        try {
            transformer = this.getXslTransformer(string);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.getProviderContext().debugError((Object)("TransformerWrapperImpl.doTransform: " + string), (Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            this.getProviderContext().debugError((Object)("TransformerWrapperImpl.doTransform: " + string), (Throwable)transformerException);
        }
        if (transformer != null) {
            StreamSource streamSource = new StreamSource(new StringReader(stringBuffer.toString()));
            stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            try {
                transformer.transform(streamSource, streamResult);
            }
            catch (TransformerException transformerException) {
                this.getProviderContext().debugError((Object)("XMLProvider.doTransform():Error in transforming xml : " + stringBuffer + " using XSL file : " + string), (Throwable)transformerException);
                throw new ProviderException("XMLProvider.doTransform():Error in transforming xml : " + stringBuffer + " using XSL file : " + string);
            }
        } else {
            this.getProviderContext().debugError((Object)("XMLProvider.doTransform():Error in getting XSL transformer to transform xml : " + stringBuffer + " using XSL file : " + string));
            throw new ProviderException("XMLProvider.doTransform(): Error in getting XSL transformer to transform xml : " + stringBuffer + " using XSL file : " + string);
        }
        stringBuffer2 = stringWriter.getBuffer();
        return stringBuffer2;
    }

    public StringBuffer getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getStringProperty("xslFileName");
        File file = null;
        String string2 = null;
        try {
            file = this.getXSL(string);
        }
        catch (ProviderException providerException) {
            this.getProviderContext().debugError((Object)("XMLProvider.getContent():Can not get XSL File : " + string), (Throwable)providerException);
        }
        if (file != null) {
            string2 = file.getPath();
        }
        this.bundle = this.getResourceBundle();
        if (string2 == null || string2.equals("")) {
            stringBuffer = stringBuffer.append(this.bundle.getString(EMPTY_XSL_FILENAME));
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            stringBuffer2 = this.getXML(httpServletRequest, httpServletResponse);
        }
        catch (ProviderException providerException) {
            this.getProviderContext().debugError((Object)"XMLProvider.getContent():Can not get XML file from request", (Throwable)providerException);
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_FETCH_ERROR));
            return stringBuffer;
        }
        if (stringBuffer2 == null) {
            this.getProviderContext().debugError((Object)"XMLProvider.getContent(): Can not get XML File from request");
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_FETCH_ERROR));
            return stringBuffer;
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage((Object)"XMLProvider.getContent(): Got XML from request");
        }
        try {
            stringBuffer = this.doTransform(stringBuffer2, string2);
        }
        catch (ProviderException providerException) {
            this.getProviderContext().debugError((Object)("XMLProvider.getContent():Error in XML transformation using XSL file : " + string), (Throwable)providerException);
            stringBuffer = stringBuffer.append(this.bundle.getString(XML_TRANSFOMING_ERROR));
        }
        return stringBuffer;
    }

    protected String getContentEncodingFromContentBytes(byte[] byArray) {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        String string4;
        int n3;
        String string5 = null;
        int n4 = byArray.length;
        int n5 = 1000;
        if (n4 < n5) {
            n5 = n4;
        }
        if ((n3 = (string4 = (string3 = new String(byArray, 0, n5)).toLowerCase()).indexOf("<?xml")) != -1 && (n2 = string4.indexOf(">", n3)) != -1 && (n = (string2 = (string = string3.substring(n3, n2)).toLowerCase()).indexOf("encoding=")) != -1) {
            int n6 = string2.indexOf("\"", n);
            int n7 = string2.indexOf("\"", n6 + 1);
            string5 = string.substring(n6 + 1, n7);
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getXslTransformer(String string) throws TransformerConfigurationException, TransformerException {
        Object object;
        Object object2;
        ProviderContext providerContext = this.getProviderContext();
        String string2 = DEFAULT_TRANSFORMER_FACTORY;
        try {
            if (this.existsStringProperty("transformerFactoryClassName") && ((string2 = this.getStringProperty("transformerFactoryClassName")) == null || string2.equals(""))) {
                string2 = DEFAULT_TRANSFORMER_FACTORY;
            }
        }
        catch (ProviderException providerException) {
            providerContext.debugWarning((Object)"XMLProvider.getXslTransformer():", (Throwable)providerException);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("|");
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        CacheEntry cacheEntry = (CacheEntry)xslTransformerMap.get(string3);
        if (cacheEntry == null) {
            object2 = null;
            cacheEntry = new CacheEntry();
            try {
                object2 = this.getXSL(string);
                if (object2 == null) {
                    providerContext.debugError((Object)("XMLProvider.getXslTransformer(): Getting XSL File " + string + " failed"));
                    return null;
                }
            }
            catch (ProviderException providerException) {
                providerContext.debugError((Object)("XMLProvider.getXslTransformer():Error in getting the XSLFile " + string), (Throwable)providerException);
                return null;
            }
            cacheEntry.xslFile = (File)object2;
            cacheEntry.lastModTime = -1L;
            object = xslTransformerMap;
            synchronized (object) {
                xslTransformerMap.put(string3, cacheEntry);
            }
        }
        if (cacheEntry.lastModTime == -1L || cacheEntry.lastModTime < cacheEntry.xslFile.lastModified()) {
            object2 = null;
            try {
                object = Class.forName(string2);
                object2 = (TransformerFactory)((Class)object).newInstance();
            }
            catch (ClassCastException classCastException) {
                providerContext.debugError((Object)"XMLProvider.getXslTransformer():Class cast exception", (Throwable)classCastException);
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                providerContext.debugError((Object)"XMLProvider.getXslTransformer():Class not found", (Throwable)classNotFoundException);
                return null;
            }
            catch (InstantiationException instantiationException) {
                providerContext.debugError((Object)"XMLProvider.getXslTransformer():Instantiation exception ", (Throwable)instantiationException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                providerContext.debugError((Object)"XMLProvider.getXslTransformer():Illegal Access Excpetion", (Throwable)illegalAccessException);
                return null;
            }
            cacheEntry.xslTransformer = ((TransformerFactory)object2).newTransformer(new StreamSource(cacheEntry.xslFile));
            cacheEntry.lastModTime = cacheEntry.xslFile.lastModified();
        }
        return cacheEntry.xslTransformer;
    }

    class CacheEntry {
        private Transformer xslTransformer;
        private File xslFile;
        private long lastModTime;
    }
}

