/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.userinfo.OriginalPasswordDidntMatchException;
import com.sun.portal.providers.userinfo.PasswordException;
import com.sun.portal.providers.userinfo.PasswordTooShortException;
import com.sun.portal.providers.userinfo.PasswordsDontMatchException;
import com.sun.portal.providers.userinfo.tag.AttributeTag;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagWrapperException;
import com.sun.portal.providers.userinfo.tag.UnhandledTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MembershipPWTag
implements WriteTag {
    private static String PASSWORD_ATTR_KEY = "userpassword";
    private static String AUTH_MEMBERSHIP_SERVICENAME = "iPlanetAMAuthMembershipService";
    private static String PASSWORD_LENGTH_ATTR_KEY = "iplanet-am-auth-membership-min-password-length";
    private static AMStoreConnection adminConnection = null;
    private String originalPassword = null;
    private String confirmPassword = null;
    private String newPassword = null;
    private boolean confirmSet = false;
    private boolean newSet = false;
    private boolean origSet = false;
    private SSOToken token = null;
    private SSOTokenManager tokenManager = null;
    AttributeTag attributeTag = null;

    public void init(String string, ProviderContext providerContext, HttpServletRequest httpServletRequest) throws TagException {
        this.attributeTag = new AttributeTag();
        this.attributeTag.init(string, providerContext, httpServletRequest);
        try {
            this.tokenManager = SSOTokenManager.getInstance();
            if (this.tokenManager == null) {
                throw new TagException("MembershipPWTag.init(): Failed to getSSOTokenmanager.");
            }
            this.token = this.tokenManager.createSSOToken(httpServletRequest);
        }
        catch (SSOException sSOException) {
            throw new TagWrapperException("MembershipPWTag.init():", (Exception)((Object)sSOException));
        }
    }

    private void reset() {
        this.newSet = false;
        this.origSet = false;
        this.confirmSet = false;
    }

    private boolean initialized() {
        return this.newSet && this.origSet && this.confirmSet;
    }

    public void set(String string, String string2) throws TagException {
        if (string.equals("membershipOriginalPassword")) {
            this.originalPassword = string2;
            this.origSet = true;
        } else if (string.equals("membershipConfirmPassword")) {
            this.confirmPassword = string2;
            this.confirmSet = true;
        } else if (string.equals("membershipNewPassword")) {
            this.newPassword = string2;
            this.newSet = true;
        } else {
            throw new UnhandledTagException("unhandled set tag=" + string);
        }
        if (this.initialized()) {
            AMStoreConnection aMStoreConnection;
            this.reset();
            if (this.newPassword == null) {
                string = "";
            }
            if (this.confirmPassword == null) {
                this.confirmPassword = "";
            }
            if (this.originalPassword == null) {
                this.originalPassword = "";
            }
            if (this.newPassword.length() == 0 && this.confirmPassword.length() == 0) {
                throw new PasswordException("password not set");
            }
            int n = 0;
            try {
                AMTemplate aMTemplate;
                aMStoreConnection = new AMStoreConnection(this.token);
                AMUser aMUser = aMStoreConnection.getUser(this.token.getPrincipal().getName());
                String string3 = aMUser.getOrganizationDN();
                AMOrganization aMOrganization = this.getAdminConnection().getOrganization(string3);
                if (aMOrganization != null) {
                    aMTemplate = aMOrganization.getTemplate(AUTH_MEMBERSHIP_SERVICENAME, 302);
                    if (aMTemplate == null) {
                        throw new TagException("MembershipPWTag.init(): Reading passwordLength, failed to getTemplate.");
                    }
                } else {
                    throw new TagException("MembershipPWTag.init(): Reading passwordLength, failed to getOrganization.");
                }
                Set set = aMTemplate.getAttribute(PASSWORD_LENGTH_ATTR_KEY);
                Iterator iterator = set.iterator();
                String string4 = (String)iterator.next();
                n = Integer.parseInt(string4);
            }
            catch (SSOException sSOException) {
                throw new TagWrapperException("MembershipPWTag.init():", (Exception)((Object)sSOException));
            }
            catch (AMException aMException) {
                throw new TagWrapperException("MembershipPWTag.init():", (Exception)((Object)aMException));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TagWrapperException("MembershipPWTag.init():", numberFormatException);
            }
            if (this.newPassword.length() < n) {
                throw new PasswordTooShortException("password too short", n);
            }
            try {
                aMStoreConnection = this.tokenManager.createSSOToken(this.token.getPrincipal(), this.originalPassword);
            }
            catch (SSOException sSOException) {
                throw new OriginalPasswordDidntMatchException("original password was incorrect");
            }
            if (!this.newPassword.equals(this.confirmPassword)) {
                throw new PasswordsDontMatchException("confirm and new passwords did not match");
            }
            this.attributeTag.set(PASSWORD_ATTR_KEY, this.newPassword);
        }
    }

    private AMStoreConnection getAdminConnection() throws TagWrapperException {
        if (adminConnection == null) {
            try {
                SSOToken sSOToken = this.tokenManager.createSSOToken(new Principal(){

                    public String getName() {
                        return AdminUtils.getAdminDN();
                    }
                }, new String(AdminUtils.getAdminPassword()));
                adminConnection = new AMStoreConnection(sSOToken);
            }
            catch (SSOException sSOException) {
                throw new TagWrapperException("MembershipPWTag.getAdminConnection():", (Exception)((Object)sSOException));
            }
        }
        return adminConnection;
    }
}

