/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;

public class XMLDeclarationParser {
    private String m_version;
    private String m_encoding;
    private PushbackReader m_pushbackReader;
    private HashMap m_map;
    private boolean m_hasHeader;

    public void parse() throws TransformerException, IOException {
        char[] aChar = new char[5];
        int len = this.m_pushbackReader.read(aChar, 0, 5);
        if (len == -1) {
            return;
        }
        if (!new String(aChar, 0, len).equals("<?xml")) {
            this.m_pushbackReader.unread(aChar, 0, len);
            return;
        }
        String[] attr = this.skipWhiteSpaceAndGetNextAttribute();
        while (attr != null) {
            if (attr[0].equals("encoding")) {
                this.m_encoding = attr[1];
            } else if (attr[0].equals("version")) {
                this.m_version = attr[1];
            } else {
                if (this.m_map == null) {
                    this.m_map = new HashMap();
                }
                this.m_map.put(attr[0], attr[1]);
            }
            attr = this.skipWhiteSpaceAndGetNextAttribute();
        }
        this.m_hasHeader = true;
    }

    public XMLDeclarationParser(PushbackReader pr) {
        this.m_pushbackReader = pr;
        this.m_version = "1.0";
        this.m_encoding = "UTF-8";
        this.m_hasHeader = false;
        this.m_map = null;
    }

    public void writeTo(Writer wr) throws IOException {
        if (!this.m_hasHeader) {
            return;
        }
        wr.write("<?xml version='");
        wr.write(this.m_version);
        wr.write("' encoding='");
        wr.write(this.m_encoding);
        wr.write("'");
        if (this.m_map != null) {
            Iterator iter = this.m_map.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                wr.write(" ");
                wr.write(key);
                wr.write("='");
                wr.write((String)this.m_map.get(key));
                wr.write("'");
            }
        }
        wr.write(" ?>\r\n");
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    /*
     * WARNING - void declaration
     */
    private String skipWhiteSpaceAndGetEqualSign() throws TransformerException, IOException {
        int c;
        while ((c = this.m_pushbackReader.read()) != -1) {
            void var1_1;
            if (!Character.isSpaceChar((char)var1_1)) break;
        }
        if (c == -1) {
            throw new TransformerException("Unexpected end of file after <?xml read");
        }
        if (c != 61) {
            throw new TransformerException("Unexpected character whil looking for '='");
        }
        return "=";
    }

    /*
     * WARNING - void declaration
     */
    private String skipWhiteSpaceAndGetNextIdentifier() throws TransformerException, IOException {
        int c;
        while ((c = this.m_pushbackReader.read()) != -1) {
            void var1_1;
            if (!Character.isSpaceChar((char)var1_1)) break;
        }
        if (c == -1) {
            throw new TransformerException("Unexpected end of file whil looking for quote");
        }
        if (c == 63) {
            c = this.m_pushbackReader.read();
            if (c == 62) {
                return null;
            }
            this.m_pushbackReader.unread(c);
        }
        this.m_pushbackReader.unread(c);
        StringBuffer buf = new StringBuffer();
        while ((c = this.m_pushbackReader.read()) != -1) {
            if (Character.isSpaceChar((char)c) || c == 61) {
                this.m_pushbackReader.unread(c);
                break;
            }
            buf.append((char)c);
        }
        if (c == -1) {
            throw new TransformerException("Unexpected end of file whil looking for closing quote");
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String skipWhiteSpaceAndGetNextQuotedIdentifier() throws TransformerException, IOException {
        int c;
        while ((c = this.m_pushbackReader.read()) != -1) {
            void var1_1;
            if (!Character.isSpaceChar((char)var1_1)) break;
        }
        if (c == -1) {
            throw new TransformerException("Unexpected end of file whil looking for quote");
        }
        if (c != 34 && c != 39) {
            throw new TransformerException("Unexpected character while looking for quote");
        }
        StringBuffer buf = new StringBuffer();
        while ((c = this.m_pushbackReader.read()) != -1) {
            if (c == 34 || c == 39) break;
            buf.append((char)c);
        }
        if (c == -1) {
            throw new TransformerException("Unexpected end of file whil looking for closing quote");
        }
        return buf.toString();
    }

    private String[] skipWhiteSpaceAndGetNextAttribute() throws TransformerException, IOException {
        String[] str = new String[2];
        str[0] = this.skipWhiteSpaceAndGetNextIdentifier();
        if (str[0] == null) {
            return null;
        }
        this.skipWhiteSpaceAndGetEqualSign();
        str[1] = this.skipWhiteSpaceAndGetNextQuotedIdentifier();
        return str;
    }
}

