/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class Progress
extends Canvas {
    public int Max = 100;
    public int Min = 0;
    public int Position = 0;
    private int xOffset = 10;
    private int yOffset = 10;
    private int barHigh = 30;
    private int barWidth = 15;
    private int delta = 2;
    private int numOfBars = 0;
    private int totalNumOfBars = 10;
    public Color m_colProg = Color.blue;
    private Image offscreen;
    public Color m_colBG = Color.white;
    public Color m_colBorder = Color.gray;
    public Color m_colInset = Color.white;
    public Color m_colPanelBG = Color.lightGray;
    public Color m_colLine = Color.black;

    public Progress(int n, int n2) {
        this.Max = n2;
        this.Min = n;
    }

    public void setPosition(int n) {
        if (n < this.Min) {
            this.Position = this.Min;
            this.numOfBars = 0;
        } else if (n > this.Max) {
            this.Position = this.Max;
            this.numOfBars = this.totalNumOfBars;
        } else {
            this.Position = n;
            this.numOfBars = this.totalNumOfBars * (n - this.Min) / (this.Max - this.Min);
        }
        this.update();
    }

    public int getPosition() {
        return this.Position;
    }

    public void setMaximum(int n) {
        this.Max = n;
    }

    public int getMaximum() {
        return this.Max;
    }

    public void setMinimum(int n) {
        this.Min = n;
    }

    public int getMinimum() {
        return this.Min;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.m_colBorder);
        graphics.drawRect(0, 0, dimension.width - 3, dimension.height - 3);
        graphics.setColor(this.m_colInset);
        graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        graphics.setColor(this.m_colPanelBG);
        graphics.draw3DRect(this.xOffset, this.yOffset, dimension.width - 2 * this.xOffset - 1, this.barHigh, false);
        graphics.draw3DRect(this.xOffset + 1, this.yOffset + 1, dimension.width - 2 * this.xOffset - 3, this.barHigh - 2, false);
        graphics.drawRect(this.xOffset + 2, this.yOffset + 2, dimension.width - 2 * this.xOffset - 5, this.barHigh - 4);
        graphics.setColor(this.m_colLine);
        graphics.drawLine(this.xOffset + 2, this.yOffset + 2, -this.xOffset + dimension.width - 4, this.yOffset + 2);
        graphics.drawLine(this.xOffset + 2, this.yOffset + 2, this.xOffset + 2, this.yOffset + this.barHigh - 3);
        this.updateSolidbar(graphics);
    }

    public void updateSolidbar(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.xOffset + 4, this.yOffset + 4, dimension.width - 2 * this.xOffset - 6, this.barHigh - 7);
        graphics.fillRect(this.xOffset + 4, this.yOffset + 4, dimension.width - 2 * this.xOffset - 6, this.barHigh - 7);
        graphics.setColor(this.m_colProg);
        int n = (dimension.width - 2 * this.xOffset - 6) * this.numOfBars / this.totalNumOfBars;
        graphics.fillRect(this.xOffset + 4, this.yOffset + 4, n, this.barHigh - 7);
    }

    public void update() {
        Dimension dimension = this.getSize();
        try {
            if (this.offscreen == null && dimension.width > 0 && dimension.height > 0) {
                this.offscreen = this.createImage(dimension.width, dimension.height);
            }
            Graphics graphics = this.offscreen.getGraphics();
            Graphics graphics2 = this.getGraphics();
            graphics.clipRect(0, 0, dimension.width, dimension.height);
            graphics.setFont(this.getFont());
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(graphics2.getColor());
            this.paint(graphics);
            graphics2.clipRect(0, 0, dimension.width, dimension.height);
            graphics2.drawImage(this.offscreen, 0, 0, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.totalNumOfBars = (n3 - 2 * this.xOffset - 5) / (this.barWidth + this.delta);
        if (n3 > 0 && n4 > 0) {
            this.offscreen = this.createImage(n3, n4);
        }
        this.update();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.xOffset * 2 + this.barWidth, this.yOffset * 2 + this.barHigh);
    }
}

