/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSFreeBusy;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SOCSCalendar
extends ICalendar {
    private ArrayList events = new ArrayList();
    private ArrayList todos = new ArrayList();
    private ArrayList freebusys = new ArrayList();
    private Properties[] properties = new Properties[4];
    private int errCode = -1;
    private String description = null;
    private String displayName = null;
    private static final transient String OWNER_CN_KEY = "COMMON-NAME";
    private static final transient String IS_INCLUDED_IN_FREEBUSY_KEY = "FB-INCLUDE";
    private static final transient String INVITE_COUNT_KEY = "INVITATION-COUNT";
    private String productId = "-//iPlanet/Calendar Hosting Server";
    private final String version = "2.0";
    private String method = null;
    private String calscale = null;
    private int wcapVersionInUse = 0;

    public SOCSCalendar(CalendarStore calendarStore, String string) {
        super(calendarStore, string);
        this.wcapVersionInUse = ((SOCSCalendarStore)calendarStore).getProtocolVersionInt();
    }

    public SOCSCalendar(CalendarStore calendarStore, String string, String string2) {
        super(calendarStore, string);
        this.displayName = string2;
        this.wcapVersionInUse = ((SOCSCalendarStore)calendarStore).getProtocolVersionInt();
    }

    public SOCSCalendar(Properties[] propertiesArray, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n) {
        super(null, null);
        this.events = arrayList;
        this.todos = arrayList2;
        this.freebusys = arrayList3;
        this.properties = propertiesArray;
        this.errCode = n;
        try {
            String string;
            Properties properties = this.getProperties(1);
            Properties properties2 = this.getProperties(0);
            if (properties != null) {
                this.displayName = properties.getProperty("NAME");
                this.calId = properties.getProperty("RELATIVE-CALID");
            }
            if (properties2 != null && (string = properties2.getProperty("X-NSCP-WCAPVERSION")) != null) {
                this.wcapVersionInUse = SOCSUtils.versionToInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String string) {
        this.productId = string;
    }

    public String getVersion() {
        return "2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getCalScale() {
        return this.calscale;
    }

    public void setCalScale(String string) {
        this.calscale = string;
    }

    public VEvent createEvent() throws CalendarException, OperationNotSupportedException {
        SOCSEvent sOCSEvent = new SOCSEvent();
        sOCSEvent.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        return sOCSEvent;
    }

    public VTodo createTodo() throws CalendarException, OperationNotSupportedException {
        SOCSTodo sOCSTodo = new SOCSTodo();
        sOCSTodo.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        return sOCSTodo;
    }

    public boolean isUserTheOwner(String string) throws CalendarException, OperationNotSupportedException {
        if (string == null) {
            return false;
        }
        Properties properties = this.getCalProps();
        if (null == properties) {
            throw new CalendarException("Couldn't read calendar properties");
        }
        if (string.equals(properties.getProperty("PRIMARY-OWNER"))) {
            return true;
        }
        String string2 = properties.getProperty("OWNERS");
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDoubleBookingAllowed() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String string = this.getCalProps().getProperty("ALLOW-DOUBLEBOOKING");
        if (null == string) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        if (string.equals("1")) {
            return true;
        }
        return true;
    }

    public void setDoubleBooking(boolean bl) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        Properties properties = this.getProperties(1);
        if (null != properties && null != properties.getProperty("ALLOW-DOUBLEBOOKING")) {
            if (bl && properties.getProperty("ALLOW-DOUBLEBOOKING").equals("1")) {
                return;
            }
            if (!bl && properties.getProperty("ALLOW-DOUBLEBOOKING").equals("0")) {
                return;
            }
        }
        Properties properties2 = new Properties();
        if (!bl) {
            properties2.setProperty("doublebooking", "0");
        } else {
            properties2.setProperty("doublebooking", "1");
        }
        this.setCalProps(properties2);
    }

    public TimeZone getTimeZone() throws CalendarException, OperationNotSupportedException {
        String string = this.getCalProps().getProperty("TZID");
        if (null == string) {
            return null;
        }
        return TimeZone.getTimeZone(string.trim());
    }

    public void setTimeZone(TimeZone timeZone) throws CalendarException, OperationNotSupportedException {
        if (null == timeZone) {
            throw new CalendarException("Illegal Argument: null timezone", 105);
        }
        String string = timeZone.getID();
        Properties properties = this.getProperties(1);
        if (null != properties && null != properties.getProperty("TZID") && properties.getProperty("TZID").equals(string)) {
            return;
        }
        Properties properties2 = new Properties();
        properties2.setProperty("tzid", string);
        this.setCalProps(properties2);
    }

    public void setIncludeInAvailability(boolean bl) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        Properties properties = this.getProperties(1);
        if (null != properties && null != properties.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY)) {
            if (bl && properties.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY).equals("1")) {
                return;
            }
            if (!bl && properties.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY).equals("0")) {
                return;
            }
        }
        Properties properties2 = new Properties();
        if (bl) {
            properties2.setProperty("fbinclude", "1");
        } else {
            properties2.setProperty("fbinclude", "0");
        }
        this.setCalProps(properties2);
    }

    public boolean isIncludedInAvailability() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String string = this.getCalProps().getProperty(IS_INCLUDED_IN_FREEBUSY_KEY);
        if (null == string) {
            return false;
        }
        if (string.equals("0")) {
            return false;
        }
        return string.equals("1");
    }

    public String getDisplayName() throws CalendarException, OperationNotSupportedException {
        return this.getCalProps().getProperty("NAME");
    }

    public String getRelativeCalId() throws CalendarException, OperationNotSupportedException {
        return this.getCalProps().getProperty("RELATIVE-CALID");
    }

    public String getOwnerEmailId() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.getCalProps().getProperty("X-S1CS-EMAIL");
    }

    public int getInvitationsCount() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        String string = null;
        string = this.getCalProps().getProperty(INVITE_COUNT_KEY);
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public String getOwnerCommonName() throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.getCalProps().getProperty(OWNER_CN_KEY);
    }

    public CalendarComponent[] fetchComponents(DateTime dateTime, DateTime dateTime2, int n) throws CalendarException {
        return this.fetchComponents(dateTime, dateTime2, null, n);
    }

    public CalendarComponent[] fetchComponents(DateTime dateTime, DateTime dateTime2, Properties properties, int n) throws CalendarException {
        if (!SOCSUtils.isBitSet(n, 7)) {
            throw new CalendarException("Illegal Argument: Requested fetch component types \"" + n + "\" is found to be invalid. -- Not a valid mask of any of ICalendar.VEVENT, ICalendar.VTODO, ICalendar.VFREEBUSY or ICalendar.VALL", 105);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        int n2 = 0;
        if (SOCSUtils.isBitSet(n, 1)) {
            n2 |= 1;
        }
        if (SOCSUtils.isBitSet(n, 2)) {
            n2 |= 2;
        }
        if (0 != n2) {
            try {
                sOCSResponse = sOCSRequest.fetchEventsTodos(this.getCalID(), dateTime, dateTime2, properties, n2);
            }
            catch (SOCSException sOCSException) {
                throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
            }
            if (SOCSUtils.isBitSet(n2, 1)) {
                arrayList2 = sOCSResponse.getEvents();
            }
            if (SOCSUtils.isBitSet(n2, 2)) {
                arrayList3 = sOCSResponse.getTodos();
            }
            this.refresh(sOCSResponse);
        }
        if (SOCSUtils.isBitSet(n, 4)) {
            try {
                sOCSResponse = sOCSRequest.fetchFreeBusy(this.getCalID(), dateTime, dateTime2, properties);
            }
            catch (SOCSException sOCSException) {
                throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
            }
            arrayList4 = sOCSResponse.getFreeBusy();
            this.refresh(sOCSResponse);
        }
        if (null != arrayList2) {
            arrayList.addAll(arrayList2);
        }
        if (null != arrayList3) {
            arrayList.addAll(arrayList3);
        }
        if (null != arrayList4) {
            arrayList.addAll(arrayList4);
        }
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public CalendarComponent[] fetchComponents(String string, String string2, String string3) throws CalendarException, OperationNotSupportedException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.fetchEventsTodos(this.getCalID(), string, string2, string3, null, true);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList2 = sOCSResponse.getEvents();
        this.refresh(sOCSResponse);
        try {
            sOCSResponse = sOCSRequest.fetchEventsTodos(this.getCalID(), string, string2, string3, null, false);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList3 = sOCSResponse.getTodos();
        this.refresh(sOCSResponse);
        if (null != arrayList2) {
            arrayList.addAll(arrayList2);
        }
        if (null != arrayList3) {
            arrayList.addAll(arrayList3);
        }
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public CalendarComponent[] searchEvents(DateTime dateTime, DateTime dateTime2, String string, int n) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(dateTime, dateTime2, string, n, null);
    }

    public CalendarComponent[] searchEvents(DateTime dateTime, DateTime dateTime2, String string, int n, Properties properties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        ArrayList arrayList = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.searchEvents(this.getCalID(), dateTime, dateTime2, string, n, properties);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getEvents();
        this.refresh(sOCSResponse);
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public CalendarComponent[] searchEvents(String string, int n, Properties properties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(null, null, string, n, properties);
    }

    public CalendarComponent[] searchEvents(String string, int n) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchEvents(null, null, string, n, null);
    }

    public CalendarComponent[] searchTodos(DateTime dateTime, DateTime dateTime2, String string, int n) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(dateTime, dateTime2, string, n, null);
    }

    public CalendarComponent[] searchTodos(DateTime dateTime, DateTime dateTime2, String string, int n, Properties properties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        ArrayList arrayList = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.searchTodos(this.getCalID(), dateTime, dateTime2, string, n, properties);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getTodos();
        this.refresh(sOCSResponse);
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public CalendarComponent[] searchTodos(String string, int n) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(null, null, string, n, null);
    }

    public CalendarComponent[] searchTodos(String string, int n, Properties properties) throws CalendarException, OperationNotSupportedException {
        if (this.wcapVersionInUse < 310) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        return this.searchTodos(null, null, string, n, properties);
    }

    public static VFreeBusy fetchFreeBusy(String string, DateTime dateTime, DateTime dateTime2, String string2, int n, Properties properties) throws CalendarException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        SOCSResponse sOCSResponse = null;
        URLName uRLName = null;
        VFreeBusy vFreeBusy = null;
        if (string == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (string2 == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (n <= 0) {
            n = -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        uRLName = new URLName("http", string2, n, "", null, null);
        CalendarSession calendarSession = CalendarSession.getInstance(properties);
        SOCSCalendarStore sOCSCalendarStore = new SOCSCalendarStore(calendarSession);
        sOCSSession = SOCSSession.getInstance(sOCSCalendarStore);
        try {
            sOCSRequest = new SOCSRequest(uRLName.getURL(), sOCSSession);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarException(malformedURLException.getMessage(), 103);
        }
        if (sOCSRequest == null) {
            throw new CalendarException("Unable to obtain Free/Busy because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            sOCSResponse = sOCSRequest.fetchFreeBusy(string, dateTime, dateTime2, null);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CalendarException(illegalArgumentException.getMessage(), 105);
        }
        ArrayList arrayList = sOCSResponse.getFreeBusy();
        if (arrayList.size() > 0) {
            vFreeBusy = (VFreeBusy)arrayList.get(0);
        }
        return vFreeBusy;
    }

    public static CalendarComponent[] searchEvents(String string, DateTime dateTime, DateTime dateTime2, String string2, int n, String string3, int n2, Properties properties) throws CalendarException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        SOCSResponse sOCSResponse = null;
        URLName uRLName = null;
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (string3 == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (n2 <= 0) {
            n2 = -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        uRLName = new URLName("http", string3, n2, "", null, null);
        CalendarSession calendarSession = CalendarSession.getInstance(properties);
        SOCSCalendarStore sOCSCalendarStore = new SOCSCalendarStore(calendarSession);
        sOCSSession = SOCSSession.getInstance(sOCSCalendarStore);
        try {
            sOCSRequest = new SOCSRequest(uRLName.getURL(), sOCSSession);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarException(malformedURLException.getMessage(), 103);
        }
        if (sOCSRequest == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            sOCSResponse = sOCSRequest.searchEvents(string, dateTime, dateTime2, string2, n, null);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getEvents();
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public static VEvent[] fetchEvents(String string, String string2, String string3, String string4, String string5, int n, Properties properties) throws CalendarException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        SOCSResponse sOCSResponse = null;
        URLName uRLName = null;
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (string2 == null) {
            throw new CalendarException("Event uid is null ", 105);
        }
        if (string5 == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (n <= 0) {
            n = -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        uRLName = new URLName("http", string5, n, "", null, null);
        CalendarSession calendarSession = CalendarSession.getInstance(properties);
        SOCSCalendarStore sOCSCalendarStore = new SOCSCalendarStore(calendarSession);
        sOCSSession = SOCSSession.getInstance(sOCSCalendarStore);
        try {
            sOCSRequest = new SOCSRequest(uRLName.getURL(), sOCSSession);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarException(malformedURLException.getMessage(), 103);
        }
        if (sOCSRequest == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            sOCSResponse = sOCSRequest.fetchEventsTodos(string, string2, string3, string4, null, true);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getEvents();
        VEvent[] vEventArray = new VEvent[arrayList.size()];
        arrayList.toArray(vEventArray);
        return vEventArray;
    }

    public static CalendarComponent[] fetchComponents(String string, DateTime dateTime, DateTime dateTime2, int n, String string2, int n2, Properties properties) throws CalendarException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        SOCSResponse sOCSResponse = null;
        URLName uRLName = null;
        if (!SOCSUtils.isBitSet(n, 7)) {
            throw new CalendarException("Illegal Argument: Requested fetch component types \"" + n + "\" is found to be invalid. -- Not a valid mask of any of ICalendar.VEVENT, ICalendar.VTODO, ICalendar.VFREEBUSY or ICalendar.VALL", 105);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (string == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (string2 == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (n2 <= 0) {
            n2 = -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        uRLName = new URLName("http", string2, n2, "", null, null);
        CalendarSession calendarSession = CalendarSession.getInstance(properties);
        SOCSCalendarStore sOCSCalendarStore = new SOCSCalendarStore(calendarSession);
        sOCSSession = SOCSSession.getInstance(sOCSCalendarStore);
        try {
            sOCSRequest = new SOCSRequest(uRLName.getURL(), sOCSSession);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarException(malformedURLException.getMessage(), 103);
        }
        if (sOCSRequest == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        int n3 = 0;
        if (SOCSUtils.isBitSet(n, 1)) {
            n3 |= 1;
        }
        if (SOCSUtils.isBitSet(n, 2)) {
            n3 |= 2;
        }
        if (n3 != 0) {
            try {
                sOCSResponse = sOCSRequest.fetchEventsTodos(string, dateTime, dateTime2, null, n3);
            }
            catch (SOCSException sOCSException) {
                throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
            }
            if (SOCSUtils.isBitSet(n3, 1)) {
                arrayList2 = sOCSResponse.getEvents();
            }
            if (SOCSUtils.isBitSet(n3, 2)) {
                arrayList3 = sOCSResponse.getTodos();
            }
        }
        if (SOCSUtils.isBitSet(n, 4)) {
            try {
                sOCSResponse = sOCSRequest.fetchFreeBusy(string, dateTime, dateTime2, null);
            }
            catch (SOCSException sOCSException) {
                throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
            }
            arrayList4 = sOCSResponse.getFreeBusy();
        }
        if (!arrayList2.isEmpty()) {
            arrayList.addAll(arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            arrayList.addAll(arrayList3);
        }
        if (!arrayList4.isEmpty()) {
            arrayList.addAll(arrayList4);
        }
        CalendarComponent[] calendarComponentArray = new CalendarComponent[arrayList.size()];
        arrayList.toArray(calendarComponentArray);
        return calendarComponentArray;
    }

    public static Properties getCalProps(String string, String string2, int n, Properties properties) throws CalendarException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        SOCSResponse sOCSResponse = null;
        URLName uRLName = null;
        if (string == null) {
            throw new CalendarException("Illegal Calendar ID: null ", 110);
        }
        if (string2 == null) {
            throw new CalendarException("Host is null ", 105);
        }
        if (n <= 0) {
            n = -1;
        }
        if (properties == null) {
            properties = new Properties();
        }
        uRLName = new URLName("http", string2, n, "", null, null);
        CalendarSession calendarSession = CalendarSession.getInstance(properties);
        SOCSCalendarStore sOCSCalendarStore = new SOCSCalendarStore(calendarSession);
        sOCSSession = SOCSSession.getInstance(sOCSCalendarStore);
        try {
            sOCSRequest = new SOCSRequest(uRLName.getURL(), sOCSSession);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarException(malformedURLException.getMessage(), 103);
        }
        if (sOCSRequest == null) {
            throw new CalendarException("Unable to obtain Components because, either unable to connect to backend service or something wrong with the params", 104);
        }
        try {
            sOCSResponse = sOCSRequest.getCalProps(string);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        Properties properties2 = sOCSResponse.getProperties(1);
        return properties2;
    }

    public VEvent[] fetchEvents(String string, String string2, String string3) throws CalendarException, OperationNotSupportedException {
        return this.fetchEvents(string, string2, string3, null);
    }

    public VEvent[] fetchEvents(String string, String string2, String string3, Properties properties) throws CalendarException, OperationNotSupportedException {
        ArrayList arrayList = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.fetchEventsTodos(this.getCalID(), string, string2, string3, properties, true);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getEvents();
        this.refresh(sOCSResponse);
        if (null != arrayList) {
            VEvent[] vEventArray = new VEvent[arrayList.size()];
            arrayList.toArray(vEventArray);
            return vEventArray;
        }
        return null;
    }

    public VTodo[] fetchTodos(String string, String string2, String string3) throws CalendarException, OperationNotSupportedException {
        return this.fetchTodos(string, string2, string3, null);
    }

    public VTodo[] fetchTodos(String string, String string2, String string3, Properties properties) throws CalendarException, OperationNotSupportedException {
        ArrayList arrayList = new ArrayList();
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.fetchEventsTodos(this.getCalID(), string, string2, string3, properties, false);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        arrayList = sOCSResponse.getTodos();
        this.refresh(sOCSResponse);
        if (null != arrayList) {
            VTodo[] vTodoArray = new VTodo[arrayList.size()];
            arrayList.toArray(vTodoArray);
            return vTodoArray;
        }
        return null;
    }

    public Properties getCalProps() throws CalendarException, OperationNotSupportedException {
        if (this.getProperties(1) != null) {
            return this.getProperties(1);
        }
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.getCalProps(this.getCalID());
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        this.refresh(sOCSResponse);
        return this.getProperties(1);
    }

    public void setCalProps(Properties properties) throws CalendarException, OperationNotSupportedException {
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.setCalProps(this.getCalID(), properties);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        this.refresh(sOCSResponse);
    }

    public void addEvent(VEvent vEvent, boolean bl) throws CalendarException {
        if (!vEvent.hasProperty(SOCSEvent.STORETYPE) && this.wcapVersionInUse >= 300) {
            try {
                SOCSEvent sOCSEvent = (SOCSEvent)vEvent;
                sOCSEvent.setStoreType(SOCSEvent.STORETYPE_CREATE);
                vEvent = sOCSEvent;
            }
            catch (CalendarComponentException calendarComponentException) {
                throw new CalendarException(calendarComponentException.getMessage(), calendarComponentException.getError());
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                throw new CalendarException(operationNotSupportedException.getMessage(), operationNotSupportedException.getError());
            }
        }
        this.modifyEvent(vEvent, "THIS_INSTANCE", bl);
    }

    public void addTodo(VTodo vTodo, boolean bl) throws CalendarException {
        if (!vTodo.hasProperty(SOCSTodo.STORETYPE) && this.wcapVersionInUse >= 300) {
            try {
                SOCSTodo sOCSTodo = (SOCSTodo)vTodo;
                sOCSTodo.setStoreType(SOCSTodo.STORETYPE_CREATE);
                vTodo = sOCSTodo;
            }
            catch (CalendarComponentException calendarComponentException) {
                throw new CalendarException(calendarComponentException.getMessage(), calendarComponentException.getError());
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                throw new CalendarException(operationNotSupportedException.getMessage(), operationNotSupportedException.getError());
            }
        }
        this.modifyTodo(vTodo, "THIS_INSTANCE", bl);
    }

    public void modifyEvent(VEvent object, String string, boolean bl) throws CalendarException {
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            Object object2;
            Object object3;
            if (!((CalendarComponent)object).hasProperty(SOCSEvent.STORETYPE) && this.wcapVersionInUse >= 300) {
                object3 = (SOCSEvent)object;
                ((SOCSEvent)object3).setStoreType(SOCSEvent.STORETYPE_MODIFY);
                object2 = (Integer)((CalendarComponent)object3).getProperty("WCAP_VERSION_INT");
                int n = 0;
                if (object2 != null) {
                    n = (Integer)object2;
                }
                if (n <= 0) {
                    ((CalendarComponent)object3).setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                object = object3;
            }
            if (null != (object3 = (sOCSResponse = sOCSRequest.storeEvent(this.getCalID(), (VEvent)object, string, bl)).getEvents()) && ((ArrayList)object3).size() > 0) {
                object2 = (VEvent)((ArrayList)object3).get(0);
                ((CalendarComponent)object).setID(((CalendarComponent)object2).getID());
            }
            this.refresh(sOCSResponse);
        }
        catch (SOCSException sOCSException) {
            sOCSException.printStackTrace();
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        catch (CalendarComponentException calendarComponentException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
        }
    }

    public void modifyTodo(VTodo object, String string, boolean bl) throws CalendarException {
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            Object object2;
            Object object3;
            if (!((CalendarComponent)object).hasProperty(SOCSTodo.STORETYPE) && this.wcapVersionInUse >= 300) {
                object3 = (SOCSTodo)object;
                ((SOCSTodo)object3).setStoreType(SOCSTodo.STORETYPE_MODIFY);
                object2 = (Integer)((CalendarComponent)object3).getProperty("WCAP_VERSION_INT");
                int n = 0;
                if (object2 != null) {
                    n = (Integer)object2;
                }
                if (n <= 0) {
                    ((CalendarComponent)object3).setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
                }
                object = object3;
            }
            if (null != (object3 = (sOCSResponse = sOCSRequest.storeTodo(this.getCalID(), (VTodo)object, string, bl)).getTodos()) && ((ArrayList)object3).size() > 0) {
                object2 = (VTodo)((ArrayList)object3).get(0);
                ((CalendarComponent)object).setID(((CalendarComponent)object2).getID());
            }
            this.refresh(sOCSResponse);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
        }
        catch (CalendarComponentException calendarComponentException) {
        }
    }

    public void deleteEvent(VEvent vEvent, String string, boolean bl) throws CalendarException {
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.deleteevents(this.getCalID(), vEvent, string, bl);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        this.refresh(sOCSResponse);
    }

    public void deleteTodo(VTodo vTodo, String string, boolean bl) throws CalendarException {
        SOCSSession sOCSSession = this.getSOCSSession();
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSSession);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.deletetodos(this.getCalID(), vTodo, string, bl);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        this.refresh(sOCSResponse);
    }

    public void update() {
        try {
            this.setCalProps(this.properties[1]);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            return;
        }
        catch (CalendarException calendarException) {
            return;
        }
    }

    public String toRFC2445() {
        return "BEGIN:VCALENDAR\nVERSION:" + this.getVersion() + "\nPRODID:" + (null == this.getProductId() ? "" : this.getProductId()) + (null == this.getMethod() ? "" : "\nMETHOD:" + this.getMethod()) + (null == this.getCalScale() ? "" : "\nCALSCALE:" + this.getCalScale()) + this.convertToRFC2445(this.getEvents()) + this.convertToRFC2445(this.getTodos()) + this.convertToRFC2445(this.getFreeBusy()) + "\nEND:VCALENDAR";
    }

    public String toString() {
        return "SOCSCalendar[Version: " + this.getVersion() + "; ProdId: " + (null == this.getProductId() ? "" : this.getProductId()) + (null == this.getMethod() ? "" : "; Method: " + this.getMethod()) + (null == this.getCalScale() ? "" : "; CalScale: " + this.getCalScale()) + "\n; Events: " + this.convertToString(this.getEvents()) + "\n; Todos: " + this.convertToString(this.getTodos()) + "\n; FreeBusy: " + this.convertToString(this.getFreeBusy()) + "]";
    }

    public Properties getProperties(int n) {
        SOCSCalendar.checkWhich(n);
        return this.properties[n];
    }

    public static void checkWhich(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
    }

    public ArrayList getEvents() {
        return this.events;
    }

    public ArrayList getTodos() {
        return this.todos;
    }

    public ArrayList getFreeBusy() {
        return this.freebusys;
    }

    public int getErrorNum() {
        return this.errCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(SOCSResponse sOCSResponse) {
        if (null != sOCSResponse) {
            SOCSCalendar sOCSCalendar = this;
            synchronized (sOCSCalendar) {
                Properties properties;
                Properties properties2 = this.properties[1];
                this.properties[1] = properties = sOCSResponse.getProperties(1);
                if (null != properties2 && null != properties) {
                    if (null == properties.getProperty(OWNER_CN_KEY) && null != properties2.getProperty(OWNER_CN_KEY)) {
                        properties.setProperty(OWNER_CN_KEY, properties2.getProperty(OWNER_CN_KEY));
                    }
                    if (null == properties.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY) && null != properties2.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY)) {
                        properties.setProperty(IS_INCLUDED_IN_FREEBUSY_KEY, properties2.getProperty(IS_INCLUDED_IN_FREEBUSY_KEY));
                    }
                    if (null == properties.getProperty(INVITE_COUNT_KEY) && null != properties2.getProperty(INVITE_COUNT_KEY)) {
                        properties.setProperty(INVITE_COUNT_KEY, properties2.getProperty(INVITE_COUNT_KEY));
                    }
                }
            }
        }
    }

    private String convertToRFC2445(ArrayList arrayList) {
        String string = "";
        if (null == arrayList) {
            return string;
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = null;
            CalendarComponent calendarComponent = (CalendarComponent)arrayList.get(n);
            try {
                if (calendarComponent instanceof VFreeBusy) {
                    string2 = ((SOCSFreeBusy)calendarComponent).toRFC2445();
                } else if (calendarComponent instanceof VEvent) {
                    string2 = ((SOCSEvent)calendarComponent).toRFC2445();
                } else if (calendarComponent instanceof VTodo) {
                    string2 = ((SOCSTodo)calendarComponent).toRFC2445();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = null == string ? new String(string2) : string + "\n" + new String(string2);
            ++n;
        }
        return string;
    }

    private String convertToString(ArrayList arrayList) {
        String string = "";
        if (null == arrayList) {
            return string;
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = null;
            CalendarComponent calendarComponent = (CalendarComponent)arrayList.get(n);
            if (calendarComponent instanceof VFreeBusy) {
                string2 = ((VFreeBusy)calendarComponent).toString();
            } else if (calendarComponent instanceof VEvent) {
                string2 = ((VEvent)calendarComponent).toString();
            } else if (calendarComponent instanceof VTodo) {
                string2 = ((VTodo)calendarComponent).toString();
            }
            string = null == string ? new String(string2) : string + "\n" + new String(string2);
            ++n;
        }
        return string;
    }

    private SOCSSession getSOCSSession() throws CalendarException {
        CalendarStore calendarStore = this.getStore();
        if (calendarStore instanceof SOCSCalendarStore) {
            try {
                return ((SOCSCalendarStore)calendarStore).getSOCSSession();
            }
            catch (CalendarStoreException calendarStoreException) {
                throw new CalendarException(calendarStoreException.getMessage());
            }
        }
        throw new CalendarException("Incorrect CalendarStore ");
    }
}

